/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.mojang.math.Transformation;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class ModelAnimator {
    static final float PI = (float)Math.PI;
    static final float DEG_TO_RAD = (float)Math.PI / 180;
    static final float TAU = (float)Math.PI * 2;
    @Nullable
    static Cycle cycle;

    public static MeshTransformer scaling(float scaleX, float scaleY, float scaleZ) {
        float offsetY = 24.016f * (1.0f - scaleY);
        return part -> part.transformed(pose -> pose.scaled(scaleX, scaleY, scaleZ).translated(0.0f, offsetY, 0.0f));
    }

    public static MeshTransformer hierarchicalBaby(String headName, float scale) {
        return ModelAnimator.hierarchicalBaby(headName, scale, 1.0f);
    }

    public static MeshTransformer hierarchicalBaby(String headName, float scale, float headScale) {
        MeshTransformer bodyScaling = MeshTransformer.scaling((float)scale);
        return mesh -> bodyScaling.apply(ModelAnimator.transformChildPart(mesh, headName, pose -> pose.scaled(headScale / scale)));
    }

    public static MeshDefinition transformChildPart(MeshDefinition mesh, String targetName, UnaryOperator<PartPose> targetTransformer) {
        MeshDefinition result = new MeshDefinition();
        for (Map.Entry entry : mesh.getRoot().getChildren()) {
            result.getRoot().addOrReplaceChild((String)entry.getKey(), ModelAnimator.transformChildPart((PartDefinition)entry.getValue(), targetName, targetTransformer));
        }
        return result;
    }

    private static PartDefinition transformChildPart(PartDefinition part, String targetName, UnaryOperator<PartPose> targetTransformer) {
        PartDefinition result = part.transformed(pose -> pose);
        for (Map.Entry child : part.getChildren()) {
            if (((String)child.getKey()).equals(targetName)) {
                result.addOrReplaceChild(targetName, ((PartDefinition)child.getValue()).transformed(targetTransformer));
                continue;
            }
            result.addOrReplaceChild((String)child.getKey(), ModelAnimator.transformChildPart((PartDefinition)child.getValue(), targetName, targetTransformer));
        }
        return result;
    }

    public static PartDefinition clearAllChildren(PartDefinition part, String childName) {
        PartDefinition child = part.clearChild(childName);
        for (Map.Entry grandchild : List.copyOf(child.getChildren())) {
            ModelAnimator.clearAllChildren(child, (String)grandchild.getKey());
        }
        return child;
    }

    public static void look(ModelPart part, float yaw, float pitch) {
        part.xRot = pitch * ((float)Math.PI / 180);
        part.yRot = yaw * ((float)Math.PI / 180);
    }

    public static void look(ModelPart part, LivingEntityRenderState renderState) {
        ModelAnimator.look(part, renderState.yRot, renderState.xRot);
    }

    public static Cycle cycle(float time, float scale) {
        Cycle cycle = ModelAnimator.cycle;
        ModelAnimator.cycle = null;
        if (cycle == null) {
            cycle = new Cycle();
        }
        return cycle.set(time, scale);
    }

    public static void rotateAround(ModelPart part, Vector3f axis, float angle) {
        part.rotateBy(new Quaternionf().setAngleAxis(angle, axis.x, axis.y, axis.z));
    }

    public static void setRotation(ModelPart part, Quaternionf quaternion) {
        ModelAnimator.setRotationFromMatrix(part, new Matrix3f().rotation((Quaternionfc)quaternion));
    }

    private static void setRotationFromMatrix(ModelPart part, Matrix3f matrix) {
        Vector3f newAngles = matrix.getEulerAnglesZYX(new Vector3f());
        part.xRot = newAngles.x;
        part.yRot = newAngles.y;
        part.zRot = newAngles.z;
    }

    public static void rotateByInModelSpace(ModelPart[] path, ModelPart part, Quaternionf quaternion) {
        Quaternionf parentRotation = new Quaternionf();
        for (ModelPart parent : path) {
            parentRotation.rotateZYX(parent.zRot, parent.yRot, parent.xRot);
        }
        Quaternionf absoluteRotation = parentRotation.rotateZYX(part.zRot, part.yRot, part.xRot, new Quaternionf());
        Quaternionf newAbsoluteRotation = quaternion.mul((Quaternionfc)absoluteRotation, new Quaternionf());
        ModelAnimator.setRotation(part, newAbsoluteRotation.premul((Quaternionfc)parentRotation.conjugate()));
    }

    public static PartPose toPose(Matrix4f matrix) {
        Transformation transformation = new Transformation((Matrix4fc)matrix);
        Vector3f translation = transformation.getTranslation();
        Vector3f rotation = new Matrix3f().rotation((Quaternionfc)transformation.getLeftRotation()).rotate((Quaternionfc)transformation.getRightRotation()).getEulerAnglesZYX(new Vector3f());
        Vector3f scale = transformation.getScale();
        return new PartPose(translation.x, translation.y, translation.z, rotation.x, rotation.y, rotation.z, scale.x, scale.y, scale.z);
    }

    public static final class Cycle
    implements AutoCloseable {
        private float time;
        private float scale;

        Cycle set(float time, float scale) {
            this.time = time;
            this.scale = scale;
            return this;
        }

        public float eval(float speed, float scale) {
            return this.eval(speed, scale, 0.0f, 0.0f);
        }

        public float eval(float speed, float scale, float delay, float offset) {
            float x = this.time * speed - delay;
            return (Mth.sin((float)((float)Math.PI * 2 * x)) * scale + offset) * this.scale;
        }

        public float twitchSymmetric(float interval, float speed, float scale) {
            if (this.time * speed % interval > 1.0f) {
                return 0.0f;
            }
            float forward = Mth.square((float)this.eval(speed, 1.0f));
            float backward = Mth.square((float)this.eval(speed * 0.5f, 1.0f, 0.5f, 0.0f));
            return scale * (forward - 0.5f * backward);
        }

        public float twitchAsymmetric(float interval, float speed, float scale) {
            if (this.time * speed % interval > 1.0f) {
                return 0.0f;
            }
            return scale * Mth.square((float)this.eval(speed, 1.0f));
        }

        public float periodic(float interval, float fade, float length, float scale) {
            float animationLength = length + fade * 2.0f;
            float cycleLength = animationLength + interval;
            float animationTime = this.time % cycleLength - interval;
            if (animationTime < 0.0f) {
                return 0.0f;
            }
            if (animationTime < fade) {
                return Mth.sin((float)(animationTime / fade * 1.5707964f)) * scale;
            }
            if (animationTime > fade + length) {
                return Mth.sin((float)((animationLength - animationTime) / fade * 1.5707964f)) * scale;
            }
            return scale;
        }

        public float evalSkewed(float speed, float scale, float delay, float offset, float skew, float squareness) {
            float x = (float)Math.PI * 2 * (this.time * speed - delay);
            float modifiedSin = squareness * Mth.sin((float)x);
            float value = modifiedSin / Mth.sqrt((float)(Mth.square((float)(skew + Mth.cos((float)x))) + Mth.square((float)modifiedSin)));
            return (value * scale + offset) * this.scale;
        }

        public float time() {
            return this.time;
        }

        @Override
        public void close() {
            cycle = this;
        }
    }
}

