/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.Mth;
import net.tropicraft.core.client.entity.render.state.SeaTurtleRenderState;

public class SeaTurtleModel
extends EntityModel<SeaTurtleRenderState> {
    private final ModelPart body;
    private final ModelPart frFlipper;
    private final ModelPart flFlipper;
    private final ModelPart rlFlipper;
    private final ModelPart rrFlipper;

    public SeaTurtleModel(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.frFlipper = this.body.getChild("frFlipper");
        this.flFlipper = this.body.getChild("flFlipper");
        this.rlFlipper = this.body.getChild("rlFlipper");
        this.rrFlipper = this.body.getChild("rrFlipper");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().mirror().addBox("bodypart1", -4.5f, -1.0f, -9.0f, 9, 2, 1, 0, 29).addBox("bodypart2", -3.0f, -2.0f, 1.0f, 6, 1, 4, 43, 40).addBox("bodypart3", -7.0f, -2.0f, -8.0f, 14, 4, 8, 0, 52).addBox("bodypart4", -5.0f, -1.0f, 0.0f, 10, 3, 8, 0, 41).addBox("bodypart5", -4.0f, -2.5f, -6.0f, 8, 2, 7, 0, 32).addBox("bodypart6", -6.0f, -0.5f, 0.0f, 1, 2, 7, 44, 55).addBox("bodypart7", 5.0f, -0.5f, 0.0f, 1, 2, 7, 44, 55).addBox("bodypart8", -4.0f, -0.5f, 8.0f, 8, 2, 2, 0, 25), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        body.addOrReplaceChild("frFlipper", CubeListBuilder.create().mirror().texOffs(0, 20).addBox(-10.0f, 0.0f, -3.0f, 10.0f, 1.0f, 4.0f), PartPose.offset((float)-7.0f, (float)2.0f, (float)-6.0f));
        body.addOrReplaceChild("flFlipper", CubeListBuilder.create().mirror().texOffs(0, 20).addBox(0.0f, 0.0f, -3.0f, 10.0f, 1.0f, 4.0f), PartPose.offset((float)7.0f, (float)2.0f, (float)-6.0f));
        body.addOrReplaceChild("head", CubeListBuilder.create().mirror().texOffs(0, 0).addBox(-1.5f, -1.5f, -6.0f, 3.0f, 3.0f, 6.0f), PartPose.offset((float)0.0f, (float)1.0f, (float)-8.0f));
        body.addOrReplaceChild("rlFlipper", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-7.0f, 0.0f, -1.0f, 7.0f, 1.0f, 3.0f), PartPose.offset((float)-4.0f, (float)2.0f, (float)7.0f));
        body.addOrReplaceChild("rrFlipper", CubeListBuilder.create().mirror().texOffs(0, 16).addBox(-1.0f, 0.0f, -1.0f, 7.0f, 1.0f, 3.0f), PartPose.offset((float)4.0f, (float)2.0f, (float)7.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(SeaTurtleRenderState state) {
        super.setupAnim((EntityRenderState)state);
        float defFront = 0.3927f;
        float defFront2 = 0.3f;
        float defRear = 0.5f;
        if (!state.isInWater && !state.isVehicle) {
            float limbSwingAmount = state.walkAnimationSpeed * 3.0f;
            float limbSwing = state.walkAnimationPos * 2.0f;
            this.body.xRot = -Math.abs(Mth.sin((float)(limbSwing * 0.25f)) * 1.25f * limbSwingAmount) - 0.1f;
            this.frFlipper.xRot = defFront2;
            this.frFlipper.yRot = this.swimRotate(limbSwing, limbSwingAmount, 0.5f, 5.0f, 0.0f, defFront);
            this.frFlipper.zRot = this.swimRotate(limbSwing, limbSwingAmount, 0.5f, 1.25f, 0.0f, -defFront2);
            this.flFlipper.xRot = defFront2;
            this.flFlipper.yRot = this.swimRotate(limbSwing, limbSwingAmount, 0.5f, 5.0f, (float)Math.PI, -defFront2);
            this.flFlipper.zRot = -this.swimRotate(limbSwing, limbSwingAmount, 0.5f, 1.25f, 0.0f, -defFront2);
            this.rrFlipper.xRot = 0.0f;
            this.rrFlipper.yRot = -this.swimRotate(limbSwing, limbSwingAmount, 3.0f, 2.0f, 0.0f, defRear);
            this.rrFlipper.zRot = 0.0f;
            this.rlFlipper.xRot = 0.0f;
            this.rlFlipper.yRot = -this.swimRotate(limbSwing, limbSwingAmount, 3.0f, 2.0f, 0.0f, -defRear);
            this.rlFlipper.zRot = 0.0f;
        } else {
            float limbSwingAmount = state.walkAnimationSpeed * 0.75f;
            float limbSwing = state.walkAnimationPos * 0.1f;
            this.body.xRot = (float)Math.toRadians(state.xRot);
            this.frFlipper.yRot = this.swimRotate(limbSwing, limbSwingAmount, 1.25f, 1.5f, 0.0f, defFront);
            this.frFlipper.xRot = this.swimRotate(limbSwing, limbSwingAmount, 1.25f, 1.5f, 0.7853982f, defFront2 + 0.25f);
            this.frFlipper.zRot = 0.0f;
            this.flFlipper.yRot = -this.swimRotate(limbSwing, limbSwingAmount, 1.25f, 1.5f, 0.0f, defFront);
            this.flFlipper.zRot = 0.0f;
            this.flFlipper.xRot = this.swimRotate(limbSwing, limbSwingAmount, 1.25f, 1.5f, 0.7853982f, defFront2 + 0.25f);
            this.rlFlipper.xRot = this.swimRotate(limbSwing, limbSwingAmount, 5.0f, 0.5f, 0.7853982f, 0.0f);
            this.rrFlipper.xRot = this.swimRotate(limbSwing, limbSwingAmount, 5.0f, 0.5f, 0.7853982f, 0.0f);
            this.rrFlipper.yRot = -0.5f;
            this.rlFlipper.yRot = 0.5f;
            this.rrFlipper.zRot = this.swimRotate(limbSwing, limbSwingAmount, 5.0f, 0.5f, 0.0f, 0.5f);
            this.rlFlipper.zRot = this.swimRotate(limbSwing, limbSwingAmount, 5.0f, 0.5f, (float)Math.PI, -0.5f);
        }
    }

    private float swimRotate(float swing, float amount, float rot, float intensity, float rotOffset, float offset) {
        return Mth.cos((float)(swing * rot + rotOffset)) * amount * intensity + offset;
    }
}

