/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.util.Mth;

public class SharkModel
extends EntityModel<LivingEntityRenderState> {
    private final ModelPart Body3UpperLeft;
    private final ModelPart Body3LowerLeft;
    private final ModelPart Body3LowerRight;
    private final ModelPart FinPectoralLeft;
    private final ModelPart FinPectoralRight;
    private final ModelPart FinAdipose;
    private final ModelPart FinAnal;
    private final ModelPart FinCaudalUpper;
    private final ModelPart FinCaudalLower;

    public SharkModel(ModelPart root) {
        super(root);
        this.Body3UpperLeft = root.getChild("Body3UpperLeft");
        this.Body3LowerLeft = root.getChild("Body3LowerLeft");
        this.Body3LowerRight = root.getChild("Body3LowerRight");
        this.FinPectoralLeft = root.getChild("FinPectoralLeft");
        this.FinPectoralRight = root.getChild("FinPectoralRight");
        this.FinAdipose = root.getChild("FinAdipose");
        this.FinAnal = root.getChild("FinAnal");
        this.FinCaudalUpper = root.getChild("FinCaudalUpper");
        this.FinCaudalLower = root.getChild("FinCaudalLower");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("Head1", CubeListBuilder.create().texOffs(0, 24).mirror().addBox(-8.0f, -11.8f, -2.6f, 16.0f, 6.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-14.0f, (float)1.527163f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("Head3", CubeListBuilder.create().texOffs(0, 46).mirror().addBox(-2.5f, -7.0f, -3.9f, 5.0f, 14.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-14.0f, (float)1.48353f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("Body1Upper", CubeListBuilder.create().texOffs(18, 0).mirror().addBox(-2.5f, -17.0f, 0.0f, 5.0f, 18.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)1.780236f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("Body1Lower", CubeListBuilder.create().texOffs(28, 47).mirror().addBox(-4.0f, -11.0f, -5.0f, 8.0f, 12.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("Body2Upper", CubeListBuilder.create().texOffs(40, 0).mirror().addBox(-2.0f, -0.8f, 0.0f, 4.0f, 21.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)1.48353f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("Body2Lower", CubeListBuilder.create().texOffs(52, 39).mirror().addBox(-3.0f, 0.0f, -5.0f, 6.0f, 20.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)1.623156f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("Body3UpperLeft", CubeListBuilder.create().texOffs(60, 0).mirror().addBox(-1.0f, -0.3f, -1.0f, 2.0f, 15.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)22.0f, (float)1.48353f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("Body3LowerLeft", CubeListBuilder.create().texOffs(74, 45).mirror().addBox(0.0f, 0.0f, -4.0f, 2.0f, 14.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)22.0f, (float)1.692969f, (float)-0.0698132f, (float)0.0f));
        root.addOrReplaceChild("Body3LowerRight", CubeListBuilder.create().texOffs(74, 45).mirror().addBox(-2.0f, 0.0f, -4.0f, 2.0f, 14.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)22.0f, (float)1.692969f, (float)0.0698132f, (float)0.0f));
        root.addOrReplaceChild("FinPectoralLeft", CubeListBuilder.create().texOffs(88, 57).addBox(0.0f, 0.0f, 0.0f, 14.0f, 7.0f, 0.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)4.0f, (float)4.0f, (float)-7.0f, (float)2.007129f, (float)-0.7853982f, (float)0.4363323f));
        root.addOrReplaceChild("FinPectoralRight", CubeListBuilder.create().texOffs(88, 57).mirror().addBox(-14.0f, 0.0f, 0.0f, 14.0f, 7.0f, 0.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)-4.0f, (float)4.0f, (float)-7.0f, (float)2.007129f, (float)0.7853982f, (float)-0.4363323f));
        root.addOrReplaceChild("FinDorsal", CubeListBuilder.create().texOffs(94, -7).mirror().addBox(0.0f, -15.0f, -2.0f, 0.0f, 14.0f, 7.0f), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)4.0f, (float)-0.5235988f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("FinPelvicLeft", CubeListBuilder.create().texOffs(96, 52).addBox(0.0f, 0.0f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)3.0f, (float)4.0f, (float)17.0f, (float)2.181662f, (float)-0.7853982f, (float)0.6981317f));
        root.addOrReplaceChild("FinPelvicRight", CubeListBuilder.create().texOffs(96, 52).mirror().addBox(-5.0f, 0.0f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)-3.0f, (float)4.0f, (float)17.0f, (float)2.181662f, (float)0.7853982f, (float)-0.6981317f));
        root.addOrReplaceChild("FinAdipose", CubeListBuilder.create().texOffs(109, -3).mirror().addBox(0.0f, -5.0f, 0.0f, 0.0f, 5.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.8f, (float)24.0f, (float)-0.7853982f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("FinAnal", CubeListBuilder.create().texOffs(108, 47).mirror().addBox(0.0f, 0.0f, 0.0f, 0.0f, 5.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.6f, (float)25.0f, (float)0.8726646f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("FinCaudalUpper", CubeListBuilder.create().texOffs(116, -6).mirror().addBox(0.0f, -20.0f, -2.0f, 0.0f, 20.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)35.0f, (float)-0.9599311f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("FinCaudalLower", CubeListBuilder.create().texOffs(116, 46).mirror().addBox(0.0f, -12.53333f, -4.0f, 0.0f, 12.0f, 6.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)35.0f, (float)-2.356194f, (float)0.0f, (float)0.0f));
        root.addOrReplaceChild("Body3Lower", CubeListBuilder.create().texOffs(14, 48).mirror().addBox(3.0f, -21.0f, -5.6f, 2.0f, 11.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)1.500983f, (float)0.0907571f, (float)0.0f));
        root.addOrReplaceChild("Body4Lower", CubeListBuilder.create().texOffs(14, 48).mirror().addBox(-5.0f, -21.0f, -5.6f, 2.0f, 11.0f, 5.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)3.0f, (float)1.500983f, (float)-0.0907571f, (float)0.0f));
        root.addOrReplaceChild("Head2", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-3.0f, -8.8f, 0.0f, 6.0f, 9.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)-14.0f, (float)1.919862f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void setupAnim(LivingEntityRenderState state) {
        super.setupAnim((EntityRenderState)state);
        float timeScale = state.isInWater ? 0.05f : 0.2f;
        float ageInTicks = state.ageInTicks;
        this.FinPectoralLeft.zRot = 0.4f - Mth.sin((float)(ageInTicks * timeScale)) * 0.3f;
        this.FinPectoralRight.zRot = -0.4f - Mth.sin((float)(ageInTicks * timeScale)) * 0.3f;
        this.Body3UpperLeft.yRot = -Mth.sin((float)(ageInTicks * timeScale)) * 0.2f;
        this.Body3LowerLeft.yRot = -Mth.sin((float)(ageInTicks * timeScale)) * 0.2f;
        this.Body3LowerRight.yRot = -Mth.sin((float)(ageInTicks * timeScale)) * 0.2f;
        this.FinCaudalUpper.yRot = -Mth.sin((float)(ageInTicks * timeScale)) * 0.2f;
        this.FinCaudalLower.yRot = -Mth.sin((float)(ageInTicks * timeScale)) * 0.2f;
        this.FinAdipose.yRot = -Mth.sin((float)(ageInTicks * timeScale)) * 0.2f;
        this.FinAnal.yRot = -Mth.sin((float)(ageInTicks * timeScale)) * 0.2f;
    }
}

