/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.client.entity.render.state.SpiderMonkeyRenderState;

public class SpiderMonkeyModel
extends EntityModel<SpiderMonkeyRenderState> {
    private final ModelPart body_base;
    private final ModelPart head_base;
    private final ModelPart tail_a;
    private final ModelPart tail_b;
    private final ModelPart arm_left_a;
    private final ModelPart leg_left_a_r1;
    private final ModelPart leg_right_a_r1;
    private final ModelPart arm_right_a;

    public SpiderMonkeyModel(ModelPart root) {
        super(root);
        this.body_base = root.getChild("body_base");
        this.head_base = this.body_base.getChild("head_base");
        this.tail_a = this.body_base.getChild("tail_a");
        this.tail_b = this.tail_a.getChild("tail_b");
        this.arm_left_a = this.body_base.getChild("arm_left_a");
        ModelPart leg_left_a = this.body_base.getChild("leg_left_a");
        this.leg_left_a_r1 = leg_left_a.getChild("leg_left_a_r1");
        this.arm_right_a = this.body_base.getChild("arm_right_a");
        ModelPart leg_right_a = this.body_base.getChild("leg_right_a");
        this.leg_right_a_r1 = leg_right_a.getChild("leg_right_a_r1");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body_base", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -9.0f, -2.0f, 5.0f, 10.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)15.0f, (float)4.0f, (float)1.3962634f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head_base", CubeListBuilder.create().texOffs(17, 0).addBox(-2.0f, -4.0f, -3.0f, 4.0f, 4.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)0.0f, (float)-1.3089969f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("monke", CubeListBuilder.create().texOffs(9, 39).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offset((float)0.0f, (float)-1.5f, (float)-2.5f));
        PartDefinition tail = body.addOrReplaceChild("tail_a", CubeListBuilder.create().texOffs(0, 28).addBox(-1.0f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)1.134464f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("tail_b", CubeListBuilder.create().texOffs(0, 39).addBox(-0.99f, 0.0f, -2.0f, 2.0f, 6.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)7.5f, (float)1.0f, (float)-0.61086524f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("arm_left_a", CubeListBuilder.create().texOffs(9, 14).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 11.0f, 2.0f, false), PartPose.offsetAndRotation((float)-2.5f, (float)-7.5f, (float)-0.5f, (float)-1.4398966f, (float)0.04363323f, (float)0.04363323f));
        body.addOrReplaceChild("arm_right_a", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 11.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)-7.5f, (float)-0.5f, (float)-1.4398966f, (float)-0.04363323f, (float)-0.04363323f));
        PartDefinition legLeft = body.addOrReplaceChild("leg_left_a", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)1.0f, (float)-1.5f));
        legLeft.addOrReplaceChild("leg_left_a_r1", CubeListBuilder.create().texOffs(18, 28).addBox(-0.5f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3089969f, (float)0.08726646f, (float)-0.04363323f));
        PartDefinition legRight = body.addOrReplaceChild("leg_right_a", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)1.0f, (float)-1.5f));
        legRight.addOrReplaceChild("leg_right_a_r1", CubeListBuilder.create().texOffs(9, 28).addBox(-1.5f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.3089969f, (float)-0.08726646f, (float)0.04363323f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64).apply(MeshTransformer.scaling((float)0.7f));
    }

    public void setupAnim(SpiderMonkeyRenderState state) {
        super.setupAnim((EntityRenderState)state);
        this.head_base.xRot += state.xRot * ((float)Math.PI / 180);
        this.head_base.zRot -= state.yRot * ((float)Math.PI / 180);
        float standAngle = state.standAnimation * 70.0f * ((float)Math.PI / 180);
        this.body_base.xRot -= standAngle;
        this.head_base.xRot += standAngle;
        this.arm_right_a.xRot += standAngle;
        this.arm_left_a.xRot += standAngle;
        this.leg_left_a_r1.xRot += standAngle;
        this.leg_right_a_r1.xRot += standAngle;
        try (ModelAnimator.Cycle walk = ModelAnimator.cycle(state.walkAnimationPos * 0.2f, state.walkAnimationSpeed);){
            this.arm_left_a.xRot += walk.eval(1.0f, 1.0f);
            this.arm_right_a.xRot += walk.eval(-1.0f, 1.0f);
            this.leg_left_a_r1.xRot += walk.eval(-1.0f, 1.0f);
            this.leg_right_a_r1.xRot += walk.eval(1.0f, 1.0f);
        }
        try (ModelAnimator.Cycle idle = ModelAnimator.cycle(state.ageInTicks * 0.025f, 0.05f);){
            this.tail_a.xRot += idle.eval(1.0f, 1.0f, 0.0f, 0.0f);
            this.tail_b.xRot += idle.eval(1.0f, 1.0f, 0.2f, 0.0f);
        }
    }
}

