/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.MeshTransformer;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.tropicraft.core.client.entity.model.ModelAnimator;
import net.tropicraft.core.client.entity.render.state.TapirRenderState;

public class TapirModel
extends EntityModel<TapirRenderState> {
    private final ModelPart head_base;
    private final ModelPart leg_front_left;
    private final ModelPart leg_front_right;
    private final ModelPart leg_back_left;
    private final ModelPart leg_back_right;

    public TapirModel(ModelPart root) {
        super(root);
        ModelPart body_base = root.getChild("body_base");
        this.head_base = root.getChild("head_base");
        this.leg_front_left = body_base.getChild("leg_front_left");
        this.leg_front_right = body_base.getChild("leg_front_right");
        this.leg_back_left = body_base.getChild("leg_back_left");
        this.leg_back_right = body_base.getChild("leg_back_right");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        PartDefinition body = root.addOrReplaceChild("body_base", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -3.0f, -11.0f, 10.0f, 10.0f, 18.0f, false), PartPose.offset((float)0.0f, (float)7.0f, (float)3.0f));
        PartDefinition head = root.addOrReplaceChild("head_base", CubeListBuilder.create().texOffs(0, 29).addBox(-4.0f, -3.0f, -10.0f, 8.0f, 8.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)-8.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("tail_base", CubeListBuilder.create().texOffs(4, 0).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 5.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)7.0f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition trunk = head.addOrReplaceChild("trunk_base", CubeListBuilder.create().texOffs(41, 0).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 4.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-10.0f, (float)0.6109f, (float)0.0f, (float)0.0f));
        trunk.addOrReplaceChild("trunk_tip", CubeListBuilder.create().mirror(false).texOffs(40, 10).addBox(-2.0f, 0.0f, -3.0f, 4.0f, 4.0f, 3.0f, new CubeDeformation(0.001f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-4.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition earLeft = head.addOrReplaceChild("ear_left", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.0f, (float)-3.0f, (float)-2.0f, (float)0.0f, (float)0.2618f, (float)0.3491f));
        earLeft.addOrReplaceChild("ear_left_r1", CubeListBuilder.create().texOffs(17, 70).addBox(0.0f, -2.0f, -2.0f, 1.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition earRight = head.addOrReplaceChild("ear_right", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)-3.0f, (float)-2.0f, (float)0.0f, (float)-0.2618f, (float)-0.3491f));
        earRight.addOrReplaceChild("ear_right_r1", CubeListBuilder.create().texOffs(17, 63).addBox(-1.0f, -2.0f, -2.0f, 1.0f, 3.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("leg_front_left", CubeListBuilder.create().texOffs(0, 63).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, false), PartPose.offset((float)3.0f, (float)7.0f, (float)-9.0f));
        body.addOrReplaceChild("leg_front_right", CubeListBuilder.create().texOffs(34, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, false), PartPose.offset((float)-3.0f, (float)7.0f, (float)-9.0f));
        body.addOrReplaceChild("leg_back_left", CubeListBuilder.create().texOffs(17, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, false), PartPose.offset((float)3.0f, (float)7.0f, (float)4.0f));
        body.addOrReplaceChild("leg_back_right", CubeListBuilder.create().texOffs(0, 48).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f, false), PartPose.offset((float)-3.0f, (float)7.0f, (float)4.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)128, (int)128).apply(MeshTransformer.scaling((float)0.8f));
    }

    public static LayerDefinition createBaby() {
        return TapirModel.create().apply(ModelAnimator.hierarchicalBaby("head_base", 0.5f));
    }

    public void setupAnim(TapirRenderState state) {
        super.setupAnim((EntityRenderState)state);
        ModelAnimator.look(this.head_base, state);
        try (ModelAnimator.Cycle walk = ModelAnimator.cycle(state.walkAnimationPos * 0.1f, state.walkAnimationSpeed);){
            this.leg_front_left.xRot = walk.eval(1.0f, 1.0f);
            this.leg_front_right.xRot = walk.eval(-1.0f, 1.0f);
            this.leg_back_left.xRot = walk.eval(-1.0f, 1.0f);
            this.leg_back_right.xRot = walk.eval(1.0f, 1.0f);
        }
    }

    public ModelPart head() {
        return this.head_base;
    }
}

