/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.render.state.AshenMaskRenderState;
import net.tropicraft.core.common.entity.placeable.AshenMaskEntity;
import org.joml.Quaternionfc;

public class AshenMaskRenderer
extends EntityRenderer<AshenMaskEntity, AshenMaskRenderState> {
    private static final ResourceLocation TEXTURE = Tropicraft.location("textures/entity/ashen/mask.png");
    private final TropicraftSpecialRenderHelper mask;

    public AshenMaskRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.shadowStrength = 0.5f;
        this.mask = new TropicraftSpecialRenderHelper();
    }

    public AshenMaskRenderState createRenderState() {
        return new AshenMaskRenderState();
    }

    public void extractRenderState(AshenMaskEntity entity, AshenMaskRenderState state, float partialTicks) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTicks);
        state.maskType = entity.getMaskType();
    }

    public void render(AshenMaskRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
        this.mask.renderMask(poseStack, bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)TEXTURE)), state.maskType, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

