/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.AshenModel;
import net.tropicraft.core.client.entity.render.layer.AshenHeldItemLayer;
import net.tropicraft.core.client.entity.render.layer.AshenMaskLayer;
import net.tropicraft.core.client.entity.render.state.AshenRenderState;
import net.tropicraft.core.common.entity.hostile.AshenEntity;

public class AshenRenderer
extends MobRenderer<AshenEntity, AshenRenderState, AshenModel> {
    private static final ResourceLocation TEXTURE = Tropicraft.location("textures/entity/ashen/ashen.png");
    private final ItemModelResolver itemModelResolver;

    public AshenRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AshenModel(context.bakeLayer(TropicraftRenderLayers.ASHEN_LAYER)), 0.5f);
        this.itemModelResolver = context.getItemModelResolver();
        this.addLayer(new AshenMaskLayer(this, new AshenModel(context.bakeLayer(TropicraftRenderLayers.ASHEN_LAYER))));
        this.addLayer((RenderLayer)new AshenHeldItemLayer(this, (AshenModel)this.model));
        this.shadowStrength = 0.5f;
        this.shadowRadius = 0.3f;
    }

    public AshenRenderState createRenderState() {
        return new AshenRenderState();
    }

    public void extractRenderState(AshenEntity entity, AshenRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        ArmedEntityRenderState.extractArmedEntityRenderState((LivingEntity)entity, (ArmedEntityRenderState)state, (ItemModelResolver)this.itemModelResolver);
        state.actionState = entity.getActionState();
        if (entity.getTarget() != null && entity.closerThan((Entity)entity.getTarget(), 5.0) && !entity.swinging) {
            state.swinging = true;
        } else if (entity.swinging && entity.swingTime > 6) {
            state.swinging = false;
        }
        state.hasMask = entity.hasMask();
        state.maskType = entity.getMaskType();
    }

    public ResourceLocation getTextureLocation(AshenRenderState state) {
        return TEXTURE;
    }
}

