/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MapRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemFrameRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemFrameRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.RenderItemInFrameEvent;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.tropicraft.core.common.entity.BambooItemFrame;
import org.joml.Quaternionfc;

public class BambooItemFrameRenderer
extends ItemFrameRenderer<BambooItemFrame> {
    public static final StateDefinition<Block, BlockState> FAKE_BLOCK_STATE = new StateDefinition.Builder((Object)Blocks.AIR).add(new Property[]{BlockStateProperties.MAP}).create(Block::defaultBlockState, BlockState::new);
    private final MapRenderer mapRenderer;
    private final BlockRenderDispatcher blockRenderer;

    public BambooItemFrameRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.mapRenderer = context.getMapRenderer();
        this.blockRenderer = context.getBlockRenderDispatcher();
    }

    public void render(ItemFrameRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float yRot;
        float xRot;
        RenderNameTagEvent.DoRender event;
        if (state.nameTag != null && !((RenderNameTagEvent.DoRender)NeoForge.EVENT_BUS.post((Event)(event = new RenderNameTagEvent.DoRender((EntityRenderState)state, state.nameTag, (EntityRenderer)this, poseStack, bufferSource, packedLight, state.partialTick)))).isCanceled()) {
            this.renderNameTag((EntityRenderState)state, state.nameTag, poseStack, bufferSource, packedLight);
        }
        poseStack.pushPose();
        Direction direction = state.direction;
        Vec3 offset = this.getRenderOffset(state);
        poseStack.translate(-offset.x(), -offset.y(), -offset.z());
        double step = 0.46875;
        poseStack.translate((double)direction.getStepX() * step, (double)direction.getStepY() * step, (double)direction.getStepZ() * step);
        if (direction.getAxis().isHorizontal()) {
            xRot = 0.0f;
            yRot = 180.0f - direction.toYRot();
        } else {
            xRot = -90.0f * (float)direction.getAxisDirection().getStep();
            yRot = 180.0f;
        }
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(xRot));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(yRot));
        if (!state.isInvisible) {
            BlockState fakeBlockState = (BlockState)((BlockState)FAKE_BLOCK_STATE.any()).setValue((Property)BlockStateProperties.MAP, (Comparable)Boolean.valueOf(state.mapId != null));
            BlockStateModel model = this.blockRenderer.getBlockModel(fakeBlockState);
            poseStack.pushPose();
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            ModelBlockRenderer.renderModel((PoseStack.Pose)poseStack.last(), (VertexConsumer)bufferSource.getBuffer(RenderType.entitySolidZOffsetForward((ResourceLocation)TextureAtlas.LOCATION_BLOCKS)), (BlockStateModel)model, (float)1.0f, (float)1.0f, (float)1.0f, (int)packedLight, (int)OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
        }
        if (state.isInvisible) {
            poseStack.translate(0.0f, 0.0f, 0.5f);
        } else {
            poseStack.translate(0.0f, 0.0f, 0.4375f);
        }
        if (!((RenderItemInFrameEvent)NeoForge.EVENT_BUS.post((Event)new RenderItemInFrameEvent(state, (ItemFrameRenderer)this, poseStack, bufferSource, packedLight))).isCanceled()) {
            if (state.mapId != null) {
                int rotation = state.rotation % 4 * 2;
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)rotation * 360.0f / 8.0f));
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
                float scale = 0.0078125f;
                poseStack.scale(scale, scale, scale);
                poseStack.translate(-64.0f, -64.0f, 0.0f);
                poseStack.translate(0.0f, 0.0f, -1.0f);
                this.mapRenderer.render(state.mapRenderState, poseStack, bufferSource, true, packedLight);
            } else if (!state.item.isEmpty()) {
                poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)state.rotation * 360.0f / 8.0f));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                state.item.render(poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
        poseStack.popPose();
    }
}

