/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.render.layer.CowktailLayer;
import net.tropicraft.core.client.entity.render.state.CowktailRenderState;
import net.tropicraft.core.common.entity.passive.CowktailEntity;

public class CowktailRenderer
extends AgeableMobRenderer<CowktailEntity, CowktailRenderState, CowModel> {
    private static final ResourceLocation IRIS_TEXTURE = Tropicraft.location("textures/entity/cowktail/iris_cowktail.png");
    private static final ResourceLocation ANEMONE_TEXTURE = Tropicraft.location("textures/entity/cowktail/anemone_cowktail.png");

    public CowktailRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new CowModel(context.bakeLayer(TropicraftRenderLayers.COWKTAIL_LAYER)), (EntityModel)new CowModel(context.bakeLayer(TropicraftRenderLayers.COWKTAIL_BABY_LAYER)), 0.7f);
        this.addLayer(new CowktailLayer(this, context.getBlockRenderDispatcher()));
    }

    public CowktailRenderState createRenderState() {
        return new CowktailRenderState();
    }

    public void extractRenderState(CowktailEntity entity, CowktailRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        state.type = entity.getCowktailType();
    }

    public ResourceLocation getTextureLocation(CowktailRenderState state) {
        return switch (state.type) {
            default -> throw new MatchException(null, null);
            case CowktailEntity.Type.IRIS -> IRIS_TEXTURE;
            case CowktailEntity.Type.ANEMONE -> ANEMONE_TEXTURE;
        };
    }
}

