/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.EIHModel;
import net.tropicraft.core.client.entity.render.state.EIHRenderState;
import net.tropicraft.core.common.entity.neutral.EIHEntity;

public class EIHRenderer
extends MobRenderer<EIHEntity, EIHRenderState, EIHModel> {
    private static final ResourceLocation TEXTURE_SLEEP = Tropicraft.location("textures/entity/eih/headtext.png");
    private static final ResourceLocation TEXTURE_AWARE = Tropicraft.location("textures/entity/eih/headawaretext.png");
    private static final ResourceLocation TEXTURE_ANGRY = Tropicraft.location("textures/entity/eih/headangrytext.png");

    public EIHRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new EIHModel(context.bakeLayer(TropicraftRenderLayers.EIH_LAYER)), 1.2f);
    }

    public EIHRenderState createRenderState() {
        return new EIHRenderState();
    }

    public void extractRenderState(EIHEntity entity, EIHRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        state.angry = entity.isAngry();
        state.aware = entity.isAware();
    }

    public ResourceLocation getTextureLocation(EIHRenderState state) {
        if (state.aware) {
            return TEXTURE_AWARE;
        }
        if (state.angry) {
            return TEXTURE_ANGRY;
        }
        return TEXTURE_SLEEP;
    }
}

