/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.model.EggModel;
import net.tropicraft.core.client.entity.render.state.EggRenderState;
import net.tropicraft.core.common.entity.egg.EggEntity;
import org.joml.Quaternionfc;

public class EggRenderer
extends LivingEntityRenderer<EggEntity, EggRenderState, EggModel> {
    public EggRenderer(EntityRendererProvider.Context context, ModelLayerLocation modelLayerLocation) {
        super(context, (EntityModel)new EggModel(context.bakeLayer(modelLayerLocation)), 1.0f);
        this.shadowStrength = 0.5f;
    }

    public void render(EggRenderState state, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.pushPose();
        if (state.shouldRenderFlat) {
            this.shadowRadius = 0.0f;
            stack.translate(0.0, 0.05, 0.0);
            this.drawFlatEgg(state, stack, bufferIn, packedLightIn);
        } else {
            this.shadowRadius = 0.2f;
            stack.scale(0.5f, 0.5f, 0.5f);
            super.render((LivingEntityRenderState)state, stack, bufferIn, packedLightIn);
        }
        stack.popPose();
    }

    public void drawFlatEgg(EggRenderState state, PoseStack stack, MultiBufferSource bufferIn, int packedLightIn) {
        stack.pushPose();
        stack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        stack.scale(0.25f, 0.25f, 0.25f);
        ResourceLocation resourceLocation = this.getTextureLocation(state);
        VertexConsumer buffer = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)resourceLocation));
        int overlay = OverlayTexture.NO_OVERLAY;
        PoseStack.Pose pose = stack.last();
        TropicraftSpecialRenderHelper.vertex(buffer, pose, -0.5, -0.25, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, pose, 0.5, -0.25, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, pose, 0.5, 0.75, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, pose, -0.5, 0.75, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP, packedLightIn, overlay);
        stack.popPose();
    }

    public EggRenderState createRenderState() {
        return new EggRenderState();
    }

    public void extractRenderState(EggEntity entity, EggRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        state.hatching = entity.isNearHatching();
        state.randRotater = (float)entity.rotationRand;
        state.texture = entity.getEggTexture();
        state.shouldRenderFlat = entity.shouldEggRenderFlat();
    }

    protected boolean shouldShowName(EggEntity entity, double distanceToCameraSq) {
        return entity.hasCustomName();
    }

    protected boolean affectedByCulling(EggEntity display) {
        return false;
    }

    public ResourceLocation getTextureLocation(EggRenderState state) {
        return Tropicraft.location("textures/entity/" + state.texture + ".png");
    }
}

