/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.FishingHookRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;
import org.joml.Quaternionfc;

public class FishingBobberEntityRenderer
extends EntityRenderer<FishingBobberEntity, FishingHookRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/fishing_hook.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutout((ResourceLocation)TEXTURE_LOCATION);

    public FishingBobberEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public FishingHookRenderState createRenderState() {
        return new FishingHookRenderState();
    }

    public void extractRenderState(FishingBobberEntity entity, FishingHookRenderState state, float partialTicks) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTicks);
        EntityKoaBase koa = entity.getAngler();
        if (koa == null) {
            state.lineOriginOffset = Vec3.ZERO;
        } else {
            Vec3 handPos = FishingBobberEntityRenderer.getHandPos(koa, partialTicks);
            Vec3 targetPos = entity.getPosition(partialTicks).add(0.0, 0.25, 0.0);
            state.lineOriginOffset = handPos.subtract(targetPos);
        }
    }

    public static HumanoidArm getHoldingArm(EntityKoaBase koa) {
        return koa.getMainHandItem().canPerformAction(ItemAbilities.FISHING_ROD_CAST) ? koa.getMainArm() : koa.getMainArm().getOpposite();
    }

    private static Vec3 getHandPos(EntityKoaBase koa, float partialTick) {
        int side = FishingBobberEntityRenderer.getHoldingArm(koa) == HumanoidArm.RIGHT ? 1 : -1;
        float yRot = Mth.lerp((float)partialTick, (float)koa.yBodyRotO, (float)koa.yBodyRot) * ((float)Math.PI / 180);
        double sin = Mth.sin((float)yRot);
        double cos = Mth.cos((float)yRot);
        float scale = koa.getScale();
        double right = (double)side * 0.35 * (double)scale;
        double forward = 0.8 * (double)scale;
        float yOffset = koa.isCrouching() ? -0.1875f : 0.0f;
        return koa.getEyePosition(partialTick).add(-cos * right - sin * forward, (double)yOffset - 0.45 * (double)scale, -sin * right + cos * forward);
    }

    public boolean shouldRender(FishingBobberEntity entity, Frustum frustum, double cameraX, double cameraY, double cameraZ) {
        return super.shouldRender((Entity)entity, frustum, cameraX, cameraY, cameraZ) && entity.getAngler() != null;
    }

    protected boolean affectedByCulling(FishingBobberEntity display) {
        return false;
    }

    public void render(FishingHookRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)this.entityRenderDispatcher.cameraOrientation());
        PoseStack.Pose bobberPose = poseStack.last();
        VertexConsumer bobberBuffer = bufferSource.getBuffer(RENDER_TYPE);
        FishingBobberEntityRenderer.vertex(bobberBuffer, bobberPose, packedLight, 0.0f, 0, 0, 1);
        FishingBobberEntityRenderer.vertex(bobberBuffer, bobberPose, packedLight, 1.0f, 0, 1, 1);
        FishingBobberEntityRenderer.vertex(bobberBuffer, bobberPose, packedLight, 1.0f, 1, 1, 0);
        FishingBobberEntityRenderer.vertex(bobberBuffer, bobberPose, packedLight, 0.0f, 1, 0, 0);
        poseStack.popPose();
        float originX = (float)state.lineOriginOffset.x;
        float originY = (float)state.lineOriginOffset.y;
        float originZ = (float)state.lineOriginOffset.z;
        VertexConsumer lineBuffer = bufferSource.getBuffer(RenderType.lineStrip());
        PoseStack.Pose linePose = poseStack.last();
        int steps = 16;
        for (int i = 0; i <= steps; ++i) {
            FishingBobberEntityRenderer.stringVertex(originX, originY, originZ, lineBuffer, linePose, FishingBobberEntityRenderer.fraction(i, steps), FishingBobberEntityRenderer.fraction(i + 1, steps));
        }
        poseStack.popPose();
        super.render((EntityRenderState)state, poseStack, bufferSource, packedLight);
    }

    private static float fraction(int numerator, int denominator) {
        return (float)numerator / (float)denominator;
    }

    private static void vertex(VertexConsumer consumer, PoseStack.Pose pose, int packedLight, float x, int y, int u, int v) {
        consumer.addVertex(pose, x - 0.5f, (float)y - 0.5f, 0.0f).setColor(-1).setUv((float)u, (float)v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, 0.0f, 1.0f, 0.0f);
    }

    private static void stringVertex(float originX, float originY, float originZ, VertexConsumer consumer, PoseStack.Pose pose, float stringFraction, float nextStringFraction) {
        float x = originX * stringFraction;
        float y = originY * (stringFraction * stringFraction + stringFraction) * 0.5f + 0.25f;
        float z = originZ * stringFraction;
        float normalX = originX * nextStringFraction - x;
        float normalY = originY * (nextStringFraction * nextStringFraction + nextStringFraction) * 0.5f + 0.25f - y;
        float normalZ = originZ * nextStringFraction - z;
        float normalLength = Mth.sqrt((float)(normalX * normalX + normalY * normalY + normalZ * normalZ));
        consumer.addVertex(pose, x, y, z).setColor(-16777216).setNormal(pose, normalX /= normalLength, normalY /= normalLength, normalZ /= normalLength);
    }
}

