/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.KoaModel;
import net.tropicraft.core.client.entity.render.state.KoaRenderState;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class KoaRenderer
extends HumanoidMobRenderer<EntityKoaBase, KoaRenderState, KoaModel> {
    private static final ResourceLocation MALE_FISHER = Tropicraft.location("textures/entity/koa/koa_man_fisher.png");
    private static final ResourceLocation FEMALE_FISHER = Tropicraft.location("textures/entity/koa/koa_woman_fisher.png");
    private static final ResourceLocation MALE_HUNTER = Tropicraft.location("textures/entity/koa/koa_man_hunter.png");
    private static final ResourceLocation FEMALE_HUNTER = Tropicraft.location("textures/entity/koa/koa_woman_hunter.png");

    public KoaRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new KoaModel(context.bakeLayer(TropicraftRenderLayers.KOA_HUNTER_LAYER)), (HumanoidModel)new KoaModel(context.bakeLayer(TropicraftRenderLayers.KOA_HUNTER_BABY_LAYER)), 0.5f);
        this.shadowStrength = 0.5f;
    }

    public KoaRenderState createRenderState() {
        return new KoaRenderState();
    }

    public void extractRenderState(EntityKoaBase entity, KoaRenderState state, float partialTicks) {
        super.extractRenderState((Mob)entity, (HumanoidRenderState)state, partialTicks);
        state.isDancing = entity.isDancing();
        state.isSitting = entity.isSitting();
        state.gender = entity.getGender();
        state.role = entity.getRole();
    }

    public ResourceLocation getTextureLocation(KoaRenderState state) {
        return switch (state.gender) {
            default -> throw new MatchException(null, null);
            case EntityKoaBase.Genders.MALE -> {
                switch (state.role) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case HUNTER: {
                        yield MALE_HUNTER;
                    }
                    case FISHERMAN: 
                }
                yield MALE_FISHER;
            }
            case EntityKoaBase.Genders.FEMALE -> {
                switch (state.role) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case HUNTER: {
                        yield FEMALE_HUNTER;
                    }
                    case FISHERMAN: 
                }
                yield FEMALE_FISHER;
            }
        };
    }

    public Vec3 getRenderOffset(KoaRenderState state) {
        if (state.isSitting) {
            if (state.isBaby) {
                return new Vec3(0.0, -0.3, 0.0);
            }
            return new Vec3(0.0, -0.7, 0.0);
        }
        return super.getRenderOffset((EntityRenderState)state);
    }

    @Nullable
    protected RenderType getRenderType(KoaRenderState state, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        return RenderType.entityCutout((ResourceLocation)this.getTextureLocation(state));
    }
}

