/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.util.Mth;
import net.minecraft.util.TriState;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderNameTagEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.entity.SeaTurtleEntity;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft")
public class PlayerRotationHandler {
    private static final ContextKey<BeachFloatState> BEACH_FLOAT_KEY = new ContextKey(Tropicraft.location("beach_float"));
    private static final ContextKey<TurtleState> TURTLE_KEY = new ContextKey(Tropicraft.location("sea_turtle"));

    @SubscribeEvent
    public static void onRegisterRenderStateModifiers(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(PlayerRenderer.class, (player, state) -> {
            Entity patt0$temp = player.getVehicle();
            if (patt0$temp instanceof BeachFloatEntity) {
                BeachFloatEntity beachFloat = (BeachFloatEntity)patt0$temp;
                state.yRot = 0.0f;
                state.xRot = 10.0f;
                state.walkAnimationPos = 0.0f;
                state.walkAnimationSpeed = 0.0f;
                Vec3 attachment = beachFloat.getAttachments().getClamped(EntityAttachment.PASSENGER, 0, 0.0f);
                float playerHeight = player.getDimensions(Pose.STANDING).height();
                state.setRenderData(BEACH_FLOAT_KEY, (Object)new BeachFloatState(Mth.rotLerp((float)state.partialTick, (float)beachFloat.yRotO, (float)beachFloat.getYRot()), (float)(-attachment.x), (float)(-attachment.y + 0.8125), (float)((double)playerHeight / 2.0 - attachment.z)));
            } else {
                Entity patt1$temp = player.getVehicle();
                if (patt1$temp instanceof SeaTurtleEntity) {
                    SeaTurtleEntity turtle = (SeaTurtleEntity)patt1$temp;
                    state.xRot = 10.0f;
                    Vec3 sitOffset = player.getAttachments().getClamped(EntityAttachment.VEHICLE, 0, 0.0f);
                    state.setRenderData(TURTLE_KEY, (Object)new TurtleState(Mth.rotLerp((float)state.partialTick, (float)turtle.xRotO, (float)turtle.getXRot()), Mth.rotLerp((float)state.partialTick, (float)turtle.yHeadRotO, (float)turtle.yHeadRot), (float)sitOffset.x, (float)sitOffset.y, (float)sitOffset.z));
                }
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        TurtleState turtleState;
        PoseStack stack = event.getPoseStack();
        PlayerRenderState state = (PlayerRenderState)event.getRenderState();
        BeachFloatState floatState = (BeachFloatState)state.getRenderData(BEACH_FLOAT_KEY);
        if (floatState != null) {
            stack.pushPose();
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-floatState.yRot));
            stack.translate(floatState.offsetX, floatState.offsetY, floatState.offsetZ);
            stack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.bodyRot));
        }
        if ((turtleState = (TurtleState)state.getRenderData(TURTLE_KEY)) != null) {
            stack.pushPose();
            Quaternionf rotation = Axis.YN.rotationDegrees(turtleState.yRot).mul((Quaternionfc)Axis.XP.rotationDegrees(turtleState.xRot)).mul((Quaternionfc)Axis.YP.rotationDegrees(turtleState.yRot));
            stack.rotateAround((Quaternionfc)rotation, turtleState.offsetX, turtleState.offsetY - 0.1f, turtleState.offsetZ);
            Vec3 passengerOffset = new Vec3(-0.25, 0.0, 0.0).yRot((float)(-Math.toRadians(turtleState.yRot) - 1.5707963267948966));
            stack.translate(passengerOffset.x(), 0.0, passengerOffset.z());
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        PlayerRenderState state = (PlayerRenderState)event.getRenderState();
        if (state.getRenderData(BEACH_FLOAT_KEY) != null || state.getRenderData(TURTLE_KEY) != null) {
            event.getPoseStack().popPose();
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerSpecials(RenderNameTagEvent.CanRender event) {
        BeachFloatState floatState = (BeachFloatState)event.getEntityRenderState().getRenderData(BEACH_FLOAT_KEY);
        if (floatState != null) {
            event.setCanRender(TriState.FALSE);
        }
    }

    private record BeachFloatState(float yRot, float offsetX, float offsetY, float offsetZ) {
    }

    private record TurtleState(float xRot, float yRot, float offsetX, float offsetY, float offsetZ) {
    }
}

