/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.SeaUrchinModel;
import net.tropicraft.core.client.entity.render.state.SeaUrchinRenderState;
import net.tropicraft.core.common.entity.underdasea.SeaUrchinEntity;

public class SeaUrchinRenderer
extends MobRenderer<SeaUrchinEntity, SeaUrchinRenderState, SeaUrchinModel> {
    public static final float BABY_RENDER_SCALE = 0.25f;
    public static final float ADULT_RENDER_SCALE = 0.5f;
    public static final ResourceLocation SEA_URCHIN_TEXTURE = Tropicraft.location("textures/entity/seaurchin.png");

    public SeaUrchinRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SeaUrchinModel(context.bakeLayer(TropicraftRenderLayers.SEA_URCHIN_LAYER)), 0.5f);
    }

    public SeaUrchinRenderState createRenderState() {
        return new SeaUrchinRenderState();
    }

    public void extractRenderState(SeaUrchinEntity entity, SeaUrchinRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        state.growthProgress = entity.getGrowthProgress();
    }

    protected void scale(SeaUrchinRenderState state, PoseStack poseStack) {
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.5f;
        float scale = Mth.lerp((float)state.growthProgress, (float)0.25f, (float)0.5f);
        poseStack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(SeaUrchinRenderState state) {
        return SEA_URCHIN_TEXTURE;
    }
}

