/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.tropicraft.core.client.entity.render.state.SpearRenderState;
import net.tropicraft.core.common.entity.projectile.SpearEntity;
import org.joml.Quaternionfc;

public class SpearRenderer<T extends SpearEntity>
extends EntityRenderer<T, SpearRenderState> {
    private final ItemModelResolver itemModelResolver;

    public SpearRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
    }

    public SpearRenderState createRenderState() {
        return new SpearRenderState();
    }

    public void extractRenderState(T entity, SpearRenderState state, float partialTicks) {
        super.extractRenderState(entity, (EntityRenderState)state, partialTicks);
        this.itemModelResolver.updateForNonLiving(state.item, entity.getPickupItemStackOrigin(), ItemDisplayContext.GROUND, entity);
        state.xRot = entity.getXRot(partialTicks);
        state.yRot = entity.getYRot(partialTicks);
    }

    public void render(SpearRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yRot));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-state.xRot));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-45.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        poseStack.scale(2.5f, 2.5f, 2.5f);
        state.item.render(poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
        super.render((EntityRenderState)state, poseStack, bufferSource, packedLight);
    }
}

