/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.render.state.StarfishRenderState;
import net.tropicraft.core.common.entity.underdasea.StarfishEntity;
import net.tropicraft.core.common.entity.underdasea.StarfishType;
import org.joml.Quaternionfc;

public class StarfishRenderer
extends EntityRenderer<StarfishEntity, StarfishRenderState> {
    public static final float BABY_RENDER_SCALE = 0.25f;
    public static final float ADULT_RENDER_SCALE = 1.0f;

    public StarfishRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public StarfishRenderState createRenderState() {
        return new StarfishRenderState();
    }

    public void extractRenderState(StarfishEntity entity, StarfishRenderState state, float partialTicks) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTicks);
        state.type = entity.getStarfishType();
        state.growthProgress = entity.getGrowthProgress();
        state.hasRedOverlay = entity.hurtTime > 0;
    }

    public void render(StarfishRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        StarfishType type = state.type;
        float f = 0.0f;
        float f1 = 1.0f;
        float f2 = 0.0f;
        float f3 = 1.0f;
        float f1shifted = 1.0f;
        float f3shifted = 1.0f;
        poseStack.pushPose();
        poseStack.translate(-0.5, 0.0, -0.5);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        float scale = Mth.lerp((float)state.growthProgress, (float)0.25f, (float)1.0f);
        poseStack.scale(scale, scale, scale);
        int packedOverlay = OverlayTexture.pack((int)OverlayTexture.u((float)0.0f), (int)OverlayTexture.v((boolean)state.hasRedOverlay));
        for (int i = 0; i < type.getLayerCount(); ++i) {
            ResourceLocation texture = type.getTextures().get(i);
            VertexConsumer ivertexbuilder = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
            float red = 1.0f;
            float green = state.hasRedOverlay ? 0.0f : 1.0f;
            float blue = state.hasRedOverlay ? 0.0f : 1.0f;
            float alpha = 1.0f;
            float layerHeight = type.getLayerHeights()[i];
            TropicraftSpecialRenderHelper.popper(f1, f2, f, f3, f1shifted, f3shifted, layerHeight, poseStack, ivertexbuilder, packedLight, packedOverlay, 1.0f, green, blue, 1.0f);
            poseStack.translate(0.0f, 0.0f, -layerHeight);
        }
        poseStack.popPose();
    }
}

