/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.AgeableMobRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.TapirModel;
import net.tropicraft.core.client.entity.render.layer.SunglassesLayer;
import net.tropicraft.core.client.entity.render.state.TapirRenderState;
import net.tropicraft.core.common.entity.passive.TapirEntity;

public class TapirRenderer
extends AgeableMobRenderer<TapirEntity, TapirRenderState, TapirModel> {
    private static final ResourceLocation TEXTURE = Tropicraft.location("textures/entity/tapir.png");
    private static final ResourceLocation BABY_TEXTURE = Tropicraft.location("textures/entity/tapir_baby.png");

    public TapirRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new TapirModel(context.bakeLayer(TropicraftRenderLayers.TAPIR_LAYER)), (EntityModel)new TapirModel(context.bakeLayer(TropicraftRenderLayers.TAPIR_BABY_LAYER)), 0.6f);
        this.addLayer(new SunglassesLayer<TapirRenderState, TapirModel>((RenderLayerParent<TapirRenderState, TapirModel>)this, state -> state.isUndercover, (poseStack, state, model) -> {
            ModelPart head = model.head();
            head.translateAndRotate(poseStack);
            poseStack.translate(0.03125f, 0.125f, -0.625f);
            float scale = 1.25f;
            poseStack.scale(1.25f, 1.25f, 1.25f);
        }));
    }

    public TapirRenderState createRenderState() {
        return new TapirRenderState();
    }

    public void extractRenderState(TapirEntity entity, TapirRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        state.isUndercover = entity.isUndercover();
    }

    public ResourceLocation getTextureLocation(TapirRenderState state) {
        return state.isBaby ? BABY_TEXTURE : TEXTURE;
    }
}

