/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.CreeperRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.TropiCreeperModel;
import net.tropicraft.core.common.entity.passive.TropiCreeperEntity;

public class TropiCreeperRenderer
extends MobRenderer<TropiCreeperEntity, CreeperRenderState, TropiCreeperModel> {
    private static final ResourceLocation TEXTURE = Tropicraft.location("textures/entity/tropicreeper.png");

    public TropiCreeperRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new TropiCreeperModel(context.bakeLayer(TropicraftRenderLayers.TROPI_CREEPER_LAYER)), 0.5f);
    }

    public CreeperRenderState createRenderState() {
        return new CreeperRenderState();
    }

    public void extractRenderState(TropiCreeperEntity entity, CreeperRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        state.swelling = entity.getCreeperFlashIntensity(partialTicks);
    }

    protected void scale(CreeperRenderState state, PoseStack poseStack) {
        float swelling = state.swelling;
        float skew = 1.0f + Mth.sin((float)(swelling * 100.0f)) * swelling * 0.01f;
        swelling = Mth.clamp((float)swelling, (float)0.0f, (float)1.0f);
        swelling *= swelling;
        swelling *= swelling;
        float scaleXz = (1.0f + swelling * 0.4f) * skew;
        float scaleY = (1.0f + swelling * 0.1f) / skew;
        poseStack.scale(scaleXz, scaleY, scaleXz);
    }

    protected float getWhiteOverlayProgress(CreeperRenderState state) {
        if ((int)(state.swelling * 10.0f) % 2 == 0) {
            return 0.0f;
        }
        return Mth.clamp((float)state.swelling, (float)0.5f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(CreeperRenderState state) {
        return TEXTURE;
    }
}

