/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.entity.render.state.TropiSpiderRenderState;
import net.tropicraft.core.common.entity.hostile.TropiSpiderEntity;

public class TropiSpiderRenderer
extends MobRenderer<TropiSpiderEntity, TropiSpiderRenderState, SpiderModel> {
    private static final ResourceLocation ADULT_TEXTURE_LOCATION = Tropicraft.location("textures/entity/spideradult.png");
    private static final ResourceLocation MOTHER_TEXTURE_LOCATION = Tropicraft.location("textures/entity/spidermother.png");
    private static final ResourceLocation CHILD_TEXTURE_LOCATION = Tropicraft.location("textures/entity/spiderchild.png");

    public TropiSpiderRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new SpiderModel(context.bakeLayer(ModelLayers.SPIDER)), 0.8f);
        this.shadowStrength = 0.5f;
    }

    public TropiSpiderRenderState createRenderState() {
        return new TropiSpiderRenderState();
    }

    public void extractRenderState(TropiSpiderEntity entity, TropiSpiderRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        state.type = entity.getSpiderType();
    }

    protected void scale(TropiSpiderRenderState state, PoseStack poseStack) {
        float scale;
        this.shadowRadius = scale = (switch (state.type) {
            default -> throw new MatchException(null, null);
            case TropiSpiderEntity.Type.ADULT -> 1.0f;
            case TropiSpiderEntity.Type.MOTHER -> 1.2f;
            case TropiSpiderEntity.Type.CHILD -> 0.5f;
        });
        poseStack.scale(scale, scale, scale);
    }

    public ResourceLocation getTextureLocation(TropiSpiderRenderState state) {
        return switch (state.type) {
            default -> throw new MatchException(null, null);
            case TropiSpiderEntity.Type.CHILD -> CHILD_TEXTURE_LOCATION;
            case TropiSpiderEntity.Type.MOTHER -> MOTHER_TEXTURE_LOCATION;
            case TropiSpiderEntity.Type.ADULT -> ADULT_TEXTURE_LOCATION;
        };
    }
}

