/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.model.TropicraftFishModel;
import net.tropicraft.core.client.entity.render.state.FishRenderState;
import net.tropicraft.core.common.entity.underdasea.IAtlasFish;
import org.joml.Quaternionfc;

public abstract class TropicraftFishRenderer<T extends AbstractFish>
extends MobRenderer<T, FishRenderState, TropicraftFishModel> {
    private static final ResourceLocation TEXTURE = Tropicraft.location("textures/entity/tropical_fish.png");
    private final TropicraftSpecialRenderHelper renderHelper = new TropicraftSpecialRenderHelper();

    public TropicraftFishRenderer(EntityRendererProvider.Context context, TropicraftFishModel modelbase, float f) {
        super(context, (EntityModel)modelbase, f);
    }

    public void render(FishRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        boolean shouldRender;
        boolean isVisible = this.isBodyVisible(state);
        boolean bl = shouldRender = !isVisible && !state.isInvisibleToPlayer;
        if (isVisible || shouldRender) {
            VertexConsumer buffer = bufferSource.getBuffer(this.getRenderType(state, isVisible, shouldRender, state.appearsGlowing));
            this.renderFishy(state, poseStack, buffer, packedLight, TropicraftFishRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f));
        }
        super.render((LivingEntityRenderState)state, poseStack, bufferSource, packedLight);
    }

    protected void renderFishy(FishRenderState state, PoseStack stack, VertexConsumer buffer, int light, int overlay) {
        stack.pushPose();
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.yRot));
        stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        stack.scale(0.3f, 0.3f, 0.5f);
        stack.translate(0.85f, -0.3f, 0.0f);
        int fishTex = state.atlasSlot * 2;
        this.renderHelper.renderFish(stack, buffer, fishTex, light, overlay);
        stack.translate(-1.7f, 0.0f, 0.0f);
        stack.translate(0.85f, 0.0f, 0.025f);
        stack.mulPose((Quaternionfc)Axis.YP.rotation(((TropicraftFishModel)this.model).tail.yRot));
        stack.translate(-0.85f, 0.0f, -0.025f);
        this.renderHelper.renderFish(stack, buffer, fishTex + 1, light, overlay);
        stack.popPose();
    }

    protected void scale(FishRenderState state, PoseStack stack) {
        stack.scale(0.75f, 0.2f, 0.2f);
    }

    public FishRenderState createRenderState() {
        return new FishRenderState();
    }

    public void extractRenderState(T entity, FishRenderState state, float partialTicks) {
        int n;
        super.extractRenderState(entity, (LivingEntityRenderState)state, partialTicks);
        if (entity instanceof IAtlasFish) {
            IAtlasFish fish = (IAtlasFish)entity;
            n = fish.getAtlasSlot();
        } else {
            n = 0;
        }
        state.atlasSlot = n;
    }

    public ResourceLocation getTextureLocation(FishRenderState state) {
        return TEXTURE;
    }
}

