/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.VMonkeyModel;
import net.tropicraft.core.client.entity.render.layer.VMonkeyHeldItemLayer;
import net.tropicraft.core.client.entity.render.state.VMonkeyRenderState;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;

public class VMonkeyRenderer
extends MobRenderer<VMonkeyEntity, VMonkeyRenderState, VMonkeyModel> {
    private static final ResourceLocation TEXTURE = Tropicraft.location("textures/entity/monkeytext.png");
    private static final ResourceLocation ANGRY_TEXTURE = Tropicraft.location("textures/entity/monkey_angrytext.png");
    private final ItemModelResolver itemModelResolver;

    public VMonkeyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new VMonkeyModel(context.bakeLayer(TropicraftRenderLayers.V_MONKEY_LAYER)), 0.5f);
        this.shadowRadius = 0.3f;
        this.shadowStrength = 0.5f;
        this.itemModelResolver = context.getItemModelResolver();
        this.addLayer(new VMonkeyHeldItemLayer(this));
    }

    public VMonkeyRenderState createRenderState() {
        return new VMonkeyRenderState();
    }

    public void extractRenderState(VMonkeyEntity entity, VMonkeyRenderState state, float partialTicks) {
        super.extractRenderState((LivingEntity)entity, (LivingEntityRenderState)state, partialTicks);
        ArmedEntityRenderState.extractArmedEntityRenderState((LivingEntity)entity, (ArmedEntityRenderState)state, (ItemModelResolver)this.itemModelResolver);
        state.isOrderedToSit = entity.isOrderedToSit();
        state.isClimbing = entity.isClimbing();
        state.isAggressive = entity.isAggressive();
    }

    public ResourceLocation getTextureLocation(VMonkeyRenderState state) {
        return state.isAggressive ? ANGRY_TEXTURE : TEXTURE;
    }
}

