/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemFrameRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.tropicraft.core.common.entity.placeable.WallItemEntity;
import org.joml.Quaternionfc;

public class WallItemRenderer
extends EntityRenderer<WallItemEntity, ItemFrameRenderState> {
    private final ItemModelResolver itemModelResolver;

    public WallItemRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemModelResolver = context.getItemModelResolver();
    }

    public ItemFrameRenderState createRenderState() {
        return new ItemFrameRenderState();
    }

    public void extractRenderState(WallItemEntity entity, ItemFrameRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        state.direction = entity.getDirection();
        this.itemModelResolver.updateForNonLiving(state.item, entity.getItem(), ItemDisplayContext.FIXED, (Entity)entity);
        state.rotation = entity.getRotation();
    }

    public void render(ItemFrameRenderState state, PoseStack stack, MultiBufferSource bufferSource, int lightCoords) {
        stack.pushPose();
        if (state.direction.getAxis().isHorizontal()) {
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f - (float)state.direction.get2DDataValue() * 90.0f));
        } else {
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f * (float)state.direction.getAxisDirection().getStep()));
        }
        stack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees((float)(state.rotation * 360) / 8.0f));
        if (!state.item.isEmpty()) {
            state.item.render(stack, bufferSource, lightCoords, OverlayTexture.NO_OVERLAY);
        }
        stack.popPose();
        super.render((EntityRenderState)state, stack, bufferSource, lightCoords);
    }
}

