/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.tropicraft.core.client.entity.render.state.CowktailRenderState;
import org.joml.Quaternionfc;

public class CowktailLayer<S extends CowktailRenderState>
extends RenderLayer<S, CowModel> {
    private final BlockRenderDispatcher blockRenderDispatcher;

    public CowktailLayer(RenderLayerParent<S, CowModel> renderer, BlockRenderDispatcher blockRenderDispatcher) {
        super(renderer);
        this.blockRenderDispatcher = blockRenderDispatcher;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, S state, float yRot, float xRot) {
        if (((CowktailRenderState)((Object)state)).isBaby || ((CowktailRenderState)((Object)state)).isInvisible) {
            return;
        }
        CowModel model = (CowModel)this.getParentModel();
        BlockState blockState = ((CowktailRenderState)((Object)state)).type.getRenderState();
        int overlayCoords = LivingEntityRenderer.getOverlayCoords(state, (float)0.0f);
        poseStack.pushPose();
        poseStack.translate((double)0.2f, (double)-0.35f, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-48.0f));
        this.renderBlock(poseStack, bufferSource, packedLight, blockState, overlayCoords);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.translate((double)0.2f, (double)-0.35f, 0.5);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(42.0f));
        poseStack.translate((double)0.1f, 0.0, (double)-0.6f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-48.0f));
        this.renderBlock(poseStack, bufferSource, packedLight, blockState, overlayCoords);
        poseStack.popPose();
        poseStack.pushPose();
        model.getHead().translateAndRotate(poseStack);
        poseStack.translate(0.0, (double)-0.7f, (double)-0.2f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-78.0f));
        this.renderBlock(poseStack, bufferSource, packedLight, blockState, overlayCoords);
        poseStack.popPose();
    }

    private void renderBlock(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, BlockState blockState, int overlayCoords) {
        float scale = 0.6f;
        poseStack.scale(-0.6f, -0.6f, 0.6f);
        poseStack.translate(-0.5, -0.8, -0.5);
        this.blockRenderDispatcher.renderSingleBlock(blockState, poseStack, bufferSource, packedLight, overlayCoords);
    }
}

