/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.tropicraft.core.client.entity.model.EagleRayModel;
import net.tropicraft.core.client.entity.render.EagleRayRenderer;
import org.joml.Quaternionfc;

public class EagleRayWingsLayer
extends RenderLayer<LivingEntityRenderState, EagleRayModel> {
    private static final int WING_JOINTS = 10;
    private static final int WING_CYCLE_TICKS = 60;
    private static final float PHASES = 0.33f;

    public EagleRayWingsLayer(RenderLayerParent<LivingEntityRenderState, EagleRayModel> renderer) {
        super(renderer);
    }

    private float decayFunc(float n) {
        return n / 9.0f;
    }

    private float amplitudeFunc(LivingEntityRenderState state, float n) {
        double angle = Math.PI * 2 * (double)(-n) / 9.0;
        return this.decayFunc(n) * Mth.sin((float)((float)((double)(state.ageInTicks / 60.0f * 2.0f) * Math.PI + (double)0.33f * angle)));
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int lightCoords, LivingEntityRenderState state, float yRot, float xRot) {
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)EagleRayRenderer.TEXTURE));
        int overlayCoords = LivingEntityRenderer.getOverlayCoords((LivingEntityRenderState)state, (float)0.0f);
        this.renderWings(state, poseStack, buffer, lightCoords, overlayCoords, -1);
        this.renderTailSimple(poseStack, buffer, lightCoords, overlayCoords, -1);
    }

    private void renderTailSimple(PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, int color) {
        float minU = 0.75f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 0.5f;
        stack.pushPose();
        stack.translate(0.55f, 0.0f, 1.5f);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        stack.scale(1.5f, 1.0f, 1.0f);
        EagleRayWingsLayer.vertex(buffer, stack.last(), 0.0f, 0.0f, 0.0f, color, minU, minV, packedLightIn, packedOverlayIn);
        EagleRayWingsLayer.vertex(buffer, stack.last(), 0.0f, 0.0f, 1.0f, color, minU, maxV, packedLightIn, packedOverlayIn);
        EagleRayWingsLayer.vertex(buffer, stack.last(), 1.0f, 0.0f, 1.0f, color, maxU, maxV, packedLightIn, packedOverlayIn);
        EagleRayWingsLayer.vertex(buffer, stack.last(), 1.0f, 0.0f, 0.0f, color, maxU, minV, packedLightIn, packedOverlayIn);
        stack.popPose();
    }

    private static void vertex(VertexConsumer bufferIn, PoseStack.Pose pose, float x, float y, float z, int color, float texU, float texV, int packedLight, int packedOverlay) {
        bufferIn.addVertex(pose, x, y, z).setColor(color).setUv(texU, texV).setOverlay(packedOverlay).setLight(packedLight).setNormal(pose, 0.0f, -1.0f, 0.0f);
    }

    private void renderWings(LivingEntityRenderState state, PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, int color) {
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.03125f, 0.0f, -0.5f);
        matrixStackIn.scale(2.0f, 0.5f, 2.0f);
        this.renderWing(state, matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color, false);
        matrixStackIn.translate(0.0f, 0.0f, 0.5f);
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        matrixStackIn.translate(0.0f, 0.0f, -0.5f);
        this.renderWing(state, matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, color, true);
        matrixStackIn.popPose();
    }

    private void renderWing(LivingEntityRenderState state, PoseStack stack, VertexConsumer buffer, int packedLightIn, int packedOverlayIn, int color, boolean reverse) {
        float minUFront = 0.0f;
        float maxUFront = 0.25f;
        float minVFront = 0.0f;
        float maxVFront = 0.5f;
        float minUBack = 0.0f;
        float maxUBack = 0.25f;
        float minVBack = 0.5f;
        float maxVBack = 1.0f;
        stack.pushPose();
        stack.translate(0.078125f, 0.0f, 0.0f);
        float prevAmplitude = 0.0f;
        for (int i = 1; i < 10; ++i) {
            float amplitude = this.amplitudeFunc(state, i);
            float prevX = (float)(i - 1) / 9.0f;
            float x = (float)i / 9.0f;
            float prevUFront = minUFront + (maxUFront - minUFront) * prevX;
            float uFront = minUFront + (maxUFront - minUFront) * x;
            float prevUBack = minUBack + (maxUBack - minUBack) * prevX;
            float uBack = minUBack + (maxUBack - minUBack) * x;
            float offset = -0.001f;
            PoseStack.Pose pose = stack.last();
            EagleRayWingsLayer.vertex(buffer, pose, x, amplitude - offset, 0.0f, color, uBack, reverse ? maxVBack : minVBack, packedLightIn, packedOverlayIn);
            EagleRayWingsLayer.vertex(buffer, pose, x, amplitude - offset, 1.0f, color, uBack, reverse ? minVBack : maxVBack, packedLightIn, packedOverlayIn);
            EagleRayWingsLayer.vertex(buffer, pose, prevX, prevAmplitude - offset, 1.0f, color, prevUBack, reverse ? minVBack : maxVBack, packedLightIn, packedOverlayIn);
            EagleRayWingsLayer.vertex(buffer, pose, prevX, prevAmplitude - offset, 0.0f, color, prevUBack, reverse ? maxVBack : minVBack, packedLightIn, packedOverlayIn);
            EagleRayWingsLayer.vertex(buffer, pose, prevX, prevAmplitude, 0.0f, color, prevUFront, reverse ? maxVFront : minVFront, packedLightIn, packedOverlayIn);
            EagleRayWingsLayer.vertex(buffer, pose, prevX, prevAmplitude, 1.0f, color, prevUFront, reverse ? minVFront : maxVFront, packedLightIn, packedOverlayIn);
            EagleRayWingsLayer.vertex(buffer, pose, x, amplitude, 1.0f, color, uFront, reverse ? minVFront : maxVFront, packedLightIn, packedOverlayIn);
            EagleRayWingsLayer.vertex(buffer, pose, x, amplitude, 0.0f, color, uFront, reverse ? maxVFront : minVFront, packedLightIn, packedOverlayIn);
            prevAmplitude = amplitude;
        }
        stack.popPose();
    }
}

