/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Predicate;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import org.joml.Quaternionfc;

public class SunglassesLayer<S extends EntityRenderState, M extends EntityModel<S>>
extends RenderLayer<S, M> {
    private static final ResourceLocation TEXTURE = Tropicraft.location("textures/entity/sunglasses.png");
    private final TropicraftSpecialRenderHelper mask;
    private final M model;
    private final Predicate<S> predicate;
    private final Transform<S, M> transform;

    public SunglassesLayer(RenderLayerParent<S, M> parent, Predicate<S> predicate, Transform<S, M> transform) {
        super(parent);
        this.model = parent.getModel();
        this.mask = new TropicraftSpecialRenderHelper();
        this.predicate = predicate;
        this.transform = transform;
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int packedLight, S renderState, float yRot, float xRot) {
        if (!this.predicate.test(renderState)) {
            return;
        }
        stack.pushPose();
        this.model.setupAnim(renderState);
        this.transform.apply(stack, renderState, this.model);
        stack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        this.mask.renderMask(stack, consumer, 0, packedLight, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }

    public static interface Transform<S, M> {
        public void apply(PoseStack var1, S var2, M var3);
    }
}

