/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.renderer.special;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Set;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.special.NoDataSpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class MachineSpecialRenderer
implements NoDataSpecialModelRenderer {
    private final Model model;
    private final Material material;

    public MachineSpecialRenderer(Model model, Material material) {
        this.model = model;
        this.material = material;
    }

    public void render(ItemDisplayContext context, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        poseStack.pushPose();
        MachineSpecialRenderer.transform(poseStack);
        VertexConsumer buffer = this.material.buffer(bufferSource, RenderType::entitySolid);
        this.model.renderToBuffer(poseStack, buffer, packedLight, packedOverlay);
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> output) {
        PoseStack poseStack = new PoseStack();
        MachineSpecialRenderer.transform(poseStack);
        this.model.root().getExtentsForGui(poseStack, output);
    }

    private static void transform(PoseStack poseStack) {
        poseStack.translate(0.5f, 1.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
    }
}

