/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.renderer.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.entity.model.EIHMachineModel;
import net.tropicraft.core.client.renderer.tileentity.MachineBlockEntityRenderer;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import org.joml.Quaternionfc;

public class AirCompressorBlockEntityRenderer
extends MachineBlockEntityRenderer<AirCompressorBlockEntity> {
    public static final Material MATERIAL = new Material(TextureAtlas.LOCATION_BLOCKS, Tropicraft.location("block/te/drink_mixer"));
    private final Model.Simple tankModel;

    public AirCompressorBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(new EIHMachineModel(context.bakeLayer(TropicraftRenderLayers.AIRCOMPRESSOR_LAYER)));
        this.tankModel = new Model.Simple(context.bakeLayer(TropicraftRenderLayers.TANK_SCUBA_LAYER), RenderType::entitySolid);
    }

    @Override
    protected Material getMaterial() {
        return MATERIAL;
    }

    @Override
    protected void animationTransform(AirCompressorBlockEntity blockEntity, PoseStack poseStack, float partialTicks) {
        float progress = blockEntity.getBreatheProgress(partialTicks);
        float sin = 1.0f + Mth.cos((float)progress);
        float sc = 1.0f + 0.05f * sin;
        poseStack.translate(0.0f, 1.5f, 0.0f);
        poseStack.scale(sc, sc, sc);
        poseStack.translate(0.0f, -1.5f, 0.0f);
        if ((double)progress < Math.PI) {
            float shake = Mth.sin((float)(blockEntity.getBreatheProgress(partialTicks) * 10.0f)) * 8.0f;
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(shake));
        }
    }

    @Override
    protected void renderIngredients(AirCompressorBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int lightCoords, int overlayCoords) {
        if (blockEntity.isActive()) {
            poseStack.pushPose();
            poseStack.translate(-0.5f, 0.5f, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            ResourceLocation texture = blockEntity.getTank().getScubaType().textureLocation();
            this.tankModel.renderToBuffer(poseStack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)texture)), lightCoords, overlayCoords);
            poseStack.popPose();
        }
    }
}

