/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.renderer.tileentity;

import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.block.tileentity.BambooChestBlockEntity;

public class BambooChestRenderer
extends ChestRenderer<BambooChestBlockEntity> {
    public static final Material BAMBOO_CHEST_MATERIAL = BambooChestRenderer.getChestMaterial("bamboo");
    public static final Material BAMBOO_CHEST_LEFT_MATERIAL = BambooChestRenderer.getChestMaterial("bamboo_left");
    public static final Material BAMBOO_CHEST_RIGHT_MATERIAL = BambooChestRenderer.getChestMaterial("bamboo_right");

    private static Material getChestMaterial(ChestType chestType, Material normalMaterial, Material leftMaterial, Material rightMaterial) {
        return switch (chestType) {
            case ChestType.LEFT -> leftMaterial;
            case ChestType.RIGHT -> rightMaterial;
            default -> normalMaterial;
        };
    }

    private static Material getChestMaterial(String chestName) {
        return new Material(Sheets.CHEST_SHEET, Tropicraft.location("entity/chest/" + chestName));
    }

    public BambooChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(BambooChestBlockEntity tileEntity, ChestType chestType) {
        return BambooChestRenderer.getChestMaterial(chestType, BAMBOO_CHEST_MATERIAL, BAMBOO_CHEST_LEFT_MATERIAL, BAMBOO_CHEST_RIGHT_MATERIAL);
    }
}

