/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.renderer.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.client.entity.model.MachineModel;
import net.tropicraft.core.common.block.tileentity.IMachineBlock;
import org.joml.Quaternionfc;

public abstract class MachineBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    protected final MachineModel model;

    public MachineBlockEntityRenderer(MachineModel model) {
        this.model = model;
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int lightCoords, int overlayCoords, Vec3 cameraPos) {
        poseStack.pushPose();
        poseStack.translate(0.5f, 1.5f, 0.5f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        Direction direction = ((IMachineBlock)blockEntity).getDirection(blockEntity.getBlockState());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(direction.toYRot() + 90.0f));
        if (((IMachineBlock)blockEntity).isActive()) {
            this.animationTransform(blockEntity, poseStack, partialTicks);
        }
        this.model.renderToBuffer(poseStack, this.getMaterial().buffer(bufferSource, arg_0 -> ((MachineModel)this.model).renderType(arg_0)), lightCoords, overlayCoords);
        this.renderIngredients(blockEntity, poseStack, bufferSource, lightCoords, overlayCoords);
        poseStack.popPose();
    }

    protected abstract Material getMaterial();

    protected void animationTransform(T blockEntity, PoseStack poseStack, float partialTicks) {
        float angle = Mth.sin((float)((float)(157.07963267948966 * (double)((IMachineBlock)blockEntity).getProgress(partialTicks)))) * 15.0f;
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(angle));
    }

    protected abstract void renderIngredients(T var1, PoseStack var2, MultiBufferSource var3, int var4, int var5);

    public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX() + 1.0, (double)pos.getY() + 2.0, (double)pos.getZ() + 1.0);
    }
}

