/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.renderer.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.block.tileentity.SifterBlockEntity;
import org.joml.Quaternionfc;

public class SifterBlockEntityRenderer
implements BlockEntityRenderer<SifterBlockEntity> {
    public static final float ITEM_SCALE = 1.3125f;
    private final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();
    private final ItemClusterRenderState clusterState = new ItemClusterRenderState();

    public SifterBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.getItemModelResolver();
    }

    public void render(SifterBlockEntity sifter, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        Level level = sifter.getLevel();
        ItemStack item = sifter.getSiftItem();
        if (!sifter.isSifting() || item.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(0.5, 0.2, 0.5);
        poseStack.rotateAround((Quaternionfc)Axis.YP.rotationDegrees((float)Mth.rotLerp((double)partialTicks, (double)sifter.yaw2, (double)sifter.yaw)), 0.0f, -0.4f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-20.0f));
        poseStack.scale(1.3125f, 1.3125f, 1.3125f);
        this.itemModelResolver.updateForTopItem(this.clusterState.item, item, ItemDisplayContext.GROUND, level, null, 0);
        this.clusterState.count = ItemClusterRenderState.getRenderedAmount((int)item.getCount());
        this.clusterState.seed = ItemClusterRenderState.getSeedForItemStack((ItemStack)item);
        ItemEntityRenderer.renderMultipleFromCount((PoseStack)poseStack, (MultiBufferSource)bufferSource, (int)packedLight, (ItemClusterRenderState)this.clusterState, (RandomSource)this.random);
        poseStack.popPose();
    }
}

