/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.scuba;

import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.material.FogType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.item.scuba.ScubaData;

@EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft")
public class ScubaAmbienceTicker {
    public static final SoundEvent SHALLOW_SCUBA = SoundEvent.createVariableRangeEvent((ResourceLocation)Tropicraft.location("scuba.shallow"));
    public static final SoundEvent DEEP_SCUBA = SoundEvent.createVariableRangeEvent((ResourceLocation)Tropicraft.location("scuba.deep"));
    @Nullable
    private static SoundEvent currentSound;

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && mc.player != null) {
            Camera renderInfo = mc.getEntityRenderDispatcher().camera;
            Entity renderViewEntity = mc.getCameraEntity();
            if (renderViewEntity instanceof Player) {
                Player player = (Player)renderViewEntity;
                if (renderInfo != null && renderInfo.getFluidInCamera() == FogType.WATER && player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ScubaArmorItem) {
                    ScubaAmbienceTicker.play(ScubaData.getDepth(player) < 60.0 ? SHALLOW_SCUBA : DEEP_SCUBA);
                    return;
                }
            }
        }
        ScubaAmbienceTicker.stop();
    }

    private static void play(SoundEvent sound) {
        if (currentSound != sound) {
            ScubaAmbienceTicker.stop();
            currentSound = sound;
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance(sound.location(), SoundSource.AMBIENT, 0.4f, 1.0f, SoundInstance.createUnseededRandom(), true, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true));
        }
    }

    private static void stop() {
        if (currentSound != null) {
            Minecraft.getInstance().getSoundManager().stop(currentSound.location(), SoundSource.AMBIENT);
            currentSound = null;
        }
    }
}

