/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.scuba;

import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.data.TropicraftLangKeys;
import net.tropicraft.core.common.item.component.TropicraftDataComponents;
import net.tropicraft.core.common.item.scuba.ScubaData;
import org.apache.commons.lang3.time.DurationFormatUtils;

@EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft")
public class ScubaHUD {
    @SubscribeEvent
    public static void registerOverlayRenderer(RegisterGuiLayersEvent event) {
        event.registerBelow(VanillaGuiLayers.DEBUG_OVERLAY, Tropicraft.location("scuba_hud"), ScubaHUD::draw);
    }

    private static void draw(GuiGraphics graphics, DeltaTracker deltaTracker) {
        Player player;
        ItemStack chestStack;
        Integer airRemaining;
        Entity renderViewEntity = Minecraft.getInstance().cameraEntity;
        if (renderViewEntity instanceof Player && (airRemaining = (Integer)(chestStack = (player = (Player)renderViewEntity).getItemBySlot(EquipmentSlot.CHEST)).get(TropicraftDataComponents.SCUBA_AIR)) != null) {
            ScubaData data = (ScubaData)player.getData(ScubaData.ATTACHMENT);
            ChatFormatting airColor = ScubaHUD.getAirTimeColor(airRemaining);
            double depth = ScubaData.getDepth(player);
            Object depthStr = depth > 0.0 ? Component.literal((String)String.format("%.1fm", depth)) : TropicraftLangKeys.NA.component();
            ScubaHUD.drawHUDStrings(graphics, TropicraftLangKeys.SCUBA_AIR_TIME.format(String.valueOf(airColor) + ScubaHUD.formatTime(airRemaining.intValue())), TropicraftLangKeys.SCUBA_DIVE_TIME.format(ScubaHUD.formatTime(data.getDiveTime())), TropicraftLangKeys.SCUBA_DEPTH.format(depthStr), TropicraftLangKeys.SCUBA_MAX_DEPTH.format(String.format(Locale.ROOT, "%.1fm", data.getMaxDepth())));
        }
    }

    public static String formatTime(long time) {
        return DurationFormatUtils.formatDuration((long)(time * 50L), (String)"HH:mm:ss");
    }

    public static ChatFormatting getAirTimeColor(int airRemaining) {
        if (airRemaining < 1200) {
            int speed = airRemaining < 200 ? 250 : 500;
            return Util.getMillis() / (long)speed % 4L == 0L ? ChatFormatting.WHITE : ChatFormatting.RED;
        }
        if (airRemaining < 6000) {
            return ChatFormatting.GOLD;
        }
        return ChatFormatting.GREEN;
    }

    private static void drawHUDStrings(GuiGraphics graphics, Component ... lines) {
        Font font = Minecraft.getInstance().font;
        int x = graphics.guiWidth() - 5;
        int n = graphics.guiHeight() - 5;
        Objects.requireNonNull(font);
        int y = n - 9 * lines.length;
        for (Component line : lines) {
            graphics.drawString(font, line, x - font.width((FormattedText)line), y, -1);
            Objects.requireNonNull(font);
            y += 9;
        }
    }
}

