/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.attribute;

import net.minecraft.client.Camera;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.level.material.FogType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.tropicraft.core.client.data.TropicraftLangKeys;

@EventBusSubscriber(modid="tropicraft")
public class TropicraftAttributes {
    public static final DeferredRegister<Attribute> REGISTER = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"tropicraft");
    public static final DeferredHolder<Attribute, Attribute> UNDERWATER_VISIBILITY = REGISTER.register("underwater_visibility", () -> new RangedAttribute(TropicraftLangKeys.SCUBA_VISIBILITY_STAT.key(), 1.0, 0.0, 10.0).setSyncable(true));

    @SubscribeEvent
    public static void onRegisterAttributes(EntityAttributeModificationEvent event) {
        event.add(EntityType.PLAYER, UNDERWATER_VISIBILITY);
    }

    @EventBusSubscriber(modid="tropicraft", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void renderWaterFog(ViewportEvent.RenderFog event) {
            LocalPlayer player;
            double visibility;
            if (event.getType() != FogType.WATER) {
                return;
            }
            Camera camera = event.getCamera();
            Entity entity = camera.getEntity();
            if (entity instanceof LocalPlayer && (visibility = (player = (LocalPlayer)entity).getAttributeValue(UNDERWATER_VISIBILITY)) != 1.0) {
                event.scaleFarPlaneDistance((float)visibility);
            }
        }
    }
}

