/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ARGB;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class BlockTropicraftSand
extends FallingBlock {
    public static final MapCodec<BlockTropicraftSand> CODEC = BlockTropicraftSand.simpleCodec(BlockTropicraftSand::new);
    public static final BooleanProperty UNDERWATER = BooleanProperty.create((String)"underwater");
    private final int dustColor;

    public BlockTropicraftSand(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNDERWATER, (Comparable)Boolean.valueOf(false)));
        this.dustColor = ARGB.opaque((int)this.defaultMapColor().col);
    }

    protected MapCodec<? extends BlockTropicraftSand> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UNDERWATER});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState upState = context.getLevel().getFluidState(context.getClickedPos().above());
        return (BlockState)this.defaultBlockState().setValue((Property)UNDERWATER, (Comparable)Boolean.valueOf(!upState.isEmpty()));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction neighborDirection, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (neighborDirection == Direction.UP) {
            state = (BlockState)state.setValue((Property)UNDERWATER, (Comparable)Boolean.valueOf(neighborState.getFluidState().is(FluidTags.WATER)));
        }
        return super.updateShape(state, level, tickAccess, pos, neighborDirection, neighborPos, neighborState, random);
    }

    public int getDustColor(BlockState state, BlockGetter level, BlockPos pos) {
        return this.dustColor;
    }
}

