/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.tropicraft.core.common.sound.Sounds;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="tropicraft")
public final class BongoDrumBlock
extends Block {
    public static final MapCodec<BongoDrumBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Size.CODEC.fieldOf("size").forGetter(b -> b.size), (App)BongoDrumBlock.propertiesCodec()).apply((Applicative)i, BongoDrumBlock::new));
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    private final Size size;

    public BongoDrumBlock(Size size, BlockBehaviour.Properties properties) {
        super(properties);
        this.size = size;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    public Size getSize() {
        return this.size;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.size.shape;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.getShape(state, worldIn, pos, context);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (result.getDirection() != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.playBongoSound(level, pos, state, this.getAdjustedPitch((HitResult)result));
        return InteractionResult.CONSUME;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (level.isClientSide) {
            return;
        }
        boolean flag = level.hasNeighborSignal(pos);
        if (flag != (Boolean)state.getValue((Property)POWERED)) {
            if (flag) {
                this.playBongoSound(level, pos, state);
            }
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        BlockState state = level.getBlockState(event.getPos());
        Block block = state.getBlock();
        if (state.getBlock() instanceof BongoDrumBlock && event.getFace() == Direction.UP) {
            ((BongoDrumBlock)block).playBongoSound(level, event.getPos(), state);
        }
    }

    public void playBongoSound(Level world, BlockPos pos, BlockState state) {
        this.playBongoSound(world, pos, state, 1.0f);
    }

    public void playBongoSound(Level world, BlockPos pos, BlockState state, float pitch) {
        world.playSound(null, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, this.size.soundEvent.get(), SoundSource.BLOCKS, 1.0f, pitch);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    private float getAdjustedPitch(HitResult hitVec) {
        double distX = Math.abs(hitVec.getLocation().x - Math.floor(hitVec.getLocation().x) - 0.5);
        double distZ = Math.abs(hitVec.getLocation().z - Math.floor(hitVec.getLocation().z) - 0.5);
        double dist = (float)Math.sqrt(distX * distX + distZ * distZ);
        double radiusMax = 1.0;
        if (this.size == Size.SMALL) {
            radiusMax = 0.25;
        } else if (this.size == Size.MEDIUM) {
            radiusMax = 0.0;
        } else if (this.size == Size.LARGE) {
            radiusMax = 0.0;
        }
        double adjPitch = dist / radiusMax;
        return 1.0f + (float)adjPitch;
    }

    public static enum Size implements StringRepresentable
    {
        SMALL("small", 8, (Supplier<SoundEvent>)Sounds.BONGO_HIGH, 1),
        MEDIUM("medium", 10, (Supplier<SoundEvent>)Sounds.BONGO_MED, 2),
        LARGE("large", 12, (Supplier<SoundEvent>)Sounds.BONGO_LOW, 3);

        public static final Codec<Size> CODEC;
        private final String name;
        public final VoxelShape shape;
        final Supplier<SoundEvent> soundEvent;
        public final int recipeColumns;

        private Size(String name, int size, Supplier<SoundEvent> soundEvent, int recipeColumns) {
            this.name = name;
            this.recipeColumns = recipeColumns;
            double offset = (16 - size) / 2;
            this.shape = Block.box((double)offset, (double)0.0, (double)offset, (double)(16.0 - offset), (double)16.0, (double)(16.0 - offset));
            this.soundEvent = soundEvent;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Size::values);
        }
    }
}

