/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.item.TropicraftItems;

public final class CoffeeBushBlock
extends CropBlock {
    public static final MapCodec<CoffeeBushBlock> CODEC = CoffeeBushBlock.simpleCodec(CoffeeBushBlock::new);
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)6);
    public static final int MAX_HEIGHT = 3;
    public static final int GROWTH_RATE_FERTILE = 10;
    public static final int GROWTH_RATE_INFERTILE = 20;

    public CoffeeBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<CoffeeBushBlock> codec() {
        return CODEC;
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 6;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)TropicraftItems.RAW_COFFEE_BEAN.get();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE});
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (worldIn.isEmptyBlock(pos.above())) {
            BlockPos ground = pos;
            int height = 1;
            while (worldIn.getBlockState(ground = ground.below()).is((Block)this)) {
                ++height;
            }
            BlockState blockState = worldIn.getBlockState(ground);
            if (height < 3 && worldIn.random.nextInt(blockState.getBlock().isFertile(blockState, (BlockGetter)worldIn, ground) ? 10 : 20) == 0) {
                worldIn.setBlockAndUpdate(pos.above(), this.defaultBlockState());
            }
        }
        super.tick(state, worldIn, pos, rand);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult result) {
        if (((Integer)state.getValue((Property)AGE)).intValue() == this.getMaxAge()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
            int count = 1 + player.getRandom().nextInt(3);
            ItemStack stack = new ItemStack((ItemLike)TropicraftItems.RAW_COFFEE_BEAN.get(), count);
            CoffeeBushBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
            return world.isClientSide ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.block();
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.is(Blocks.GRASS_BLOCK) || state.is(BlockTags.DIRT) || state.is(Blocks.FARMLAND) || state.is((Block)this);
    }
}

