/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public final class DrinkMixerBlock
extends BaseEntityBlock {
    public static final MapCodec<DrinkMixerBlock> CODEC = DrinkMixerBlock.simpleCodec(DrinkMixerBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;

    public DrinkMixerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<DrinkMixerBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return DrinkMixerBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TropicraftBlocks.DRINK_MIXER_ENTITY.get()), DrinkMixerBlockEntity::mixTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DrinkMixerBlockEntity)) {
            return InteractionResult.FAIL;
        }
        DrinkMixerBlockEntity mixer = (DrinkMixerBlockEntity)blockEntity;
        if (mixer.isDoneMixing()) {
            mixer.retrieveResult(player);
        } else {
            mixer.emptyMixer(player);
        }
        return InteractionResult.SUCCESS_SERVER;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof DrinkMixerBlockEntity)) {
            return InteractionResult.FAIL;
        }
        DrinkMixerBlockEntity mixer = (DrinkMixerBlockEntity)blockEntity;
        if (mixer.isDoneMixing()) {
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (stack.is(TropicraftItems.BAMBOO_MUG)) {
            if (mixer.tryStartMixing()) {
                stack.consume(1, (LivingEntity)player);
                return InteractionResult.SUCCESS_SERVER;
            }
        } else if (mixer.tryTransferToMixer(level, stack, (LivingEntity)player)) {
            return InteractionResult.SUCCESS_SERVER;
        }
        return InteractionResult.FAIL;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection());
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DrinkMixerBlockEntity((BlockEntityType<DrinkMixerBlockEntity>)((BlockEntityType)TropicraftBlocks.DRINK_MIXER_ENTITY.get()), pos, state);
    }
}

