/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.tropicraft.core.common.TropicraftTags;
import org.jetbrains.annotations.Nullable;

public final class FruitingBranchBlock
extends Block
implements BonemealableBlock {
    public static final MapCodec<FruitingBranchBlock> CODEC = FruitingBranchBlock.simpleCodec(FruitingBranchBlock::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    public static final int MAX_AGE = 2;
    private static final int GROW_CHANCE = 10;
    private static final VoxelShape NORTH_SHAPE = Block.box((double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)14.0);
    private static final VoxelShape WEST_SHAPE = Block.box((double)2.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape EAST_SHAPE = Block.box((double)0.0, (double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0);
    private static final VoxelShape BIRD_PERCH_SHAPE = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public FruitingBranchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<FruitingBranchBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> throw new UnsupportedOperationException();
        };
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityContext;
        if (context instanceof EntityCollisionContext && (entityContext = (EntityCollisionContext)context).getEntity() != null && entityContext.getEntity().getType().is(TropicraftTags.Entities.CAN_STAND_ON_BRANCH)) {
            return BIRD_PERCH_SHAPE;
        }
        return Shapes.empty();
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(10) == 0) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)AGE));
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        Direction facing = (Direction)state.getValue(FACING);
        if (direction == facing.getOpposite()) {
            return neighborState.isFaceSturdy((BlockGetter)level, neighborPos, facing) ? state : Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACING);
        BlockPos attachPos = pos.relative(facing.getOpposite());
        return level.getBlockState(attachPos).isFaceSturdy((BlockGetter)level, attachPos, facing);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getClickedFace();
        if (facing.getAxis() == Direction.Axis.Y) {
            return null;
        }
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)facing);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue(FACING, (Comparable)mirror.mirror((Direction)state.getValue(FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AGE});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.cycle((Property)AGE), 2);
    }
}

