/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public final class FruitingVineBlock
extends MultifaceSpreadeableBlock
implements BonemealableBlock {
    public static final MapCodec<FruitingVineBlock> CODEC = FruitingVineBlock.simpleCodec(FruitingVineBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    public static final int MAX_AGE = 2;
    private static final int GROW_CHANCE = 10;
    private final MultifaceSpreader spreader = new MultifaceSpreader((MultifaceBlock)this);

    public FruitingVineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<FruitingVineBlock> codec() {
        return CODEC;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.nextInt(10) == 0) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)AGE));
        }
    }

    public MultifaceSpreader getSpreader() {
        return this.spreader;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        return !context.getItemInHand().is(this.asItem()) || super.canBeReplaced(state, context);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if ((Integer)state.getValue((Property)AGE) < 2) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            if (!this.spreader.canSpreadInAnyDirection(state, (BlockGetter)level, pos, direction.getOpposite())) continue;
            return true;
        }
        return false;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (random.nextInt(2) == 0) {
            this.spreader.spreadFromRandomFaceTowardRandomDirection(state, (LevelAccessor)level, pos, random);
        }
        if ((Integer)state.getValue((Property)AGE) < 2 && random.nextInt(2) == 0) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)AGE));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AGE});
    }
}

