/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.tropicraft.core.common.block.PropaguleBlock;

public class MangroveLeavesBlock
extends LeavesBlock {
    private static final int PROPAGULE_GROW_CHANCE = 200;
    private static final int SPACING = 2;
    private final Supplier<PropaguleBlock> propaguleBlock;
    private final ParticleOptions leafParticle;

    public MangroveLeavesBlock(float leafParticleChance, ParticleOptions leafParticle, Supplier<PropaguleBlock> propaguleBlock, BlockBehaviour.Properties properties) {
        super(leafParticleChance, properties);
        this.leafParticle = leafParticle;
        this.propaguleBlock = propaguleBlock;
    }

    public MapCodec<? extends LeavesBlock> codec() {
        throw new UnsupportedOperationException();
    }

    public boolean isRandomlyTicking(BlockState state) {
        return this.canGrowPropagules(state) || super.isRandomlyTicking(state);
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        if (this.canGrowPropagules(state) && random.nextInt(200) == 0) {
            this.tryGrowPropagule(world, pos);
        }
    }

    protected void spawnFallingLeavesParticle(Level level, BlockPos pos, RandomSource random) {
        ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)this.leafParticle);
    }

    private void tryGrowPropagule(ServerLevel world, BlockPos pos) {
        BlockPos growPos = pos.below();
        if (world.isEmptyBlock(growPos) && world.isEmptyBlock(growPos.below()) && !this.hasNearPropagule(world, pos)) {
            BlockState propagule = (BlockState)this.propaguleBlock.get().defaultBlockState().setValue((Property)PropaguleBlock.PLANTED, (Comparable)Boolean.valueOf(false));
            world.setBlockAndUpdate(growPos, propagule);
        }
    }

    private boolean canGrowPropagules(BlockState state) {
        return (Integer)state.getValue((Property)DISTANCE) <= 3;
    }

    private boolean hasNearPropagule(ServerLevel world, BlockPos source) {
        PropaguleBlock propagule = this.propaguleBlock.get();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)source.offset(-2, -2, -2), (BlockPos)source.offset(2, 0, 2))) {
            if (!world.getBlockState(pos).is((Block)propagule)) continue;
            return true;
        }
        return false;
    }
}

