/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class TikiTorchBlock
extends Block {
    public static final MapCodec<TikiTorchBlock> CODEC = TikiTorchBlock.simpleCodec(TikiTorchBlock::new);
    public static final EnumProperty<TorchSection> SECTION = EnumProperty.create((String)"section", TorchSection.class);
    protected static final VoxelShape BASE_SHAPE = Shapes.create((AABB)new AABB(0.4, 0.0, 0.4, 0.6, 0.999999, 0.6));
    protected static final VoxelShape TOP_SHAPE = Shapes.create((AABB)new AABB(0.4, 0.0, 0.4, 0.6, 0.6, 0.6));

    public TikiTorchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)TorchSection.UPPER)));
    }

    protected MapCodec<TikiTorchBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SECTION});
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        TorchSection section = (TorchSection)((Object)state.getValue(SECTION));
        if (section == TorchSection.UPPER) {
            return TOP_SHAPE;
        }
        return BASE_SHAPE;
    }

    @Deprecated
    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        if (TikiTorchBlock.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP)) {
            return true;
        }
        BlockState blockstate = world.getBlockState(pos.below());
        return blockstate.is((Block)this) && blockstate.getValue(SECTION) != TorchSection.UPPER && super.canSurvive(state, world, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        if (this.placeShortTorchOn(context.getLevel().getBlockState(blockpos.below()))) {
            return (BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)TorchSection.UPPER));
        }
        BlockState ret = (BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)TorchSection.LOWER));
        return blockpos.getY() < context.getLevel().getMaxY() - 1 && context.getLevel().getBlockState(blockpos.above()).canBeReplaced(context) && context.getLevel().getBlockState(blockpos.above(2)).canBeReplaced(context) ? ret : null;
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction.getAxis() == Direction.Axis.Y && !this.canSurvive(state, level, pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TorchSection section = (TorchSection)((Object)state.getValue(SECTION));
        if (section == TorchSection.UPPER) {
            return;
        }
        worldIn.setBlock(pos.above(), (BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)TorchSection.MIDDLE)), 3);
        worldIn.setBlock(pos.above(2), (BlockState)this.defaultBlockState().setValue(SECTION, (Comparable)((Object)TorchSection.UPPER)), 3);
    }

    private boolean placeShortTorchOn(BlockState state) {
        return state.is(BlockTags.FENCES) || state.is(BlockTags.WALLS);
    }

    public void playerDestroy(Level world, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity te, ItemStack stack) {
        TorchSection section = (TorchSection)((Object)state.getValue(SECTION));
        BlockPos base = pos.below(section.height);
        for (TorchSection otherSection : TorchSection.values()) {
            BlockPos pos2 = base.above(otherSection.height);
            BlockState state2 = world.getBlockState(pos2);
            if (!state2.is((Block)this) || state2.getValue(SECTION) != otherSection) continue;
            super.playerDestroy(world, player, pos2, state2, te, stack);
            world.setBlock(pos2, world.getFluidState(pos2).createLegacyBlock(), world.isClientSide ? 11 : 3);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        boolean ret = false;
        TorchSection section = (TorchSection)((Object)state.getValue(SECTION));
        BlockPos base = pos.below(section.height);
        for (TorchSection otherSection : TorchSection.values()) {
            BlockPos pos2 = base.above(otherSection.height);
            BlockState state2 = world.getBlockState(pos2);
            if (!state2.is((Block)this) || state2.getValue(SECTION) != otherSection) continue;
            if (player.isCreative()) {
                ret |= super.onDestroyedByPlayer(state2, world, pos2, player, willHarvest, fluid);
                continue;
            }
            this.playerWillDestroy(world, pos2, state2, player);
            ret = true;
        }
        return ret;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        boolean isTop;
        boolean bl = isTop = state.getValue(SECTION) == TorchSection.UPPER;
        if (isTop) {
            double d = (float)pos.getX() + 0.5f;
            double d1 = (float)pos.getY() + 0.7f;
            double d2 = (float)pos.getZ() + 0.5f;
            world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d, d1, d2, 0.0, 0.0, 0.0);
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static enum TorchSection implements StringRepresentable
    {
        UPPER(2),
        MIDDLE(1),
        LOWER(0);

        final int height;

        private TorchSection(int height) {
            this.height = height;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.getSerializedName();
        }
    }
}

