/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.GeneratorType;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.generators.RegistrateBlockModelGenerator;
import com.tterrag.registrate.providers.generators.RegistrateItemModelGenerator;
import com.tterrag.registrate.providers.generators.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.ConditionBuilder;
import net.minecraft.client.data.models.blockstates.MultiPartGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.special.ChestSpecialRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.predicates.DataComponentPredicate;
import net.minecraft.core.component.predicates.DataComponentPredicates;
import net.minecraft.core.component.predicates.EnchantmentsPredicate;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Unit;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PlaceOnWaterBlockItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TallFlowerBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.UntintedParticleLeavesBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.Tags;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.client.renderer.special.AirCompressorSpecialRenderer;
import net.tropicraft.core.client.renderer.special.DrinkMixerSpecialRenderer;
import net.tropicraft.core.client.renderer.tileentity.AirCompressorBlockEntityRenderer;
import net.tropicraft.core.client.renderer.tileentity.BambooChestRenderer;
import net.tropicraft.core.client.renderer.tileentity.DrinkMixerBlockEntityRenderer;
import net.tropicraft.core.client.renderer.tileentity.SifterBlockEntityRenderer;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.BambooChestBlock;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.BoardwalkBlock;
import net.tropicraft.core.common.block.BongoDrumBlock;
import net.tropicraft.core.common.block.CoconutBlock;
import net.tropicraft.core.common.block.CoffeeBushBlock;
import net.tropicraft.core.common.block.CustomSeagrassBlock;
import net.tropicraft.core.common.block.CustomTallSeagrassBlock;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.DuckweedBlock;
import net.tropicraft.core.common.block.FruitingBranchBlock;
import net.tropicraft.core.common.block.FruitingVineBlock;
import net.tropicraft.core.common.block.GrowableDoublePlantBlock;
import net.tropicraft.core.common.block.GrowableSinglePlantBlock;
import net.tropicraft.core.common.block.MahoganyNutBlock;
import net.tropicraft.core.common.block.MangroveLeavesBlock;
import net.tropicraft.core.common.block.MangroveRootsBlock;
import net.tropicraft.core.common.block.MudBlock;
import net.tropicraft.core.common.block.PapayaBlock;
import net.tropicraft.core.common.block.PineappleBlock;
import net.tropicraft.core.common.block.PortalWaterBlock;
import net.tropicraft.core.common.block.PropaguleBlock;
import net.tropicraft.core.common.block.ReedsBlock;
import net.tropicraft.core.common.block.SifterBlock;
import net.tropicraft.core.common.block.TikiTorchBlock;
import net.tropicraft.core.common.block.TropicraftFlower;
import net.tropicraft.core.common.block.TropicraftLeavesBlock;
import net.tropicraft.core.common.block.TropicraftLogBlock;
import net.tropicraft.core.common.block.TropicraftTreeGrowers;
import net.tropicraft.core.common.block.TropicraftWoodTypes;
import net.tropicraft.core.common.block.TropicsFlowerBlock;
import net.tropicraft.core.common.block.VolcanicSandBlock;
import net.tropicraft.core.common.block.VolcanoBlock;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;
import net.tropicraft.core.common.block.jigarbov.JigarbovTorchType;
import net.tropicraft.core.common.block.tileentity.AirCompressorBlockEntity;
import net.tropicraft.core.common.block.tileentity.BambooChestBlockEntity;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;
import net.tropicraft.core.common.block.tileentity.SifterBlockEntity;
import net.tropicraft.core.common.block.tileentity.VolcanoBlockEntity;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.item.component.TropicraftDataComponents;
import net.tropicraft.core.mixin.BlockEntityTypeAccessor;
import org.apache.commons.lang3.StringUtils;

public class TropicraftBlocks {
    private static final Registrate REGISTRATE = Tropicraft.registrate();
    private static final float[] FRUIT_SAPLING_RATES = new float[]{0.1f, 0.125f, 0.16666667f, 0.2f};
    private static final float[] SAPLING_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final float[] RARE_SAPLING_RATES = new float[]{0.025f, 0.027777778f, 0.03125f, 0.041666668f, 0.1f};
    private static final ColorParticleOption TROPICS_LEAF_PARTICLE = ColorParticleOption.create((ParticleType)ParticleTypes.TINTED_LEAVES, (int)-15098608);
    public static final BlockEntry<PortalWaterBlock> TELEPORT_WATER;
    public static final BlockEntry<LiquidBlock> PORTAL_WATER;
    public static final BlockEntry<Block> CHUNK;
    public static final BlockEntry<DropExperienceBlock> AZURITE_ORE;
    public static final BlockEntry<DropExperienceBlock> EUDIALYTE_ORE;
    public static final BlockEntry<DropExperienceBlock> MANGANESE_ORE;
    public static final BlockEntry<DropExperienceBlock> SHAKA_ORE;
    public static final BlockEntry<DropExperienceBlock> ZIRCON_ORE;
    public static final BlockEntry<Block> AZURITE_BLOCK;
    public static final BlockEntry<Block> EUDIALYTE_BLOCK;
    public static final BlockEntry<Block> MANGANESE_BLOCK;
    public static final BlockEntry<Block> SHAKA_BLOCK;
    public static final BlockEntry<Block> ZIRCON_BLOCK;
    public static final BlockEntry<Block> ZIRCONIUM_BLOCK;
    public static final Map<TropicraftFlower, BlockEntry<TropicsFlowerBlock>> FLOWERS;
    public static final BlockEntry<BlockTropicraftSand> PURIFIED_SAND;
    public static final BlockEntry<Block> PACKED_PURIFIED_SAND;
    public static final BlockEntry<BlockTropicraftSand> CORAL_SAND;
    public static final BlockEntry<BlockTropicraftSand> FOAMY_SAND;
    public static final BlockEntry<VolcanicSandBlock> VOLCANIC_SAND;
    public static final BlockEntry<BlockTropicraftSand> MINERAL_SAND;
    public static final BlockEntry<MudBlock> MUD;
    public static final BlockEntry<Block> MUD_WITH_PIANGUAS;
    public static final BlockEntry<RotatedPillarBlock> BAMBOO_BUNDLE;
    public static final BlockEntry<RotatedPillarBlock> THATCH_BUNDLE;
    public static final BlockEntry<Block> MAHOGANY_PLANKS;
    public static final BlockEntry<Block> PALM_PLANKS;
    public static final BlockEntry<RotatedPillarBlock> MAHOGANY_LOG;
    public static final BlockEntry<RotatedPillarBlock> PALM_LOG;
    public static final BlockEntry<RotatedPillarBlock> MAHOGANY_WOOD;
    public static final BlockEntry<RotatedPillarBlock> PALM_WOOD;
    public static final BlockEntry<StairBlock> PALM_STAIRS;
    public static final BlockEntry<StairBlock> MAHOGANY_STAIRS;
    public static final BlockEntry<StairBlock> THATCH_STAIRS;
    public static final BlockEntry<StairBlock> THATCH_STAIRS_FUZZY;
    public static final BlockEntry<StairBlock> BAMBOO_STAIRS;
    public static final BlockEntry<StairBlock> CHUNK_STAIRS;
    public static final BlockEntry<CoconutBlock> COCONUT;
    public static final BlockEntry<SlabBlock> BAMBOO_SLAB;
    public static final BlockEntry<SlabBlock> THATCH_SLAB;
    public static final BlockEntry<SlabBlock> CHUNK_SLAB;
    public static final BlockEntry<SlabBlock> PALM_SLAB;
    public static final BlockEntry<SlabBlock> MAHOGANY_SLAB;
    public static final BlockEntry<SaplingBlock> GRAPEFRUIT_SAPLING;
    public static final BlockEntry<SaplingBlock> LEMON_SAPLING;
    public static final BlockEntry<SaplingBlock> LIME_SAPLING;
    public static final BlockEntry<SaplingBlock> ORANGE_SAPLING;
    public static final BlockEntry<SaplingBlock> PAPAYA_SAPLING;
    public static final BlockEntry<SaplingBlock> MAHOGANY_SAPLING;
    public static final BlockEntry<SaplingBlock> PALM_SAPLING;
    public static final BlockEntry<LeavesBlock> MAHOGANY_LEAVES;
    public static final BlockEntry<LeavesBlock> PALM_LEAVES;
    public static final BlockEntry<LeavesBlock> KAPOK_LEAVES;
    public static final BlockEntry<LeavesBlock> FRUIT_LEAVES;
    public static final BlockEntry<UntintedParticleLeavesBlock> GRAPEFRUIT_LEAVES;
    public static final BlockEntry<UntintedParticleLeavesBlock> LEMON_LEAVES;
    public static final BlockEntry<UntintedParticleLeavesBlock> LIME_LEAVES;
    public static final BlockEntry<UntintedParticleLeavesBlock> ORANGE_LEAVES;
    public static final BlockEntry<LeavesBlock> PAPAYA_LEAVES;
    public static final BlockEntry<LeavesBlock> WHITE_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> RED_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> BLUE_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> PURPLE_FLOWERING_LEAVES;
    public static final BlockEntry<LeavesBlock> YELLOW_FLOWERING_LEAVES;
    public static final BlockEntry<FruitingVineBlock> PASSIONFRUIT_VINE;
    public static final BlockEntry<RotatedPillarBlock> PAPAYA_LOG;
    public static final BlockEntry<RotatedPillarBlock> PAPAYA_WOOD;
    public static final BlockEntry<SaplingBlock> PLANTAIN_SAPLING;
    public static final BlockEntry<RotatedPillarBlock> PLANTAIN_STEM;
    public static final BlockEntry<LeavesBlock> PLANTAIN_LEAVES;
    public static final BlockEntry<Block> GREEN_PLANTAIN_BUNCH;
    public static final BlockEntry<Block> YELLOW_PLANTAIN_BUNCH;
    public static final BlockEntry<SaplingBlock> JOCOTE_SAPLING;
    public static final BlockEntry<RotatedPillarBlock> JOCOTE_LOG;
    public static final BlockEntry<LeavesBlock> JOCOTE_LEAVES;
    public static final BlockEntry<FruitingBranchBlock> JOCOTE_BRANCH;
    public static final BlockEntry<MahoganyNutBlock> MAHOGANY_NUT;
    public static final BlockEntry<RotatedPillarBlock> RED_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> RED_MANGROVE_WOOD;
    public static final BlockEntry<MangroveRootsBlock> RED_MANGROVE_ROOTS;
    public static final BlockEntry<RotatedPillarBlock> LIGHT_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> LIGHT_MANGROVE_WOOD;
    public static final BlockEntry<MangroveRootsBlock> LIGHT_MANGROVE_ROOTS;
    public static final BlockEntry<RotatedPillarBlock> BLACK_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> BLACK_MANGROVE_WOOD;
    public static final BlockEntry<MangroveRootsBlock> BLACK_MANGROVE_ROOTS;
    public static final BlockEntry<MangroveLeavesBlock> RED_MANGROVE_LEAVES;
    public static final BlockEntry<MangroveLeavesBlock> TALL_MANGROVE_LEAVES;
    public static final BlockEntry<MangroveLeavesBlock> TEA_MANGROVE_LEAVES;
    public static final BlockEntry<MangroveLeavesBlock> BLACK_MANGROVE_LEAVES;
    public static final BlockEntry<PropaguleBlock> RED_MANGROVE_PROPAGULE;
    public static final BlockEntry<PropaguleBlock> TALL_MANGROVE_PROPAGULE;
    public static final BlockEntry<PropaguleBlock> TEA_MANGROVE_PROPAGULE;
    public static final BlockEntry<PropaguleBlock> BLACK_MANGROVE_PROPAGULE;
    public static final BlockEntry<RotatedPillarBlock> STRIPPED_MANGROVE_LOG;
    public static final BlockEntry<RotatedPillarBlock> STRIPPED_MANGROVE_WOOD;
    public static final BlockEntry<Block> MANGROVE_PLANKS;
    public static final BlockEntry<StairBlock> MANGROVE_STAIRS;
    public static final BlockEntry<SlabBlock> MANGROVE_SLAB;
    public static final BlockEntry<FenceBlock> MANGROVE_FENCE;
    public static final BlockEntry<FenceGateBlock> MANGROVE_FENCE_GATE;
    public static final BlockEntry<DoorBlock> MANGROVE_DOOR;
    public static final BlockEntry<TrapDoorBlock> MANGROVE_TRAPDOOR;
    public static final BlockEntry<ButtonBlock> MANGROVE_BUTTON;
    public static final BlockEntry<ButtonBlock> MAHOGANY_BUTTON;
    public static final BlockEntry<ButtonBlock> PALM_BUTTON;
    public static final BlockEntry<ButtonBlock> BAMBOO_BUTTON;
    public static final BlockEntry<ButtonBlock> THATCH_BUTTON;
    public static final BlockEntry<PressurePlateBlock> MANGROVE_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> MAHOGANY_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> PALM_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> BAMBOO_PRESSURE_PLATE;
    public static final BlockEntry<PressurePlateBlock> THATCH_PRESSURE_PLATE;
    public static final BlockEntry<StandingSignBlock> MAHOGANY_SIGN;
    public static final BlockEntry<StandingSignBlock> PALM_SIGN;
    public static final BlockEntry<StandingSignBlock> BAMBOO_SIGN;
    public static final BlockEntry<StandingSignBlock> THATCH_SIGN;
    public static final BlockEntry<StandingSignBlock> MANGROVE_SIGN;
    public static final BlockEntry<WallSignBlock> MAHOGANY_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> PALM_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> BAMBOO_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> THATCH_WALL_SIGN;
    public static final BlockEntry<WallSignBlock> MANGROVE_WALL_SIGN;
    public static final BlockEntry<ReedsBlock> REEDS;
    public static final BlockEntry<PapayaBlock> PAPAYA;
    public static final BlockEntry<FenceBlock> BAMBOO_FENCE;
    public static final BlockEntry<FenceBlock> THATCH_FENCE;
    public static final BlockEntry<FenceBlock> CHUNK_FENCE;
    public static final BlockEntry<FenceBlock> PALM_FENCE;
    public static final BlockEntry<FenceBlock> MAHOGANY_FENCE;
    public static final BlockEntry<FenceGateBlock> BAMBOO_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> THATCH_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> CHUNK_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> PALM_FENCE_GATE;
    public static final BlockEntry<FenceGateBlock> MAHOGANY_FENCE_GATE;
    public static final BlockEntry<WallBlock> CHUNK_WALL;
    public static final BlockEntry<DoorBlock> BAMBOO_DOOR;
    public static final BlockEntry<DoorBlock> PALM_DOOR;
    public static final BlockEntry<DoorBlock> MAHOGANY_DOOR;
    public static final BlockEntry<DoorBlock> THATCH_DOOR;
    public static final BlockEntry<TrapDoorBlock> BAMBOO_TRAPDOOR;
    public static final BlockEntry<TrapDoorBlock> PALM_TRAPDOOR;
    public static final BlockEntry<TrapDoorBlock> MAHOGANY_TRAPDOOR;
    public static final BlockEntry<TrapDoorBlock> THATCH_TRAPDOOR;
    public static final BlockEntry<TallFlowerBlock> IRIS;
    public static final BlockEntry<PineappleBlock> PINEAPPLE;
    public static final BlockEntry<BongoDrumBlock> SMALL_BONGO_DRUM;
    public static final BlockEntry<BongoDrumBlock> MEDIUM_BONGO_DRUM;
    public static final BlockEntry<BongoDrumBlock> LARGE_BONGO_DRUM;
    public static final BlockEntry<LadderBlock> BAMBOO_LADDER;
    public static final BlockEntry<BoardwalkBlock> BAMBOO_BOARDWALK;
    public static final BlockEntry<BoardwalkBlock> PALM_BOARDWALK;
    public static final BlockEntry<BoardwalkBlock> MAHOGANY_BOARDWALK;
    public static final BlockEntry<BoardwalkBlock> MANGROVE_BOARDWALK;
    public static final BlockEntry<BambooChestBlock> BAMBOO_CHEST;
    public static final BlockEntityEntry<BambooChestBlockEntity> BAMBOO_CHEST_ENTITY;
    public static final BlockEntry<SifterBlock> SIFTER;
    public static final BlockEntityEntry<SifterBlockEntity> SIFTER_ENTITY;
    public static final BlockEntry<DrinkMixerBlock> DRINK_MIXER;
    public static final BlockEntityEntry<DrinkMixerBlockEntity> DRINK_MIXER_ENTITY;
    public static final BlockEntry<AirCompressorBlock> AIR_COMPRESSOR;
    public static final BlockEntityEntry<AirCompressorBlockEntity> AIR_COMPRESSOR_ENTITY;
    public static final BlockEntry<VolcanoBlock> VOLCANO;
    public static final BlockEntityEntry<VolcanoBlockEntity> VOLCANO_ENTITY;
    public static final BlockEntry<TikiTorchBlock> TIKI_TORCH;
    public static final BlockEntry<FlowerPotBlock> BAMBOO_FLOWER_POT;
    public static final BlockEntry<CoffeeBushBlock> COFFEE_BUSH;
    public static final BlockEntry<GrowableSinglePlantBlock> GOLDEN_LEATHER_FERN;
    public static final BlockEntry<GrowableDoublePlantBlock> TALL_GOLDEN_LEATHER_FERN;
    public static final BlockEntry<HugePlantBlock> LARGE_GOLDEN_LEATHER_FERN;
    public static final BlockEntry<WaterlilyBlock> FLOWERING_LILY_PAD;
    public static final BlockEntry<DuckweedBlock> DUCKWEED;
    public static final BlockEntry<CustomSeagrassBlock> EEL_GRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_EEL_GRASS;
    public static final BlockEntry<CustomSeagrassBlock> FLOWERING_EEL_GRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> FLOWERING_TALL_EEL_GRASS;
    public static final BlockEntry<Block> MATTED_EEL_GRASS;
    public static final BlockEntry<Block> EEL_GRASS_BLOCK;
    public static final BlockEntry<CustomSeagrassBlock> FERN_SEAGRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_FERN_SEAGRASS;
    public static final BlockEntry<Block> MATTED_FERN_SEAGRASS;
    public static final BlockEntry<Block> FERN_SEAGRASS_BLOCK;
    public static final BlockEntry<CustomSeagrassBlock> SICKLE_SEAGRASS;
    public static final BlockEntry<CustomTallSeagrassBlock> TALL_SICKLE_SEAGRASS;
    public static final BlockEntry<Block> MATTED_SICKLE_SEAGRASS;
    public static final BlockEntry<Block> SICKLE_SEAGRASS_BLOCK;
    public static final BlockEntry<CustomSeagrassBlock> NOODLE_SEAGRASS;
    public static final BlockEntry<Block> MATTED_NOODLE_SEAGRASS;
    public static final BlockEntry<Block> NOODLE_SEAGRASS_BLOCK;
    private static final Set<BlockEntry<? extends Block>> POTTABLE_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> BAMBOO_POTTED_TROPICS_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> VANILLA_POTTED_TROPICS_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> BAMBOO_POTTED_VANILLA_PLANTS;
    public static final List<BlockEntry<FlowerPotBlock>> ALL_POTTED_PLANTS;
    public static final Map<JigarbovTorchType, BlockEntry<? extends RedstoneWallTorchBlock>> JIGARBOV_WALL_TORCHES;

    private static LootItemCondition.Builder hasShears(RegistrateBlockLootTables loot) {
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)loot.itemLookup(), new ItemLike[]{Items.SHEARS}));
    }

    private static LootItemCondition.Builder hasSilkTouch(RegistrateBlockLootTables loot) {
        HolderLookup.RegistryLookup enchantments = loot.getRegistries().lookupOrThrow(Registries.ENCHANTMENT);
        return MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().withComponents(DataComponentMatchers.Builder.components().partial(DataComponentPredicates.ENCHANTMENTS, (DataComponentPredicate)EnchantmentsPredicate.enchantments(List.of(new EnchantmentPredicate((Holder)enchantments.getOrThrow(Enchantments.SILK_TOUCH), MinMaxBounds.Ints.atLeast((int)1))))).build()));
    }

    private static LootItemCondition.Builder hasNoSilkTouch(RegistrateBlockLootTables loot) {
        return TropicraftBlocks.hasSilkTouch(loot).invert();
    }

    private static LootItemCondition.Builder hasShearsOrSilkTouch(RegistrateBlockLootTables loot) {
        return TropicraftBlocks.hasShears(loot).or(TropicraftBlocks.hasSilkTouch(loot));
    }

    private static LootItemCondition.Builder hasNoShearsOrSilkTouch(RegistrateBlockLootTables loot) {
        return TropicraftBlocks.hasShearsOrSilkTouch(loot).invert();
    }

    private static Holder.Reference<Enchantment> fortune(RegistrateBlockLootTables loot) {
        return loot.getRegistries().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.FORTUNE);
    }

    private static void registerPlankRecipe(RegistrateRecipeProvider prov, Supplier<ItemLike> logOrWood, Block output) {
        prov.singleItemUnfinished(DataIngredient.items((ItemLike)logOrWood.get(), (ItemLike[])new ItemLike[0]), RecipeCategory.BUILDING_BLOCKS, () -> output, 1, 4).group("planks").save((RecipeOutput)prov, String.valueOf(prov.safeId((ItemLike)output)) + "_from_" + prov.safeName(logOrWood.get()));
    }

    private static BlockBuilder<DropExperienceBlock, Registrate> ore(String name, MapColor color) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), p)).initialProperties(() -> Blocks.STONE).properties(p -> p.strength(3.0f).mapColor(color)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, Tags.Blocks.ORES}).item().tag(new TagKey[]{Tags.Items.ORES}).build();
    }

    private static BlockBuilder<DropExperienceBlock, Registrate> ore(String name, Supplier<Item> gem, MapColor color) {
        return REGISTRATE.block(name, p -> new DropExperienceBlock((IntProvider)UniformInt.of((int)0, (int)2), p)).initialProperties(() -> Blocks.STONE).properties(p -> p.strength(3.0f).mapColor(color)).loot((loot, block) -> loot.add((Block)block, loot.createSilkTouchDispatchTable((Block)block, (LootPoolEntryContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)gem.get())).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount(TropicraftBlocks.fortune(loot))))))).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE, Tags.Blocks.ORES}).simpleItem();
    }

    private static BlockBuilder<Block, Registrate> oreStorageBlock(String name, MapColor color, ItemEntry<Item> ingredient) {
        return REGISTRATE.block(name, Block::new).properties(p -> p.requiresCorrectToolForDrops().mapColor(color).sound(SoundType.METAL).destroyTime(5.0f).explosionResistance(6.0f)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).recipe((ctx, prov) -> prov.storage((NonNullSupplier)ingredient, RecipeCategory.BUILDING_BLOCKS, (NonNullSupplier)ctx)).simpleItem();
    }

    private static BlockEntry<Block> plantainBunch(String name, Supplier<ItemEntry<Item>> item) {
        return REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.MELON).properties(p -> p.sound(SoundType.WART_BLOCK).strength(0.5f)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_HOE}).loot((tables, block) -> tables.add(block, tables.createSingleItemTableWithSilkTouch(block, (ItemLike)((ItemEntry)item.get()).get(), (NumberProvider)UniformGenerator.between((float)3.0f, (float)5.0f)))).simpleItem().register();
    }

    private static BlockBuilder<BongoDrumBlock, Registrate> bongoDrum(String name, BongoDrumBlock.Size size) {
        return REGISTRATE.block(name, p -> new BongoDrumBlock(size, (BlockBehaviour.Properties)p)).properties(p -> p.mapColor(MapColor.TERRACOTTA_WHITE).strength(2.0f).sound(SoundType.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS)).tag(new TagKey[]{TropicraftTags.Blocks.BONGOS}).blockstate(() -> (ctx, prov) -> prov.createNonTemplateModelBlock((Block)ctx.get())).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern(StringUtils.repeat((char)'T', (int)size.recipeColumns)).pattern(StringUtils.repeat((char)'B', (int)size.recipeColumns)).pattern(StringUtils.repeat((char)'B', (int)size.recipeColumns)).define(Character.valueOf('T'), (ItemLike)TropicraftItems.IGUANA_LEATHER.get()).define(Character.valueOf('B'), (ItemLike)MAHOGANY_PLANKS.get()).group("tropicraft:bongos").unlockedBy("has_" + prov.safeName((ItemLike)TropicraftItems.IGUANA_LEATHER.get()), prov.has((ItemLike)TropicraftItems.IGUANA_LEATHER.get())).save((RecipeOutput)prov)).simpleItem();
    }

    private static BlockBuilder<CustomSeagrassBlock, Registrate> seagrass(String name, String scientificName, @Nullable Supplier<BlockEntry<? extends TallSeagrassBlock>> tall) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new CustomSeagrassBlock((BlockBehaviour.Properties)p, () -> TropicraftBlocks.lambda$seagrass$303((Supplier)tall))).initialProperties(() -> Blocks.SEAGRASS).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears(loot, (Block)block))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateSeagrass).item().properties(p -> p.component(TropicraftDataComponents.SCIENTIFIC_NAME, (Object)scientificName)).model(() -> Models::generateFlatBlockItem).build();
    }

    private static BlockBuilder<CustomTallSeagrassBlock, Registrate> tallSeagrass(String name, BlockEntry<? extends SeagrassBlock> normal) {
        return REGISTRATE.block(name, p -> new CustomTallSeagrassBlock((BlockBehaviour.Properties)p, () -> ((BlockEntry)normal).get())).initialProperties(() -> Blocks.SEAGRASS).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears(loot, (Block)normal.get()))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateTallSeagrass);
    }

    private static BlockBuilder<Block, Registrate> seagrassBlock(String name, String scientificName) {
        return (BlockBuilder)REGISTRATE.block(name + "_block", Block::new).initialProperties(() -> Blocks.SAND).blockstate(() -> (ctx, prov) -> Models.generateSeagrassBlock(name, (DataGenContext<Block, Block>)ctx, prov)).item().properties(p -> p.component(TropicraftDataComponents.SCIENTIFIC_NAME, (Object)scientificName)).build();
    }

    private static BlockBuilder<Block, Registrate> mattedSeagrassBlock(String name, String scientificName) {
        return (BlockBuilder)REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.SAND).blockstate(() -> Models::generateMattedSeagrassBlock).item().properties(p -> p.component(TropicraftDataComponents.SCIENTIFIC_NAME, (Object)scientificName)).build();
    }

    private static BlockEntry<FlowerPotBlock> bambooPot(String name, Supplier<? extends Block> plant) {
        return REGISTRATE.block(name, p -> new FlowerPotBlock(BAMBOO_FLOWER_POT, plant, p)).properties(p -> p.strength(0.2f, 5.0f).sound(SoundType.BAMBOO).pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.pottedPlantLoot(loot, block))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).tag(new TagKey[]{BlockTags.FLOWER_POTS}).blockstate(() -> (ctx, prov) -> Models.generateFlowerPot((DataGenContext<Block, ? extends FlowerPotBlock>)ctx, prov, BAMBOO_FLOWER_POT, prov.modLoc("block/bamboo_side"))).register();
    }

    private static BlockEntry<FlowerPotBlock> vanillaPot(String name, Supplier<? extends Block> plant) {
        return REGISTRATE.block(name, p -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, plant, p)).initialProperties(() -> Blocks.FLOWER_POT).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.pottedPlantLoot(loot, block))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).tag(new TagKey[]{BlockTags.FLOWER_POTS}).blockstate(() -> (ctx, prov) -> Models.generateFlowerPot((DataGenContext<Block, ? extends FlowerPotBlock>)ctx, prov, () -> Blocks.FLOWER_POT, ResourceLocation.withDefaultNamespace((String)"block/flower_pot"))).register();
    }

    private static LootTable.Builder pottedPlantLoot(RegistrateBlockLootTables loot, FlowerPotBlock fullPot) {
        return LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)fullPot.getEmptyPot(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)fullPot.getEmptyPot())))).withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)fullPot.getPotted(), (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)fullPot.getPotted()))));
    }

    private static BlockBuilder<StairBlock, Registrate> stoneStairs(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.stairs(name, block, (TagKey<Block>)BlockTags.STAIRS, (TagKey<Item>)ItemTags.STAIRS).recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, null, true)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE});
    }

    private static BlockBuilder<StairBlock, Registrate> woodenStairs(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.stairs(name, block, (TagKey<Block>)BlockTags.WOODEN_STAIRS, (TagKey<Item>)ItemTags.WOODEN_STAIRS).recipe((ctx, prov) -> prov.stairs(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, "wooden_stairs", false)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE});
    }

    private static BlockBuilder<StairBlock, Registrate> stairs(String name, BlockEntry<? extends Block> block, TagKey<Block> blockTag, TagKey<Item> itemTag) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new StairBlock(((Block)block.get()).defaultBlockState(), p)).initialProperties(block).tag(new TagKey[]{blockTag}).blockstate(() -> (ctx, prov) -> prov.generateStairsBlock((StairBlock)ctx.get(), prov.blockTexture((Block)block.get()))).item().tag(new TagKey[]{itemTag}).build();
    }

    private static BlockBuilder<SlabBlock, Registrate> stoneSlab(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.slab(name, block, (TagKey<Block>)BlockTags.SLABS, (TagKey<Item>)ItemTags.SLABS).recipe((ctx, prov) -> prov.slab(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, null, true)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE});
    }

    private static BlockBuilder<SlabBlock, Registrate> woodenSlab(String name, BlockEntry<? extends Block> block) {
        return TropicraftBlocks.slab(name, block, (TagKey<Block>)BlockTags.WOODEN_SLABS, (TagKey<Item>)ItemTags.WOODEN_SLABS).recipe((ctx, prov) -> prov.slab(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, "wooden_slab", false)).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE});
    }

    private static BlockBuilder<SlabBlock, Registrate> slab(String name, BlockEntry<? extends Block> block, TagKey<Block> blockTag, TagKey<Item> itemTag) {
        return (BlockBuilder)REGISTRATE.block(name, SlabBlock::new).initialProperties(block).loot((loot, slab) -> loot.add((Block)slab, loot.createSlabItemTable((Block)slab))).tag(new TagKey[]{blockTag}).blockstate(() -> (ctx, prov) -> Models.generateSlabBlock((DataGenContext<Block, SlabBlock>)ctx, prov, block)).item().tag(new TagKey[]{itemTag}).build();
    }

    private static BlockBuilder<ButtonBlock, Registrate> woodButton(String name, BlockEntry<? extends Block> block, String texture) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new ButtonBlock(BlockSetType.OAK, 30, p)).initialProperties(block).properties(p -> p.noCollission().strength(0.5f).pushReaction(PushReaction.DESTROY)).tag(new TagKey[]{BlockTags.WOODEN_BUTTONS, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> prov.generateButtonBlock((ButtonBlock)ctx.get(), prov.modLoc("block/" + texture))).recipe((ctx, prov) -> prov.buttonBuilder((ItemLike)ctx.get(), Ingredient.of((ItemLike)block.asItem())).unlockedBy("has_" + prov.safeName((ItemLike)block.get()), prov.has((ItemLike)block.get())).group("wooden_button").save((RecipeOutput)prov)).item().model(() -> (ctx, prov) -> prov.generateWithTemplate((Item)ctx.get(), ModelTemplates.BUTTON_INVENTORY, TextureMapping.defaultTexture((ResourceLocation)prov.modLoc("block/" + texture)))).tag(new TagKey[]{ItemTags.WOODEN_BUTTONS}).build();
    }

    private static BlockBuilder<PressurePlateBlock, Registrate> pressurePlate(String name, BlockEntry<? extends Block> block, String texture) {
        return REGISTRATE.block(name, p -> new PressurePlateBlock(BlockSetType.OAK, p)).initialProperties(block).properties(p -> p.forceSolidOn().instrument(NoteBlockInstrument.BASS).noCollission().strength(0.5f).ignitedByLava().pushReaction(PushReaction.DESTROY)).tag(new TagKey[]{BlockTags.WOODEN_PRESSURE_PLATES, BlockTags.MINEABLE_WITH_AXE}).recipe((ctx, prov) -> prov.pressurePlateBuilder(RecipeCategory.REDSTONE, (ItemLike)ctx.get(), Ingredient.of((ItemLike)block.asItem())).unlockedBy("has_" + prov.safeName((ItemLike)block.get()), prov.has((ItemLike)block.get())).group("wooden_pressure_plate").save((RecipeOutput)prov)).blockstate(() -> (ctx, prov) -> prov.generatePressurePlateBlock((PressurePlateBlock)ctx.get(), prov.modLoc("block/" + texture))).simpleItem();
    }

    private static BlockBuilder<StandingSignBlock, Registrate> standingSign(WoodType woodType, Supplier<? extends Item> item, String texture) {
        String woodName = ResourceLocation.parse((String)woodType.name()).getPath();
        return (BlockBuilder)((BlockBuilder)REGISTRATE.block(woodName + "_sign", p -> new StandingSignBlock(woodType, p)).initialProperties(() -> Blocks.OAK_SIGN).tag(new TagKey[]{BlockTags.STANDING_SIGNS, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> prov.createAirLikeBlock((Block)ctx.get(), prov.modLoc("block/" + texture))).loot((loot, b) -> loot.dropOther((Block)b, (ItemLike)item.get())).setData((GeneratorType)ProviderType.LANG, NonNullBiConsumer.noop())).onRegisterAfter(Registries.BLOCK_ENTITY_TYPE, b -> TropicraftBlocks.extendBlockEntity(BlockEntityType.SIGN, (Block)b));
    }

    private static BlockBuilder<WallSignBlock, Registrate> wallSign(WoodType woodType, Supplier<? extends Item> item, String texture) {
        String woodName = ResourceLocation.parse((String)woodType.name()).getPath();
        return (BlockBuilder)((BlockBuilder)REGISTRATE.block(woodName + "_wall_sign", p -> new WallSignBlock(woodType, p)).initialProperties(() -> Blocks.OAK_SIGN).tag(new TagKey[]{BlockTags.WALL_SIGNS, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> prov.createAirLikeBlock((Block)ctx.get(), prov.modLoc("block/" + texture))).loot((loot, b) -> loot.dropOther((Block)b, (ItemLike)item.get())).setData((GeneratorType)ProviderType.LANG, NonNullBiConsumer.noop())).onRegisterAfter(Registries.BLOCK_ENTITY_TYPE, b -> TropicraftBlocks.extendBlockEntity(BlockEntityType.SIGN, (Block)b));
    }

    @SafeVarargs
    private static BlockBuilder<SaplingBlock, Registrate> sapling(String name, TreeGrower tree, final Supplier<? extends Block> ... validPlantBlocks) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new SaplingBlock(tree, (BlockBehaviour.Properties)p){

            public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
                if (super.canSurvive(state, level, pos)) {
                    return true;
                }
                BlockPos ground = pos.below();
                return this.mayPlaceOn(level.getBlockState(ground), (BlockGetter)level, ground);
            }

            protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
                Block block = state.getBlock();
                if (super.mayPlaceOn(state, level, pos)) {
                    return true;
                }
                return Arrays.stream(validPlantBlocks).map(Supplier::get).anyMatch(b -> b == block);
            }
        }).initialProperties(() -> Blocks.OAK_SAPLING).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).tag(new TagKey[]{BlockTags.SAPLINGS}).blockstate(() -> Models::generateSapling).item().model(() -> Models::generateFlatBlockItem).tag(new TagKey[]{ItemTags.SAPLINGS}).build();
    }

    private static BlockBuilder<LeavesBlock, Registrate> leaves(String name, BlockEntry<SaplingBlock> sapling, float[] saplingRates, boolean normalDecay) {
        return (BlockBuilder)REGISTRATE.block(name, properties -> normalDecay ? new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)TROPICS_LEAF_PARTICLE, properties) : new TropicraftLeavesBlock(0.01f, (ParticleOptions)TROPICS_LEAF_PARTICLE, (BlockBehaviour.Properties)properties)).initialProperties(() -> Blocks.OAK_LEAVES).loot((loot, block) -> loot.add((Block)block, loot.createLeavesDrops((Block)block, (Block)sapling.get(), saplingRates))).tag(new TagKey[]{BlockTags.LEAVES, BlockTags.MINEABLE_WITH_HOE}).item().tag(new TagKey[]{ItemTags.LEAVES}).build();
    }

    private static BlockBuilder<LeavesBlock, Registrate> leaves(String name, boolean normalDecay) {
        return (BlockBuilder)REGISTRATE.block(name, properties -> normalDecay ? new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)TROPICS_LEAF_PARTICLE, properties) : new TropicraftLeavesBlock(0.01f, (ParticleOptions)TROPICS_LEAF_PARTICLE, (BlockBehaviour.Properties)properties)).initialProperties(() -> Blocks.OAK_LEAVES).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears(loot, (Block)block).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(TropicraftBlocks.hasNoShearsOrSilkTouch(loot)).add(((LootPoolSingletonContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance(TropicraftBlocks.fortune(loot), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))))).tag(new TagKey[]{BlockTags.LEAVES, BlockTags.MINEABLE_WITH_HOE}).item().tag(new TagKey[]{ItemTags.LEAVES}).build();
    }

    private static BlockBuilder<UntintedParticleLeavesBlock, Registrate> fruitLeaves(String name, Supplier<SaplingBlock> sapling, Supplier<? extends Item> fruit) {
        return (BlockBuilder)REGISTRATE.block(name, properties -> new UntintedParticleLeavesBlock(0.01f, (ParticleOptions)TROPICS_LEAF_PARTICLE, properties)).initialProperties(() -> Blocks.OAK_LEAVES).loot((loot, block) -> loot.add((Block)block, loot.createLeavesDrops((Block)block, (Block)sapling.get(), FRUIT_SAPLING_RATES).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(TropicraftBlocks.hasNoShearsOrSilkTouch(loot)).add((LootPoolEntryContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)fruit.get()))))))).tag(new TagKey[]{BlockTags.LEAVES, BlockTags.MINEABLE_WITH_HOE}).item().tag(new TagKey[]{ItemTags.LEAVES}).build();
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> log(String name, MapColor topColor, MapColor sideColor) {
        return TropicraftBlocks.log(name, topColor, sideColor, null);
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> mangroveLog(String name, MapColor topColor, MapColor sideColor, @Nullable Supplier<? extends RotatedPillarBlock> strippedLog) {
        return (BlockBuilder)REGISTRATE.block(name, p -> strippedLog != null ? new TropicraftLogBlock((BlockBehaviour.Properties)p, strippedLog) : new RotatedPillarBlock(p)).initialProperties(() -> Blocks.OAK_LOG).properties(p -> TropicraftBlocks.rotatedPillarProperties(p, topColor, sideColor)).tag(new TagKey[]{BlockTags.LOGS, BlockTags.LOGS_THAT_BURN, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> prov.generateLogBlock((RotatedPillarBlock)ctx.get())).item().tag(new TagKey[]{ItemTags.LOGS, ItemTags.LOGS_THAT_BURN, TropicraftTags.Items.MANGROVE_LOGS}).build();
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> log(String name, MapColor topColor, MapColor sideColor, @Nullable Supplier<? extends RotatedPillarBlock> strippedLog) {
        return (BlockBuilder)REGISTRATE.block(name, p -> strippedLog != null ? new TropicraftLogBlock((BlockBehaviour.Properties)p, strippedLog) : new RotatedPillarBlock(p)).initialProperties(() -> Blocks.OAK_LOG).properties(p -> TropicraftBlocks.rotatedPillarProperties(p, topColor, sideColor)).tag(new TagKey[]{BlockTags.LOGS, BlockTags.LOGS_THAT_BURN, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> prov.generateLogBlock((RotatedPillarBlock)ctx.get())).item().tag(new TagKey[]{ItemTags.LOGS, ItemTags.LOGS_THAT_BURN}).build();
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> wood(String name, MapColor color, BlockEntry<? extends RotatedPillarBlock> bark) {
        return TropicraftBlocks.wood(name, color, bark, null);
    }

    private static BlockBuilder<RotatedPillarBlock, Registrate> wood(String name, MapColor color, BlockEntry<? extends RotatedPillarBlock> bark, @Nullable Supplier<? extends RotatedPillarBlock> stripped) {
        return (BlockBuilder)REGISTRATE.block(name, p -> stripped != null ? new TropicraftLogBlock((BlockBehaviour.Properties)p, stripped) : new RotatedPillarBlock(p)).properties(p -> p.sound(SoundType.WOOD).mapColor(color).strength(2.0f).ignitedByLava().instrument(NoteBlockInstrument.BASS)).tag(new TagKey[]{BlockTags.LOGS, BlockTags.LOGS_THAT_BURN, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> {
            ResourceLocation barkTexture = prov.blockTexture((Block)bark.get());
            prov.generateAxisBlock((RotatedPillarBlock)ctx.get(), barkTexture, barkTexture);
        }).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ctx.get()), (int)3).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)bark.get()).group("bark").unlockedBy("has_log", prov.has((ItemLike)Blocks.ACACIA_LOG)).save((RecipeOutput)prov)).item().tag(new TagKey[]{ItemTags.LOGS, ItemTags.LOGS_THAT_BURN}).build();
    }

    private static BlockBuilder<MangroveRootsBlock, Registrate> mangroveRoots(String name) {
        return (BlockBuilder)REGISTRATE.block(name, MangroveRootsBlock::new).properties(p -> p.mapColor(MapColor.WOOD).sound(SoundType.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(2.0f).noOcclusion().isRedstoneConductor((state, world, pos) -> false).hasPostProcess((state, world, pos) -> true)).addLayer(() -> () -> ChunkSectionLayer.CUTOUT_MIPPED).tag(new TagKey[]{TropicraftTags.Blocks.ROOTS, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> Models.generateMangroveRoots((DataGenContext<Block, MangroveRootsBlock>)ctx, prov, name)).item().model(() -> (ctx, prov) -> prov.generateBlockItem((BlockItem)ctx.get(), "_stem")).build();
    }

    private static BlockBuilder<MangroveLeavesBlock, Registrate> mangroveLeaves(String name, Supplier<PropaguleBlock> propagule) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new MangroveLeavesBlock(0.01f, (ParticleOptions)TROPICS_LEAF_PARTICLE, propagule, (BlockBehaviour.Properties)p)).initialProperties(() -> Blocks.OAK_LEAVES).properties(BlockBehaviour.Properties::randomTicks).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.onlyWithSilkTouchOrShears(loot, (Block)block).withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(TropicraftBlocks.hasNoShearsOrSilkTouch(loot)).add(((LootPoolSingletonContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)Items.STICK).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))).when(BonusLevelTableCondition.bonusLevelFlatChance(TropicraftBlocks.fortune(loot), (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))))).tag(new TagKey[]{BlockTags.LEAVES}).item().tag(new TagKey[]{ItemTags.LEAVES}).build();
    }

    private static BlockBuilder<PropaguleBlock, Registrate> propagule(String name, TreeGrower tree, String scientificName) {
        return (BlockBuilder)((BlockBuilder)REGISTRATE.block(name, p -> new PropaguleBlock(tree, (BlockBehaviour.Properties)p)).initialProperties(() -> Blocks.OAK_SAPLING).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).tag(new TagKey[]{BlockTags.SAPLINGS}).blockstate(() -> Models::generatePropagule).setData((GeneratorType)ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((NonNullSupplier)ctx, scientificName))).item().properties(p -> p.component(TropicraftDataComponents.HAS_DESCRIPTION, (Object)Unit.INSTANCE)).model(() -> Models::generateFlatBlockItem).tag(new TagKey[]{ItemTags.SAPLINGS}).build();
    }

    private static BlockBuilder<Block, Registrate> planks(String name, MapColor color, Supplier<DataIngredient> log) {
        return (BlockBuilder)REGISTRATE.block(name, Block::new).initialProperties(() -> Blocks.OAK_PLANKS).properties(p -> p.mapColor(color)).tag(new TagKey[]{BlockTags.PLANKS, BlockTags.MINEABLE_WITH_AXE}).recipe((ctx, prov) -> prov.planks((DataIngredient)log.get(), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx)).item().tag(new TagKey[]{ItemTags.PLANKS}).build();
    }

    private static BlockBuilder<FenceBlock, Registrate> woodenFence(String name, BlockEntry<? extends Block> block, UnaryOperator<ItemBuilder<BlockItem, BlockBuilder<FenceBlock, Registrate>>> itemFunction) {
        BlockBuilder builder = REGISTRATE.block(name, FenceBlock::new).initialProperties(block).tag(new TagKey[]{BlockTags.WOODEN_FENCES, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> prov.generateFenceBlock((FenceBlock)ctx.get(), prov.blockTexture((Block)block.get()))).recipe((ctx, prov) -> prov.fence(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_fence"));
        return (BlockBuilder)((ItemBuilder)itemFunction.apply(builder.item().tag(new TagKey[]{ItemTags.WOODEN_FENCES}).model(() -> (ctx, prov) -> prov.generateWithTemplate((Item)ctx.get(), ModelTemplates.FENCE_INVENTORY, TextureMapping.defaultTexture((Block)((Block)block.get())))))).build();
    }

    private static BlockBuilder<FenceGateBlock, Registrate> fenceGate(String name, BlockEntry<? extends Block> block) {
        return REGISTRATE.block(name, p -> new FenceGateBlock(p, SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE)).initialProperties(block).tag(new TagKey[]{BlockTags.FENCE_GATES, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> prov.generateFenceGateBlock((FenceGateBlock)ctx.get(), prov.blockTexture((Block)block.get()))).recipe((ctx, prov) -> prov.fenceGate(DataIngredient.items((ItemLike)((Block)block.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_fence_gate")).simpleItem();
    }

    private static BlockBuilder<DoorBlock, Registrate> woodenDoor(String name, BlockEntry<? extends Block> material) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new DoorBlock(BlockSetType.OAK, p)).initialProperties(() -> Blocks.OAK_DOOR).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.createSinglePropConditionTable(loot, (Block)block, DoorBlock.HALF, DoubleBlockHalf.LOWER))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).tag(new TagKey[]{BlockTags.WOODEN_DOORS, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> prov.generateDoorBlock((DoorBlock)ctx.get(), prov.modLoc("block/" + ctx.getName() + "_bottom"), prov.modLoc("block/" + ctx.getName() + "_top"))).recipe((ctx, prov) -> prov.door(DataIngredient.items((ItemLike)((Block)material.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_door")).item().defaultModel().tag(new TagKey[]{ItemTags.WOODEN_DOORS}).build();
    }

    private static BlockBuilder<TrapDoorBlock, Registrate> trapdoor(String name, BlockEntry<? extends Block> material) {
        return (BlockBuilder)REGISTRATE.block(name, p -> new TrapDoorBlock(BlockSetType.OAK, p)).initialProperties(() -> Blocks.OAK_TRAPDOOR).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).tag(new TagKey[]{BlockTags.WOODEN_TRAPDOORS, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> prov.generateTrapdoorBlock((TrapDoorBlock)ctx.get(), prov.blockTexture((Block)ctx.get()), true)).recipe((ctx, prov) -> prov.trapDoor(DataIngredient.items((ItemLike)((Block)material.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx, "wooden_trapdoor")).item().tag(new TagKey[]{ItemTags.WOODEN_TRAPDOORS}).model(() -> (ctx, prov) -> prov.generateBlockItem((BlockItem)ctx.get(), "_bottom")).build();
    }

    private static BlockBuilder<BoardwalkBlock, Registrate> boardwalk(String name, BlockEntry<SlabBlock> slab, Either<Supplier<Block>, ResourceLocation> texture) {
        return (BlockBuilder)REGISTRATE.block(name, BoardwalkBlock::new).initialProperties(slab).properties(BlockBehaviour.Properties::noOcclusion).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> (ctx, prov) -> Models.generateBoardwalk((DataGenContext<Block, BoardwalkBlock>)ctx, prov, texture)).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)3).pattern("XXX").pattern("S S").define(Character.valueOf('X'), (ItemLike)slab.get()).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).group("tropicraft:boardwalk").unlockedBy("has_" + prov.safeName((ItemLike)slab.get()), prov.has((ItemLike)slab.get())).save((RecipeOutput)prov)).item().model(() -> (ctx, prov) -> prov.generateBlockItem((BlockItem)ctx.get(), "_short")).build();
    }

    private static BlockBehaviour.Properties rotatedPillarProperties(BlockBehaviour.Properties properties, MapColor topColor, MapColor sideColor) {
        return properties.mapColor(state -> state.getValue((Property)RotatedPillarBlock.AXIS) == Direction.Axis.Y ? topColor : sideColor);
    }

    protected static <T extends Comparable<T> & StringRepresentable> LootTable.Builder createSinglePropConditionTable(RegistrateBlockLootTables loot, Block block, Property<T> property, T value) {
        return LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty(property, value))))));
    }

    private static LootPool.Builder droppingChunksPool(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> chunk) {
        return LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)chunk.get()).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)loot.itemLookup(), ItemTags.SWORDS)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))).otherwise((LootPoolEntryContainer.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)block))));
    }

    protected static LootTable.Builder droppingChunks(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> chunk) {
        return LootTable.lootTable().withPool(TropicraftBlocks.droppingChunksPool(loot, block, chunk));
    }

    protected static LootTable.Builder droppingChunks(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> chunk, LootItemCondition.Builder condition) {
        return LootTable.lootTable().withPool(TropicraftBlocks.droppingChunksPool(loot, block, chunk).when(condition));
    }

    private static LootTable.Builder dropNumberOfItems(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> drop, int minDrops, int maxDrops) {
        return LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)drop.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minDrops, (float)maxDrops)))));
    }

    private static LootTable.Builder onlyWithSilkTouchOrShears(RegistrateBlockLootTables loot, Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().when(TropicraftBlocks.hasShearsOrSilkTouch(loot)).setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)));
    }

    private static LootTable.Builder coffee(RegistrateBlockLootTables loot, Block block, Supplier<? extends ItemLike> drop) {
        return LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)drop.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)new ConstantValue(1.0f))))).withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)drop.get())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)CoffeeBushBlock.AGE, 6))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))));
    }

    private static String name(ItemLike item) {
        return item.asItem().builtInRegistryHolder().key().location().getPath();
    }

    private static void extendBlockEntity(BlockEntityType<?> type, Block block) {
        ((BlockEntityTypeAccessor)type).tropicraft$setValidBlocks((Set<Block>)ImmutableSet.builder().addAll(((BlockEntityTypeAccessor)type).tropicraft$getValidBlocks()).add((Object)block).build());
    }

    private static /* synthetic */ TallSeagrassBlock lambda$seagrass$303(Supplier tall) {
        return (TallSeagrassBlock)((BlockEntry)tall.get()).get();
    }

    static {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            REGISTRATE.addDataGenerator(ProviderType.BLOCKSTATE, prov -> Models.generateBlockStates(prov));
        }
        REGISTRATE.addDataGenerator((GeneratorType)ProviderType.BLOCK_TAGS, prov -> {
            prov.tag(TropicraftTags.Blocks.CARVER_REPLACEABLES).addTags(new TagKey[]{BlockTags.OVERWORLD_CARVER_REPLACEABLES});
            prov.tag(TropicraftTags.Blocks.BIRDS_LIKE_TO_STAND_ON).addTags(new TagKey[]{BlockTags.LOGS}).addTags(new TagKey[]{BlockTags.LEAVES}).addTags(new TagKey[]{TropicraftTags.Blocks.BRANCHES});
        });
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, prov -> {
            TropicraftBlocks.registerPlankRecipe(prov, () -> JOCOTE_LOG, Blocks.JUNGLE_PLANKS);
            TropicraftBlocks.registerPlankRecipe(prov, () -> PAPAYA_LOG, Blocks.JUNGLE_PLANKS);
            TropicraftBlocks.registerPlankRecipe(prov, () -> PAPAYA_WOOD, Blocks.JUNGLE_PLANKS);
            TropicraftBlocks.registerPlankRecipe(prov, () -> STRIPPED_MANGROVE_LOG, (Block)MANGROVE_PLANKS.get());
            TropicraftBlocks.registerPlankRecipe(prov, () -> STRIPPED_MANGROVE_WOOD, (Block)MANGROVE_PLANKS.get());
        });
        TELEPORT_WATER = REGISTRATE.block("teleport_water", PortalWaterBlock::new).initialProperties(() -> Blocks.WATER).blockstate(() -> (ctx, prov) -> prov.create((Block)ctx.get(), prov.mcLoc("block/water"))).register();
        PORTAL_WATER = REGISTRATE.block("portal_water", p -> new LiquidBlock(Fluids.WATER, p)).initialProperties(() -> Blocks.WATER).blockstate(() -> (ctx, prov) -> prov.create((Block)ctx.get(), prov.mcLoc("block/water"))).register();
        CHUNK = REGISTRATE.block("chunk", Block::new).initialProperties(() -> Blocks.STONE).properties(p -> p.mapColor(MapColor.COLOR_BLACK).strength(6.0f).explosionResistance(30.0f)).blockstate(() -> Models::generateAllRotationVariantBlock).tag(new TagKey[]{BlockTags.MINEABLE_WITH_PICKAXE}).lang("Chunk O' Head").simpleItem().register();
        AZURITE_ORE = ((BlockBuilder)TropicraftBlocks.ore("azurite_ore", TropicraftItems.AZURITE, MapColor.STONE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.AZURITE_ORE, Tags.Items.ORES}).build()).register();
        EUDIALYTE_ORE = ((BlockBuilder)TropicraftBlocks.ore("eudialyte_ore", TropicraftItems.EUDIALYTE, MapColor.STONE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.EUDIALYTE_ORE, Tags.Items.ORES}).build()).register();
        MANGANESE_ORE = ((BlockBuilder)TropicraftBlocks.ore("manganese_ore", MapColor.STONE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.MANGANESE_ORE, Tags.Items.ORES}).build()).register();
        SHAKA_ORE = ((BlockBuilder)TropicraftBlocks.ore("shaka_ore", MapColor.COLOR_BLACK).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.SHAKA_ORE, Tags.Items.ORES}).build()).register();
        ZIRCON_ORE = ((BlockBuilder)TropicraftBlocks.ore("zircon_ore", TropicraftItems.ZIRCON, MapColor.STONE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).item().tag(new TagKey[]{TropicraftTags.Items.ZIRCON_ORE, Tags.Items.ORES}).build()).register();
        AZURITE_BLOCK = TropicraftBlocks.oreStorageBlock("azurite_block", MapColor.COLOR_LIGHT_BLUE, TropicraftItems.AZURITE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        EUDIALYTE_BLOCK = TropicraftBlocks.oreStorageBlock("eudialyte_block", MapColor.COLOR_PINK, TropicraftItems.EUDIALYTE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        MANGANESE_BLOCK = TropicraftBlocks.oreStorageBlock("manganese_block", MapColor.COLOR_PURPLE, TropicraftItems.MANGANESE).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        SHAKA_BLOCK = TropicraftBlocks.oreStorageBlock("shaka_block", MapColor.COLOR_BLUE, TropicraftItems.SHAKA).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        ZIRCON_BLOCK = TropicraftBlocks.oreStorageBlock("zircon_block", MapColor.COLOR_RED, TropicraftItems.ZIRCON).tag(new TagKey[]{BlockTags.NEEDS_IRON_TOOL}).register();
        ZIRCONIUM_BLOCK = TropicraftBlocks.oreStorageBlock("zirconium_block", MapColor.COLOR_PINK, TropicraftItems.ZIRCONIUM).register();
        FLOWERS = (Map)Arrays.stream(TropicraftFlower.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), flower -> {
            BlockBuilder builder = (BlockBuilder)REGISTRATE.block(flower.getId(), p -> new TropicsFlowerBlock((TropicraftFlower)flower, flower.getEffect(), flower.getEffectDuration(), flower.getShape(), (BlockBehaviour.Properties)p)).initialProperties(() -> Blocks.POPPY).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).tag(flower.getTags()).blockstate(() -> Models::generateFlower).item().tag(new TagKey[]{ItemTags.FLOWERS}).model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), prov.modLoc("block/flower/" + ctx.getName()))).build();
            Item dye = flower.getDye();
            if (dye != null) {
                builder = builder.recipe((ctx, prov) -> prov.singleItemUnfinished(DataIngredient.items((ItemLike)((TropicsFlowerBlock)((Object)((Object)((Object)ctx.get())))), (ItemLike[])new TropicsFlowerBlock[0]), RecipeCategory.MISC, () -> dye, 1, 2).save((RecipeOutput)prov, Tropicraft.resourceKey(Registries.RECIPE, TropicraftBlocks.name((ItemLike)dye))));
            }
            return builder.register();
        }));
        PURIFIED_SAND = ((BlockBuilder)REGISTRATE.block("purified_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.SAND).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).blockstate(() -> Models::generatePurifiedSand).item().tag(new TagKey[]{ItemTags.SAND}).build()).recipe((ctx, prov) -> {
            prov.smelting(DataIngredient.items((NonNullSupplier)ctx, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.MISC, () -> Blocks.GLASS, 0.3f);
            prov.singleItem(DataIngredient.items((NonNullSupplier)ctx, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.BUILDING_BLOCKS, () -> Blocks.SAND, 1, 1);
        }).register();
        PACKED_PURIFIED_SAND = ((BlockBuilder)REGISTRATE.block("packed_purified_sand", Block::new).initialProperties(() -> Blocks.SAND).properties(p -> p.mapColor(MapColor.STONE).strength(0.8f).requiresCorrectToolForDrops()).blockstate(() -> Models::generateAllRotationVariantBlock).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ctx.get())).pattern("XX").pattern("XX").define(Character.valueOf('X'), (ItemLike)PURIFIED_SAND.get()).unlockedBy("has_purified_sand", prov.has((ItemLike)PURIFIED_SAND.get())).save((RecipeOutput)prov)).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        CORAL_SAND = ((BlockBuilder)REGISTRATE.block("coral_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.SAND).properties(p -> p.mapColor(MapColor.COLOR_PINK)).blockstate(() -> Models::generateAllRotationVariantBlock).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        FOAMY_SAND = ((BlockBuilder)REGISTRATE.block("foamy_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.SAND).properties(p -> p.mapColor(MapColor.COLOR_GREEN)).blockstate(() -> Models::generateAllRotationVariantBlock).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        VOLCANIC_SAND = ((BlockBuilder)REGISTRATE.block("volcanic_sand", VolcanicSandBlock::new).initialProperties(() -> Blocks.SAND).properties(p -> p.mapColor(MapColor.COLOR_LIGHT_GRAY)).blockstate(() -> Models::generateAllRotationVariantBlock).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        MINERAL_SAND = ((BlockBuilder)REGISTRATE.block("mineral_sand", BlockTropicraftSand::new).initialProperties(() -> Blocks.SAND).blockstate(() -> Models::generateAllRotationVariantBlock).tag(new TagKey[]{BlockTags.SAND, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES}).item().tag(new TagKey[]{ItemTags.SAND}).build()).register();
        MUD = REGISTRATE.block("mud", MudBlock::new).initialProperties(() -> Blocks.DIRT).properties(p -> p.speedFactor(0.5f).isValidSpawn((s, w, pa, e) -> true).isRedstoneConductor((s, w, pa) -> true).isViewBlocking((s, w, pa) -> true).isSuffocating((s, w, pa) -> true)).tag(new TagKey[]{TropicraftTags.Blocks.MUD, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES, BlockTags.BAMBOO_PLANTABLE_ON, BlockTags.DIRT, BlockTags.SNOW_LAYER_CAN_SURVIVE_ON, BlockTags.SNIFFER_DIGGABLE_BLOCK}).blockstate(() -> Models::generateMud).simpleItem().register();
        MUD_WITH_PIANGUAS = REGISTRATE.block("mud_with_pianguas", Block::new).initialProperties(MUD).loot((loot, block) -> loot.add(block, (LootTable.Builder)loot.applyExplosionDecay((ItemLike)MUD_WITH_PIANGUAS.get(), (FunctionUserBuilder)LootTable.lootTable().withPool(LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MUD_WITH_PIANGUAS.get())).when(TropicraftBlocks.hasSilkTouch(loot))).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MUD.get()))))).withPool(LootPool.lootPool().when(TropicraftBlocks.hasNoSilkTouch(loot)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)TropicraftItems.PIANGUAS.get())).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount(TropicraftBlocks.fortune(loot)))))))).tag(new TagKey[]{TropicraftTags.Blocks.MUD, BlockTags.MINEABLE_WITH_SHOVEL, TropicraftTags.Blocks.CARVER_REPLACEABLES, BlockTags.BAMBOO_PLANTABLE_ON, BlockTags.DIRT, BlockTags.SNOW_LAYER_CAN_SURVIVE_ON, BlockTags.SNIFFER_DIGGABLE_BLOCK}).blockstate(() -> (ctx, prov) -> prov.createRotatedVariantBlock((Block)ctx.get())).simpleItem().register();
        BAMBOO_BUNDLE = REGISTRATE.block("bamboo_bundle", RotatedPillarBlock::new).properties(p -> p.mapColor(MapColor.PLANT).sound(SoundType.BAMBOO).strength(0.2f, 5.0f)).blockstate(() -> (ctx, prov) -> prov.generateAxisBlock((RotatedPillarBlock)ctx.get(), prov.modLoc("block/bamboo"))).recipe((ctx, prov) -> prov.singleItem(DataIngredient.items(TropicraftItems.BAMBOO_STICK, (NonNullSupplier[])new NonNullSupplier[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, 9, 2)).simpleItem().register();
        THATCH_BUNDLE = REGISTRATE.block("thatch_bundle", RotatedPillarBlock::new).properties(p -> p.mapColor(MapColor.PLANT).sound(SoundType.BAMBOO).strength(0.2f, 5.0f).ignitedByLava().pushReaction(PushReaction.DESTROY)).blockstate(() -> (ctx, prov) -> prov.generateAxisBlock((RotatedPillarBlock)ctx.get(), prov.modLoc("block/thatch"))).recipe((ctx, prov) -> prov.singleItem(DataIngredient.items((ItemLike)Items.SUGAR_CANE, (ItemLike[])new Item[0]), RecipeCategory.BUILDING_BLOCKS, (Supplier)ctx, 4, 1)).simpleItem().register();
        MAHOGANY_PLANKS = TropicraftBlocks.planks("mahogany_planks", MapColor.COLOR_BROWN, () -> DataIngredient.items((ItemLike)((RotatedPillarBlock)MAHOGANY_LOG.get()), (ItemLike[])new RotatedPillarBlock[]{(RotatedPillarBlock)MAHOGANY_WOOD.get()})).register();
        PALM_PLANKS = TropicraftBlocks.planks("palm_planks", MapColor.COLOR_BROWN, () -> DataIngredient.items((ItemLike)((RotatedPillarBlock)PALM_LOG.get()), (ItemLike[])new RotatedPillarBlock[]{(RotatedPillarBlock)PALM_WOOD.get()})).register();
        MAHOGANY_LOG = TropicraftBlocks.log("mahogany_log", MapColor.WOOD, MapColor.COLOR_BROWN).register();
        PALM_LOG = TropicraftBlocks.log("palm_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN).register();
        MAHOGANY_WOOD = TropicraftBlocks.wood("mohogany_wood", MapColor.WOOD, MAHOGANY_LOG).lang("Mahogany Wood").register();
        PALM_WOOD = TropicraftBlocks.wood("palm_wood", MapColor.COLOR_GRAY, PALM_LOG).register();
        PALM_STAIRS = TropicraftBlocks.woodenStairs("palm_stairs", PALM_PLANKS).register();
        MAHOGANY_STAIRS = TropicraftBlocks.woodenStairs("mahogany_stairs", MAHOGANY_PLANKS).register();
        THATCH_STAIRS = TropicraftBlocks.woodenStairs("thatch_stairs", THATCH_BUNDLE).blockstate(() -> Models::generateThatchStairs).register();
        THATCH_STAIRS_FUZZY = TropicraftBlocks.woodenStairs("thatch_stairs_fuzzy", THATCH_BUNDLE).addLayer(() -> () -> ChunkSectionLayer.CUTOUT_MIPPED).blockstate(() -> Models::generateThatchRoof).lang("Thatch Roof").recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)4).pattern("C  ").pattern("XC ").pattern("XXC").define(Character.valueOf('X'), (ItemLike)THATCH_BUNDLE.get()).define(Character.valueOf('C'), (ItemLike)Items.SUGAR_CANE).unlockedBy("has_thatch_bundle", prov.has((ItemLike)THATCH_BUNDLE.get())).save((RecipeOutput)prov)).register();
        BAMBOO_STAIRS = TropicraftBlocks.woodenStairs("bamboo_stairs", BAMBOO_BUNDLE).blockstate(() -> (ctx, prov) -> {
            ResourceLocation side = prov.modLoc("block/bamboo_side");
            ResourceLocation end = prov.modLoc("block/bamboo_end");
            prov.generateStairsBlock((StairBlock)ctx.get(), side, end, end);
        }).register();
        CHUNK_STAIRS = TropicraftBlocks.stoneStairs("chunk_stairs", CHUNK).register();
        COCONUT = ((BlockBuilder)REGISTRATE.block("coconut", CoconutBlock::new).properties(p -> p.mapColor(MapColor.PLANT).strength(2.0f).sound(SoundType.STONE).pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.droppingChunks(loot, (Block)block, TropicraftItems.COCONUT_CHUNK))).tag(new TagKey[]{BlockTags.MINEABLE_WITH_AXE}).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> (ctx, prov) -> prov.createCrossBlock((Block)ctx.get(), BlockModelGenerators.PlantType.NOT_TINTED)).item().model(() -> Models::generateFlatBlockItem).build()).register();
        BAMBOO_SLAB = TropicraftBlocks.woodenSlab("bamboo_slab", BAMBOO_BUNDLE).blockstate(() -> Models::generateBambooSlab).register();
        THATCH_SLAB = TropicraftBlocks.woodenSlab("thatch_slab", THATCH_BUNDLE).blockstate(() -> Models::generateThatchSlab).register();
        CHUNK_SLAB = TropicraftBlocks.stoneSlab("chunk_slab", CHUNK).register();
        PALM_SLAB = TropicraftBlocks.woodenSlab("palm_slab", PALM_PLANKS).register();
        MAHOGANY_SLAB = TropicraftBlocks.woodenSlab("mahogany_slab", MAHOGANY_PLANKS).register();
        GRAPEFRUIT_SAPLING = TropicraftBlocks.sapling("grapefruit_sapling", TropicraftTreeGrowers.GRAPEFRUIT, new Supplier[0]).register();
        LEMON_SAPLING = TropicraftBlocks.sapling("lemon_sapling", TropicraftTreeGrowers.LEMON, new Supplier[0]).register();
        LIME_SAPLING = TropicraftBlocks.sapling("lime_sapling", TropicraftTreeGrowers.LIME, new Supplier[0]).register();
        ORANGE_SAPLING = TropicraftBlocks.sapling("orange_sapling", TropicraftTreeGrowers.ORANGE, new Supplier[0]).register();
        PAPAYA_SAPLING = TropicraftBlocks.sapling("papaya_sapling", TropicraftTreeGrowers.PAPAYA, new Supplier[0]).register();
        MAHOGANY_SAPLING = TropicraftBlocks.sapling("mahogany_sapling", TropicraftTreeGrowers.RAINFOREST, new Supplier[0]).register();
        PALM_SAPLING = TropicraftBlocks.sapling("palm_sapling", TropicraftTreeGrowers.PALM, new Supplier[]{() -> Blocks.SAND, CORAL_SAND, FOAMY_SAND, VOLCANIC_SAND, PURIFIED_SAND, MINERAL_SAND}).register();
        MAHOGANY_LEAVES = TropicraftBlocks.leaves("mahogany_leaves", MAHOGANY_SAPLING, RARE_SAPLING_RATES, false).register();
        PALM_LEAVES = TropicraftBlocks.leaves("palm_leaves", PALM_SAPLING, SAPLING_RATES, false).register();
        KAPOK_LEAVES = TropicraftBlocks.leaves("kapok_leaves", false).register();
        FRUIT_LEAVES = TropicraftBlocks.leaves("fruit_leaves", true).register();
        GRAPEFRUIT_LEAVES = TropicraftBlocks.fruitLeaves("grapefruit_leaves", GRAPEFRUIT_SAPLING, TropicraftItems.GRAPEFRUIT).register();
        LEMON_LEAVES = TropicraftBlocks.fruitLeaves("lemon_leaves", LEMON_SAPLING, TropicraftItems.LEMON).register();
        LIME_LEAVES = TropicraftBlocks.fruitLeaves("lime_leaves", LIME_SAPLING, TropicraftItems.LIME).register();
        ORANGE_LEAVES = TropicraftBlocks.fruitLeaves("orange_leaves", ORANGE_SAPLING, TropicraftItems.ORANGE).register();
        PAPAYA_LEAVES = TropicraftBlocks.leaves("papaya_leaves", PAPAYA_SAPLING, SAPLING_RATES, true).register();
        WHITE_FLOWERING_LEAVES = TropicraftBlocks.leaves("white_flowering_leaves", true).register();
        RED_FLOWERING_LEAVES = TropicraftBlocks.leaves("red_flowering_leaves", true).register();
        BLUE_FLOWERING_LEAVES = TropicraftBlocks.leaves("blue_flowering_leaves", true).register();
        PURPLE_FLOWERING_LEAVES = TropicraftBlocks.leaves("purple_flowering_leaves", true).register();
        YELLOW_FLOWERING_LEAVES = TropicraftBlocks.leaves("yellow_flowering_leaves", true).register();
        PASSIONFRUIT_VINE = ((BlockBuilder)REGISTRATE.block("passionfruit_vine", FruitingVineBlock::new).properties(p -> p.mapColor(MapColor.GRASS).replaceable().noCollission().strength(0.2f).sound(SoundType.VINE).ignitedByLava().pushReaction(PushReaction.DESTROY)).blockstate(() -> Models::generatePassionfruitVine).addLayer(() -> () -> ChunkSectionLayer.CUTOUT_MIPPED).loot((loot, block) -> loot.add((Block)block, loot.createSilkTouchOrShearsDispatchTable((Block)block, (LootPoolEntryContainer.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem(TropicraftItems.PASSIONFRUIT).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)FruitingVineBlock.AGE, 2)))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))))))).item().model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), prov.modLoc("block/passionfruit_vine_1"))).build()).register();
        PAPAYA_LOG = TropicraftBlocks.log("papaya_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN).register();
        PAPAYA_WOOD = TropicraftBlocks.wood("papaya_wood", MapColor.COLOR_GRAY, PAPAYA_LOG).register();
        PLANTAIN_SAPLING = TropicraftBlocks.sapling("plantain_sapling", TropicraftTreeGrowers.PLANTAIN, new Supplier[0]).register();
        PLANTAIN_STEM = TropicraftBlocks.log("plantain_stem", MapColor.COLOR_LIGHT_GREEN, MapColor.COLOR_BROWN).register();
        PLANTAIN_LEAVES = TropicraftBlocks.leaves("plantain_leaves", PLANTAIN_SAPLING, SAPLING_RATES, true).register();
        GREEN_PLANTAIN_BUNCH = TropicraftBlocks.plantainBunch("green_plantain_bunch", () -> TropicraftItems.GREEN_PLANTAIN);
        YELLOW_PLANTAIN_BUNCH = TropicraftBlocks.plantainBunch("yellow_plantain_bunch", () -> TropicraftItems.YELLOW_PLANTAIN);
        JOCOTE_SAPLING = TropicraftBlocks.sapling("jocote_sapling", TropicraftTreeGrowers.JOCOTE, new Supplier[0]).register();
        JOCOTE_LOG = TropicraftBlocks.log("jocote_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN).register();
        JOCOTE_LEAVES = TropicraftBlocks.leaves("jocote_leaves", JOCOTE_SAPLING, SAPLING_RATES, true).register();
        JOCOTE_BRANCH = ((BlockBuilder)REGISTRATE.block("jocote_branch", FruitingBranchBlock::new).properties(p -> p.sound(SoundType.AZALEA).noOcclusion().instabreak().randomTicks().pushReaction(PushReaction.DESTROY)).blockstate(() -> Models::generateJocoteBranch).tag(new TagKey[]{TropicraftTags.Blocks.BRANCHES}).addLayer(() -> () -> ChunkSectionLayer.CUTOUT_MIPPED).loot((loot, block) -> loot.add((Block)block, LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block)).add(LootItem.lootTableItem(TropicraftItems.JOCOTE).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)FruitingBranchBlock.AGE, 2)))))))).item().model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), prov.modLoc("block/jocote_branch_horizontal_0"))).build()).register();
        MAHOGANY_NUT = ((BlockBuilder)REGISTRATE.block("mahogany_nut", MahoganyNutBlock::new).initialProperties(() -> Blocks.COCOA).blockstate(() -> Models::generateMahoganyNut).loot((loot, block) -> loot.add((Block)block, LootTable.lootTable().withPool((LootPool.Builder)loot.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)MahoganyNutBlock.AGE, 2)))))))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT_MIPPED).item().model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), ModelTemplates.FLAT_ITEM)).build()).register();
        RED_MANGROVE_LOG = TropicraftBlocks.mangroveLog("red_mangrove_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_LOG.get()).register();
        RED_MANGROVE_WOOD = TropicraftBlocks.wood("red_mangrove_wood", MapColor.COLOR_GRAY, RED_MANGROVE_LOG, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_WOOD.get()).register();
        RED_MANGROVE_ROOTS = TropicraftBlocks.mangroveRoots("red_mangrove_roots").register();
        LIGHT_MANGROVE_LOG = TropicraftBlocks.mangroveLog("light_mangrove_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_LOG.get()).register();
        LIGHT_MANGROVE_WOOD = TropicraftBlocks.wood("light_mangrove_wood", MapColor.COLOR_GRAY, LIGHT_MANGROVE_LOG, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_WOOD.get()).register();
        LIGHT_MANGROVE_ROOTS = TropicraftBlocks.mangroveRoots("light_mangrove_roots").register();
        BLACK_MANGROVE_LOG = TropicraftBlocks.mangroveLog("black_mangrove_log", MapColor.COLOR_GRAY, MapColor.COLOR_BROWN, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_LOG.get()).register();
        BLACK_MANGROVE_WOOD = TropicraftBlocks.wood("black_mangrove_wood", MapColor.COLOR_GRAY, BLACK_MANGROVE_LOG, () -> (RotatedPillarBlock)STRIPPED_MANGROVE_WOOD.get()).register();
        BLACK_MANGROVE_ROOTS = TropicraftBlocks.mangroveRoots("black_mangrove_roots").register();
        RED_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("red_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)RED_MANGROVE_PROPAGULE.get()))).register();
        TALL_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("tall_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)TALL_MANGROVE_PROPAGULE.get()))).register();
        TEA_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("tea_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)TEA_MANGROVE_PROPAGULE.get()))).register();
        BLACK_MANGROVE_LEAVES = TropicraftBlocks.mangroveLeaves("black_mangrove_leaves", () -> (PropaguleBlock)((Object)((Object)BLACK_MANGROVE_PROPAGULE.get()))).register();
        RED_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("red_mangrove_propagule", TropicraftTreeGrowers.RED_MANGROVE, "Rhizophora mangle").register();
        TALL_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("tall_mangrove_propagule", TropicraftTreeGrowers.TALL_MANGROVE, "Rhizophora racemosa").register();
        TEA_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("tea_mangrove_propagule", TropicraftTreeGrowers.TEA_MANGROVE, "Pelliciera rhizophorae").register();
        BLACK_MANGROVE_PROPAGULE = TropicraftBlocks.propagule("black_mangrove_propagule", TropicraftTreeGrowers.BLACK_MANGROVE, "Avicennia germinans").register();
        STRIPPED_MANGROVE_LOG = TropicraftBlocks.mangroveLog("stripped_mangrove_log", MapColor.COLOR_RED, MapColor.COLOR_RED, null).register();
        STRIPPED_MANGROVE_WOOD = TropicraftBlocks.wood("stripped_mangrove_wood", MapColor.COLOR_RED, STRIPPED_MANGROVE_LOG).register();
        MANGROVE_PLANKS = TropicraftBlocks.planks("mangrove_planks", MapColor.COLOR_BROWN, () -> DataIngredient.items(LIGHT_MANGROVE_LOG, (NonNullSupplier[])new NonNullSupplier[]{RED_MANGROVE_LOG, BLACK_MANGROVE_LOG, LIGHT_MANGROVE_WOOD, RED_MANGROVE_WOOD, BLACK_MANGROVE_WOOD})).register();
        MANGROVE_STAIRS = TropicraftBlocks.woodenStairs("mangrove_stairs", MANGROVE_PLANKS).register();
        MANGROVE_SLAB = TropicraftBlocks.woodenSlab("mangrove_slab", MANGROVE_PLANKS).register();
        MANGROVE_FENCE = TropicraftBlocks.woodenFence("mangrove_fence", MANGROVE_PLANKS, i -> i).register();
        MANGROVE_FENCE_GATE = TropicraftBlocks.fenceGate("mangrove_fence_gate", MANGROVE_PLANKS).register();
        MANGROVE_DOOR = TropicraftBlocks.woodenDoor("mangrove_door", MANGROVE_PLANKS).register();
        MANGROVE_TRAPDOOR = TropicraftBlocks.trapdoor("mangrove_trapdoor", MANGROVE_PLANKS).register();
        MANGROVE_BUTTON = TropicraftBlocks.woodButton("mangrove_button", MANGROVE_PLANKS, "mangrove_planks").register();
        MAHOGANY_BUTTON = TropicraftBlocks.woodButton("mahogany_button", MAHOGANY_PLANKS, "mahogany_planks").register();
        PALM_BUTTON = TropicraftBlocks.woodButton("palm_button", PALM_PLANKS, "palm_planks").register();
        BAMBOO_BUTTON = TropicraftBlocks.woodButton("bamboo_button", BAMBOO_BUNDLE, "bamboo_end").register();
        THATCH_BUTTON = TropicraftBlocks.woodButton("thatch_button", THATCH_BUNDLE, "thatch_end").register();
        MANGROVE_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("mangrove_pressure_plate", MANGROVE_PLANKS, "mangrove_planks").register();
        MAHOGANY_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("mahogany_pressure_plate", MAHOGANY_PLANKS, "mahogany_planks").register();
        PALM_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("palm_pressure_plate", PALM_PLANKS, "palm_planks").register();
        BAMBOO_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("bamboo_pressure_plate", BAMBOO_BUNDLE, "bamboo_end").register();
        THATCH_PRESSURE_PLATE = TropicraftBlocks.pressurePlate("thatch_pressure_plate", THATCH_BUNDLE, "thatch_end").register();
        MAHOGANY_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.MAHOGANY, () -> (Item)TropicraftItems.MAHOGANY_SIGN.get(), "mahogany_planks").register();
        PALM_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.PALM, () -> (Item)TropicraftItems.PALM_SIGN.get(), "palm_planks").register();
        BAMBOO_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.BAMBOO, () -> (Item)TropicraftItems.BAMBOO_SIGN.get(), "bamboo_end").register();
        THATCH_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.THATCH, () -> (Item)TropicraftItems.THATCH_SIGN.get(), "thatch_end").register();
        MANGROVE_SIGN = TropicraftBlocks.standingSign(TropicraftWoodTypes.MANGROVE, () -> (Item)TropicraftItems.MANGROVE_SIGN.get(), "mangrove_planks").register();
        MAHOGANY_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.MAHOGANY, () -> (Item)TropicraftItems.MAHOGANY_SIGN.get(), "mahogany_planks").register();
        PALM_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.PALM, () -> (Item)TropicraftItems.PALM_SIGN.get(), "palm_planks").register();
        BAMBOO_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.BAMBOO, () -> (Item)TropicraftItems.BAMBOO_SIGN.get(), "bamboo_end").register();
        THATCH_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.THATCH, () -> (Item)TropicraftItems.THATCH_SIGN.get(), "thatch_end").register();
        MANGROVE_WALL_SIGN = TropicraftBlocks.wallSign(TropicraftWoodTypes.MANGROVE, () -> (Item)TropicraftItems.MANGROVE_SIGN.get(), "mangrove_planks").register();
        REEDS = ((BlockBuilder)REGISTRATE.block("reeds", ReedsBlock::new).initialProperties(() -> Blocks.SUGAR_CANE).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateReeds).item().model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), prov.modLoc("block/" + ctx.getName() + "_top_tall"))).build()).register();
        PAPAYA = REGISTRATE.block("papaya", PapayaBlock::new).properties(p -> p.mapColor(MapColor.PLANT).randomTicks().strength(0.2f, 3.0f).sound(SoundType.WOOD).noOcclusion().pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)loot.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem(TropicraftItems.PAPAYA).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PapayaBlock.AGE, 1))))))))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generatePapaya).register();
        BAMBOO_FENCE = TropicraftBlocks.woodenFence("bamboo_fence", BAMBOO_BUNDLE, item -> item.tag(new TagKey[]{ItemTags.WOODEN_FENCES}).model(() -> (ctx, prov) -> prov.generateWithTemplate((Item)ctx.get(), ModelTemplates.FENCE_INVENTORY, TextureMapping.defaultTexture((ResourceLocation)prov.modLoc("block/bamboo_side"))))).blockstate(() -> (ctx, prov) -> prov.generateFenceBlock((FenceBlock)ctx.get(), prov.modLoc("block/bamboo_side"))).register();
        THATCH_FENCE = TropicraftBlocks.woodenFence("thatch_fence", THATCH_BUNDLE, item -> item.tag(new TagKey[]{ItemTags.WOODEN_FENCES}).model(() -> (ctx, prov) -> prov.generateWithTemplate((Item)ctx.get(), ModelTemplates.FENCE_INVENTORY, TextureMapping.defaultTexture((ResourceLocation)prov.modLoc("block/thatch_side"))))).blockstate(() -> (ctx, prov) -> prov.generateFenceBlock((FenceBlock)ctx.get(), prov.modLoc("block/thatch_side"))).register();
        CHUNK_FENCE = TropicraftBlocks.woodenFence("chunk_fence", CHUNK, i -> i).register();
        PALM_FENCE = TropicraftBlocks.woodenFence("palm_fence", PALM_PLANKS, i -> i).register();
        MAHOGANY_FENCE = TropicraftBlocks.woodenFence("mahogany_fence", MAHOGANY_PLANKS, i -> i).register();
        BAMBOO_FENCE_GATE = TropicraftBlocks.fenceGate("bamboo_fence_gate", BAMBOO_BUNDLE).blockstate(() -> (ctx, prov) -> prov.generateFenceGateBlock((FenceGateBlock)ctx.get(), prov.modLoc("block/bamboo_side"))).register();
        THATCH_FENCE_GATE = TropicraftBlocks.fenceGate("thatch_fence_gate", THATCH_BUNDLE).blockstate(() -> (ctx, prov) -> prov.generateFenceGateBlock((FenceGateBlock)ctx.get(), prov.modLoc("block/thatch_side"))).register();
        CHUNK_FENCE_GATE = TropicraftBlocks.fenceGate("chunk_fence_gate", CHUNK).register();
        PALM_FENCE_GATE = TropicraftBlocks.fenceGate("palm_fence_gate", PALM_PLANKS).register();
        MAHOGANY_FENCE_GATE = TropicraftBlocks.fenceGate("mahogany_fence_gate", MAHOGANY_PLANKS).register();
        CHUNK_WALL = ((BlockBuilder)REGISTRATE.block("chunk_wall", WallBlock::new).initialProperties(CHUNK).tag(new TagKey[]{BlockTags.WALLS}).blockstate(() -> (ctx, prov) -> prov.generateWallBlock((WallBlock)ctx.get(), prov.blockTexture((Block)CHUNK.get()))).recipe((ctx, prov) -> prov.wall(DataIngredient.items((ItemLike)((Block)CHUNK.get()), (ItemLike[])new Block[0]), RecipeCategory.DECORATIONS, (Supplier)ctx)).item().tag(new TagKey[]{ItemTags.WALLS}).model(() -> (ctx, prov) -> prov.generateWithTemplate((Item)ctx.get(), ModelTemplates.WALL_INVENTORY, new TextureMapping().put(TextureSlot.WALL, prov.modLoc("block/" + CHUNK.getId().getPath())))).build()).register();
        BAMBOO_DOOR = TropicraftBlocks.woodenDoor("bamboo_door", BAMBOO_BUNDLE).register();
        PALM_DOOR = TropicraftBlocks.woodenDoor("palm_door", PALM_PLANKS).register();
        MAHOGANY_DOOR = TropicraftBlocks.woodenDoor("mahogany_door", MAHOGANY_PLANKS).register();
        THATCH_DOOR = TropicraftBlocks.woodenDoor("thatch_door", THATCH_BUNDLE).register();
        BAMBOO_TRAPDOOR = TropicraftBlocks.trapdoor("bamboo_trapdoor", BAMBOO_BUNDLE).register();
        PALM_TRAPDOOR = TropicraftBlocks.trapdoor("palm_trapdoor", PALM_PLANKS).register();
        MAHOGANY_TRAPDOOR = TropicraftBlocks.trapdoor("mahogany_trapdoor", MAHOGANY_PLANKS).register();
        THATCH_TRAPDOOR = TropicraftBlocks.trapdoor("thatch_trapdoor", THATCH_BUNDLE).register();
        IRIS = ((BlockBuilder)REGISTRATE.block("iris", TallFlowerBlock::new).properties(p -> p.mapColor(MapColor.PLANT).noCollission().instabreak().sound(SoundType.GRASS).replaceable().ignitedByLava().pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.createSinglePropConditionTable(loot, (Block)block, DoublePlantBlock.HALF, DoubleBlockHalf.LOWER))).tag(new TagKey[]{BlockTags.FLOWERS}).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateDoublePlant).recipe((ctx, prov) -> prov.singleItemUnfinished(DataIngredient.items((ItemLike)((TallFlowerBlock)ctx.get()), (ItemLike[])new TallFlowerBlock[0]), RecipeCategory.MISC, () -> Items.PURPLE_DYE, 1, 4).save((RecipeOutput)prov, Tropicraft.resourceKey(Registries.RECIPE, TropicraftBlocks.name((ItemLike)Items.PURPLE_DYE)))).item().model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), prov.modLoc("block/iris_top"))).build()).register();
        PINEAPPLE = ((BlockBuilder)REGISTRATE.block("pineapple", PineappleBlock::new).properties(p -> p.mapColor(MapColor.PLANT).randomTicks().noCollission().instabreak().sound(SoundType.GRASS).replaceable().ignitedByLava().pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.droppingChunks(loot, (Block)block, TropicraftItems.PINEAPPLE_CUBES, (LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateDoublePlant).item().model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), prov.modLoc("block/pineapple_top"))).build()).register();
        SMALL_BONGO_DRUM = TropicraftBlocks.bongoDrum("small_bongo_drum", BongoDrumBlock.Size.SMALL).register();
        MEDIUM_BONGO_DRUM = TropicraftBlocks.bongoDrum("medium_bongo_drum", BongoDrumBlock.Size.MEDIUM).register();
        LARGE_BONGO_DRUM = TropicraftBlocks.bongoDrum("large_bongo_drum", BongoDrumBlock.Size.LARGE).register();
        BAMBOO_LADDER = ((BlockBuilder)REGISTRATE.block("bamboo_ladder", LadderBlock::new).initialProperties(() -> Blocks.LADDER).properties(p -> p.sound(SoundType.BAMBOO)).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).tag(new TagKey[]{BlockTags.CLIMBABLE, BlockTags.MINEABLE_WITH_AXE}).blockstate(() -> Models::generateLadder).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)4).pattern("S S").pattern("BSB").pattern("S S").define(Character.valueOf('S'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).define(Character.valueOf('B'), (ItemLike)Items.BAMBOO).unlockedBy("has_bamboo", prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov)).item().model(() -> Models::generateFlatBlockItem).build()).register();
        BAMBOO_BOARDWALK = TropicraftBlocks.boardwalk("bamboo_boardwalk", BAMBOO_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.right((Object)Tropicraft.location("block/bamboo_side"))).register();
        PALM_BOARDWALK = TropicraftBlocks.boardwalk("palm_boardwalk", PALM_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.left(PALM_PLANKS)).register();
        MAHOGANY_BOARDWALK = TropicraftBlocks.boardwalk("mahogany_boardwalk", MAHOGANY_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.left(MAHOGANY_PLANKS)).register();
        MANGROVE_BOARDWALK = TropicraftBlocks.boardwalk("mangrove_boardwalk", MANGROVE_SLAB, (Either<Supplier<Block>, ResourceLocation>)Either.left(MANGROVE_PLANKS)).register();
        BAMBOO_CHEST = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("bamboo_chest", BambooChestBlock::new).initialProperties(BAMBOO_BUNDLE).properties(p -> p.strength(1.0f)).blockstate(() -> (ctx, prov) -> prov.createAirLikeBlock((Block)ctx.get(), prov.modLoc("block/bamboo_side"))).blockEntity(BambooChestBlockEntity::new).renderer(() -> BambooChestRenderer::new).build()).item().model(() -> (ctx, prov) -> Models.generateChestItem((DataGenContext<Item, BlockItem>)ctx, prov, Tropicraft.location("bamboo"), prov.modLoc("block/bamboo_side"))).build()).addMiscData((GeneratorType)ProviderType.LANG, prov -> {
            prov.add("tropicraft.container.bambooChest", "Bamboo Chest");
            prov.add("tropicraft.container.bambooChestDouble", "Large Bamboo Chest");
        })).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("BBB").pattern("B B").pattern("BBB").define(Character.valueOf('B'), (ItemLike)Items.BAMBOO).unlockedBy("has_bamboo", prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov)).register();
        BAMBOO_CHEST_ENTITY = BlockEntityEntry.cast((RegistryEntry)BAMBOO_CHEST.getSibling(Registries.BLOCK_ENTITY_TYPE));
        SIFTER = ((BlockBuilder)((BlockBuilder)REGISTRATE.block("sifter", SifterBlock::new).initialProperties(() -> Blocks.OAK_PLANKS).properties(BlockBehaviour.Properties::noOcclusion).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockEntity(SifterBlockEntity::new).renderer(() -> SifterBlockEntityRenderer::new).build()).setData((GeneratorType)ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((NonNullSupplier)ctx, "Place any type of tropics or regular sand in the sifter. What treasures are hidden inside?"))).recipe((ctx, prov) -> {
            ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("XXX").pattern("XIX").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.GLASS_BLOCKS).group("tropicraft:sifter").unlockedBy("has_glass", prov.has(Tags.Items.GLASS_BLOCKS)).save((RecipeOutput)prov);
            ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("XXX").pattern("XIX").pattern("XXX").define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.GLASS_PANES).group("tropicraft:sifter").unlockedBy("has_glass_pane", prov.has(Tags.Items.GLASS_PANES)).save((RecipeOutput)prov, Tropicraft.resourceKey(Registries.RECIPE, "sifter_with_glass_pane"));
        }).simpleItem().register();
        SIFTER_ENTITY = BlockEntityEntry.cast((RegistryEntry)SIFTER.getSibling(Registries.BLOCK_ENTITY_TYPE));
        DRINK_MIXER = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("drink_mixer", DrinkMixerBlock::new).properties(p -> p.mapColor(MapColor.STONE).strength(2.0f, 30.0f).noOcclusion().instrument(NoteBlockInstrument.BASEDRUM)).blockstate(() -> (ctx, prov) -> prov.createAirLikeBlock((Block)ctx.get(), prov.modLoc("block/chunk"))).blockEntity(DrinkMixerBlockEntity::new).renderer(() -> DrinkMixerBlockEntityRenderer::new).build()).item().properties(p -> p.component(TropicraftDataComponents.HAS_DESCRIPTION, (Object)Unit.INSTANCE)).model(() -> Models::generateDrinkMixerItem).build()).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).setData((GeneratorType)ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((NonNullSupplier)ctx, "Place two drink ingredients on the mixer, then place an empty mug on the base, then ???, then enjoy!"))).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("XXX").pattern("XYX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)CHUNK.get()).define(Character.valueOf('Y'), (ItemLike)TropicraftItems.BAMBOO_MUG.get()).unlockedBy("has_bamboo_mug", prov.has((ItemLike)TropicraftItems.BAMBOO_MUG.get())).save((RecipeOutput)prov)).register();
        DRINK_MIXER_ENTITY = BlockEntityEntry.cast((RegistryEntry)DRINK_MIXER.getSibling(Registries.BLOCK_ENTITY_TYPE));
        AIR_COMPRESSOR = ((BlockBuilder)((BlockBuilder)((BlockBuilder)REGISTRATE.block("air_compressor", AirCompressorBlock::new).properties(p -> p.mapColor(MapColor.STONE).strength(2.0f, 30.0f).noOcclusion().instrument(NoteBlockInstrument.BASEDRUM)).blockstate(() -> (ctx, prov) -> prov.createAirLikeBlock((Block)ctx.get(), prov.modLoc("block/chunk"))).blockEntity(AirCompressorBlockEntity::new).renderer(() -> AirCompressorBlockEntityRenderer::new).build()).item().properties(p -> p.component(TropicraftDataComponents.HAS_DESCRIPTION, (Object)Unit.INSTANCE)).model(() -> Models::generateAirCompressorItem).build()).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).setData((GeneratorType)ProviderType.LANG, (ctx, prov) -> prov.addBlockWithTooltip((NonNullSupplier)ctx, "Place an empty scuba harness in the compressor to fill it with air!"))).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get()), (int)1).pattern("XXX").pattern("XYX").pattern("XXX").define(Character.valueOf('X'), (ItemLike)CHUNK.get()).define(Character.valueOf('Y'), (ItemLike)TropicraftItems.AZURITE.get()).unlockedBy("has_" + prov.safeName((ItemLike)CHUNK.get()), prov.has((ItemLike)CHUNK.get())).unlockedBy("has_" + prov.safeName((ItemLike)TropicraftItems.AZURITE.get()), prov.has((ItemLike)TropicraftItems.AZURITE.get())).save((RecipeOutput)prov)).register();
        AIR_COMPRESSOR_ENTITY = BlockEntityEntry.cast((RegistryEntry)AIR_COMPRESSOR.getSibling(Registries.BLOCK_ENTITY_TYPE));
        VOLCANO = REGISTRATE.block("volcano", VolcanoBlock::new).initialProperties(() -> Blocks.BEDROCK).properties(BlockBehaviour.Properties::noLootTable).blockstate(() -> Models::generateVolcanoBlock).simpleBlockEntity(VolcanoBlockEntity::new).register();
        VOLCANO_ENTITY = BlockEntityEntry.cast((RegistryEntry)VOLCANO.getSibling(Registries.BLOCK_ENTITY_TYPE));
        TIKI_TORCH = ((BlockBuilder)REGISTRATE.block("tiki_torch", TikiTorchBlock::new).initialProperties(() -> Blocks.TORCH).properties(p -> p.sound(SoundType.WOOD).lightLevel(state -> state.getValue(TikiTorchBlock.SECTION) == TikiTorchBlock.TorchSection.UPPER ? 15 : 0)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.createSinglePropConditionTable(loot, block, TikiTorchBlock.SECTION, TikiTorchBlock.TorchSection.UPPER))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateTikiTorch).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("Y").pattern("X").pattern("X").define(Character.valueOf('X'), (ItemLike)TropicraftItems.BAMBOO_STICK.get()).define(Character.valueOf('Y'), ItemTags.COALS).unlockedBy("has_bamboo_stick", prov.has((ItemLike)TropicraftItems.BAMBOO_STICK.get())).save((RecipeOutput)prov)).item().defaultModel().build()).register();
        BAMBOO_FLOWER_POT = ((BlockBuilder)REGISTRATE.block("bamboo_flower_pot", p -> new FlowerPotBlock(null, () -> Blocks.AIR, p)).properties(p -> p.strength(0.2f, 5.0f).sound(SoundType.BAMBOO).pushReaction(PushReaction.DESTROY)).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> (ctx, prov) -> Models.generateFlowerPot((DataGenContext<Block, ? extends FlowerPotBlock>)ctx, prov, (Supplier<? extends Block>)ctx, prov.modLoc("block/bamboo_side"))).recipe((ctx, prov) -> ShapedRecipeBuilder.shaped((HolderGetter)prov.itemLookup(), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ctx.get())).pattern("#D#").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.BAMBOO).define(Character.valueOf('D'), (ItemLike)Items.DIRT).unlockedBy("has_bamboo", prov.has((ItemLike)Items.BAMBOO)).save((RecipeOutput)prov)).item().defaultModel().build()).register();
        COFFEE_BUSH = REGISTRATE.block("coffee_bush", CoffeeBushBlock::new).properties(p -> p.mapColor(MapColor.GRASS).strength(0.15f).sound(SoundType.GRASS).noOcclusion().pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.add((Block)block, TropicraftBlocks.coffee(loot, (Block)COFFEE_BUSH.get(), TropicraftItems.RAW_COFFEE_BEAN))).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateCoffeeBush).register();
        GOLDEN_LEATHER_FERN = ((BlockBuilder)REGISTRATE.block("small_golden_leather_fern", p -> new GrowableSinglePlantBlock((BlockBehaviour.Properties)p, () -> TALL_GOLDEN_LEATHER_FERN)).initialProperties(() -> Blocks.FERN).properties(p -> p.offsetType(BlockBehaviour.OffsetType.XZ)).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> (ctx, prov) -> prov.createCrossBlock((Block)ctx.get(), BlockModelGenerators.PlantType.NOT_TINTED, TextureMapping.cross((ResourceLocation)prov.modLoc("block/small_golden_leather_fern")))).lang("Golden Leather Fern").item().model(() -> (ctx, prov) -> prov.generateFlatItem((Item)ctx.get(), prov.modLoc("item/golden_leather_fern"))).build()).register();
        TALL_GOLDEN_LEATHER_FERN = REGISTRATE.block("tall_golden_leather_fern", p -> new GrowableDoublePlantBlock((BlockBehaviour.Properties)p, () -> LARGE_GOLDEN_LEATHER_FERN).setPickItem(() -> GOLDEN_LEATHER_FERN)).initialProperties(() -> Blocks.LARGE_FERN).loot((loot, block) -> loot.dropOther((Block)block, (ItemLike)GOLDEN_LEATHER_FERN.get())).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateDoublePlant).register();
        LARGE_GOLDEN_LEATHER_FERN = REGISTRATE.block("golden_leather_fern", p -> new HugePlantBlock((BlockBehaviour.Properties)p).setPickItem(() -> GOLDEN_LEATHER_FERN)).properties(p -> p.mapColor(MapColor.PLANT).noOcclusion().noCollission().instabreak().sound(SoundType.GRASS).pushReaction(PushReaction.DESTROY)).loot((loot, block) -> loot.dropOther((Block)block, (ItemLike)GOLDEN_LEATHER_FERN.get())).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateLargeGoldenLeatherFern).lang("Large Golden Leather Fern").register();
        FLOWERING_LILY_PAD = ((BlockBuilder)REGISTRATE.block("flowering_lily_pad", WaterlilyBlock::new).properties(p -> p.mapColor(MapColor.PLANT).noOcclusion().instabreak().sound(SoundType.LILY_PAD).pushReaction(PushReaction.DESTROY)).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateFloweringLilyPad).tag(new TagKey[]{BlockTags.SWORD_EFFICIENT, BlockTags.INSIDE_STEP_SOUND_BLOCKS, BlockTags.FROG_PREFER_JUMP_TO}).color(NonNullSupplier.of(() -> () -> (blockState, blockAndTintGetter, blockPos, i) -> blockAndTintGetter != null && blockPos != null ? -14647248 : -9321636)).item(PlaceOnWaterBlockItem::new).model(() -> Models::generateFlatBlockItem).build()).register();
        DUCKWEED = ((BlockBuilder)REGISTRATE.block("duckweed", DuckweedBlock::new).properties(p -> p.mapColor(MapColor.PLANT).noCollission().noOcclusion().instabreak().sound(SoundType.LILY_PAD).pushReaction(PushReaction.DESTROY)).addLayer(() -> () -> ChunkSectionLayer.CUTOUT).blockstate(() -> Models::generateDuckweed).tag(new TagKey[]{BlockTags.SWORD_EFFICIENT}).item(PlaceOnWaterBlockItem::new).model(() -> Models::generateFlatBlockItem).build()).register();
        EEL_GRASS = TropicraftBlocks.seagrass("eel_grass", "Enhalus acoroides", () -> TALL_EEL_GRASS).register();
        TALL_EEL_GRASS = TropicraftBlocks.tallSeagrass("tall_eel_grass", EEL_GRASS).register();
        FLOWERING_EEL_GRASS = TropicraftBlocks.seagrass("flowering_eel_grass", "Enhalus acoroides", () -> FLOWERING_TALL_EEL_GRASS).register();
        FLOWERING_TALL_EEL_GRASS = TropicraftBlocks.tallSeagrass("flowering_tall_eel_grass", FLOWERING_EEL_GRASS).register();
        MATTED_EEL_GRASS = TropicraftBlocks.mattedSeagrassBlock("matted_eel_grass", "Enhalus acoroides").register();
        EEL_GRASS_BLOCK = TropicraftBlocks.seagrassBlock("eel_grass", "Enhalus acoroides").register();
        FERN_SEAGRASS = TropicraftBlocks.seagrass("fern_seagrass", "Halophila spinulosa", () -> TALL_FERN_SEAGRASS).register();
        TALL_FERN_SEAGRASS = TropicraftBlocks.tallSeagrass("tall_fern_seagrass", FERN_SEAGRASS).register();
        MATTED_FERN_SEAGRASS = TropicraftBlocks.mattedSeagrassBlock("matted_fern_seagrass", "Halophila spinulosa").register();
        FERN_SEAGRASS_BLOCK = TropicraftBlocks.seagrassBlock("fern_seagrass", "Halophila spinulosa").register();
        SICKLE_SEAGRASS = TropicraftBlocks.seagrass("sickle_seagrass", "Thalassodendron ciliatum", () -> TALL_SICKLE_SEAGRASS).register();
        TALL_SICKLE_SEAGRASS = TropicraftBlocks.tallSeagrass("tall_sickle_seagrass", SICKLE_SEAGRASS).register();
        MATTED_SICKLE_SEAGRASS = TropicraftBlocks.mattedSeagrassBlock("matted_sickle_seagrass", "Thalassodendron ciliatum").register();
        SICKLE_SEAGRASS_BLOCK = TropicraftBlocks.seagrassBlock("sickle_seagrass", "Thalassodendron ciliatum").register();
        NOODLE_SEAGRASS = TropicraftBlocks.seagrass("noodle_seagrass", "Syringodium isoetifolium", null).register();
        MATTED_NOODLE_SEAGRASS = TropicraftBlocks.mattedSeagrassBlock("matted_noodle_seagrass", "Syringodium isoetifolium").register();
        NOODLE_SEAGRASS_BLOCK = TropicraftBlocks.seagrassBlock("noodle_seagrass", "Syringodium isoetifolium").register();
        POTTABLE_PLANTS = ImmutableSet.builder().add((Object[])new BlockEntry[]{PALM_SAPLING, MAHOGANY_SAPLING, GRAPEFRUIT_SAPLING, LEMON_SAPLING, LIME_SAPLING, ORANGE_SAPLING}).add(IRIS).addAll(FLOWERS.values()).build();
        BAMBOO_POTTED_TROPICS_PLANTS = POTTABLE_PLANTS.stream().map(plant -> TropicraftBlocks.bambooPot("bamboo_potted_" + plant.getId().getPath(), (Supplier<? extends Block>)plant)).toList();
        VANILLA_POTTED_TROPICS_PLANTS = POTTABLE_PLANTS.stream().map(plant -> TropicraftBlocks.vanillaPot("potted_" + plant.getId().getPath(), (Supplier<? extends Block>)plant)).toList();
        BAMBOO_POTTED_VANILLA_PLANTS = Stream.of(Blocks.OAK_SAPLING, Blocks.SPRUCE_SAPLING, Blocks.BIRCH_SAPLING, Blocks.JUNGLE_SAPLING, Blocks.ACACIA_SAPLING, Blocks.DARK_OAK_SAPLING, Blocks.FERN, Blocks.DANDELION, Blocks.POPPY, Blocks.BLUE_ORCHID, Blocks.ALLIUM, Blocks.AZURE_BLUET, Blocks.RED_TULIP, Blocks.ORANGE_TULIP, Blocks.WHITE_TULIP, Blocks.PINK_TULIP, Blocks.OXEYE_DAISY, Blocks.CORNFLOWER, Blocks.LILY_OF_THE_VALLEY, Blocks.WITHER_ROSE, Blocks.RED_MUSHROOM, Blocks.BROWN_MUSHROOM, Blocks.DEAD_BUSH, Blocks.CACTUS).map(plant -> TropicraftBlocks.bambooPot("bamboo_potted_" + TropicraftBlocks.name((ItemLike)plant), () -> plant)).toList();
        ALL_POTTED_PLANTS = ImmutableList.builder().addAll(BAMBOO_POTTED_TROPICS_PLANTS).addAll(VANILLA_POTTED_TROPICS_PLANTS).addAll(BAMBOO_POTTED_VANILLA_PLANTS).build();
        JIGARBOV_WALL_TORCHES = (Map)Arrays.stream(JigarbovTorchType.values()).collect(ImmutableMap.toImmutableMap(Function.identity(), type -> ((BlockBuilder)REGISTRATE.block("jigarbov_" + type.getName() + "_wall_torch", p -> new RedstoneWallTorchBlock((BlockBehaviour.Properties)p){

            public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
                return new ItemStack((ItemLike)Items.REDSTONE_TORCH);
            }
        }).initialProperties(() -> Blocks.REDSTONE_TORCH).setData((GeneratorType)ProviderType.LANG, (ctx, prov) -> {})).addLayer(() -> () -> ChunkSectionLayer.CUTOUT_MIPPED).blockstate(() -> (ctx, prov) -> Models.generateJigarbovTorch((DataGenContext<Block, ? extends Block>)ctx, prov, type)).loot((loot, block) -> loot.dropOther((Block)block, (ItemLike)Items.REDSTONE_TORCH)).register()));
    }

    private static class Models {
        public static final TextureSlot WOOD_SLOT = TextureSlot.create((String)"wood");
        public static final TextureSlot HORIZONTAL_SLOT = TextureSlot.create((String)"horizontal");
        public static final TextureSlot VERTICAL_SLOT = TextureSlot.create((String)"vertical");
        public static final TextureSlot BUSH_SLOT = TextureSlot.create((String)"bush");
        public static final TextureSlot JIGARBOV_SLOT = TextureSlot.create((String)"jigarbov");
        public static final TextureSlot PLANKS_SLOT = TextureSlot.create((String)"planks");
        public static final TextureSlot VINE_SLOT = TextureSlot.create((String)"vine");
        public static final ModelTemplate ITEM_FRAME_TEMPLATE = ModelTemplates.create((String)"item_frame", (TextureSlot[])new TextureSlot[]{WOOD_SLOT});
        public static final ModelTemplate ITEM_FRAME_MAP_TEMPLATE = ModelTemplates.create((String)"item_frame_map", (TextureSlot[])new TextureSlot[]{WOOD_SLOT});
        public static final ModelTemplate FUZZY_STAIRS_TEMPLATE = ModelTemplates.create((String)Tropicraft.location("stairs_fuzzy").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.SIDE, TextureSlot.BOTTOM, TextureSlot.TOP, TextureSlot.CROSS});
        public static final ModelTemplate FUZZY_STAIRS_OUTER_TEMPLATE = ModelTemplates.create((String)Tropicraft.location("stairs_fuzzy_outer").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.SIDE, TextureSlot.BOTTOM, TextureSlot.TOP, TextureSlot.CROSS});
        public static final ModelTemplate FRUITING_BRANCH = ModelTemplates.create((String)Tropicraft.location("fruiting_branch").toString(), (TextureSlot[])new TextureSlot[]{HORIZONTAL_SLOT, VERTICAL_SLOT});
        public static final ModelTemplate COFFEE_BUSH = ModelTemplates.create((String)Tropicraft.location("coffee_bush").toString(), (TextureSlot[])new TextureSlot[]{BUSH_SLOT});
        public static final ModelTemplate HUGE_CROSS = ModelTemplates.create((String)Tropicraft.location("huge_cross").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.CROSS, TextureSlot.PARTICLE});
        public static final ModelTemplate JIGARBOV_TORCH = ModelTemplates.create((String)Tropicraft.location("jigarbov_wall_torch").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.TORCH, JIGARBOV_SLOT});
        public static final ModelTemplate JIGARBOV_TORCH_UNLIT = ModelTemplates.create((String)Tropicraft.location("jigarbov_wall_torch_unlit").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.TORCH, JIGARBOV_SLOT});
        public static final ModelTemplate TALL_MACHINE = ModelTemplates.createItem((String)Tropicraft.location("tall_machine").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.PARTICLE});
        public static final ModelTemplate TALL_TORCH_TEMPLATE = ModelTemplates.create((String)Tropicraft.location("template_tall_torch").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.TORCH});
        public static final ModelTemplate LADDER_TEMPLATE = ModelTemplates.create((String)"ladder", (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.PARTICLE});
        public static final ModelTemplate VINE_TEMPLATE = ModelTemplates.create((String)"vine", (TextureSlot[])new TextureSlot[]{VINE_SLOT, TextureSlot.PARTICLE});
        private static final List<VariantMutator> ALL_Y_ROTATIONS = List.of(BlockModelGenerators.NOP, BlockModelGenerators.Y_ROT_90, BlockModelGenerators.Y_ROT_180, BlockModelGenerators.Y_ROT_270);
        private static final List<VariantMutator> ALL_ROTATIONS = List.of(BlockModelGenerators.NOP, BlockModelGenerators.X_ROT_90, BlockModelGenerators.X_ROT_180, BlockModelGenerators.X_ROT_270, BlockModelGenerators.Y_ROT_90, BlockModelGenerators.Y_ROT_90.then(BlockModelGenerators.X_ROT_90), BlockModelGenerators.Y_ROT_90.then(BlockModelGenerators.X_ROT_180), BlockModelGenerators.Y_ROT_90.then(BlockModelGenerators.X_ROT_270), BlockModelGenerators.Y_ROT_180, BlockModelGenerators.Y_ROT_180.then(BlockModelGenerators.X_ROT_90), BlockModelGenerators.Y_ROT_180.then(BlockModelGenerators.X_ROT_180), BlockModelGenerators.Y_ROT_180.then(BlockModelGenerators.X_ROT_270), BlockModelGenerators.Y_ROT_270, BlockModelGenerators.Y_ROT_270.then(BlockModelGenerators.X_ROT_90), BlockModelGenerators.Y_ROT_270.then(BlockModelGenerators.X_ROT_180), BlockModelGenerators.Y_ROT_270.then(BlockModelGenerators.X_ROT_270));

        private Models() {
        }

        public static void generateBlockStates(RegistrateBlockModelGenerator prov) {
            TextureMapping bambooItemFrameTextures = new TextureMapping().put(TextureSlot.PARTICLE, prov.modLoc("block/bamboo_side")).put(WOOD_SLOT, prov.modLoc("block/bamboo_side"));
            ITEM_FRAME_TEMPLATE.create(prov.modLoc("block/bamboo_item_frame"), bambooItemFrameTextures, prov.modelOutput);
            ITEM_FRAME_MAP_TEMPLATE.create(prov.modLoc("block/bamboo_item_frame_map"), bambooItemFrameTextures, prov.modelOutput);
        }

        public static ResourceLocation fuzzyStairs(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockModelGenerator prov, String suffix, ModelTemplate template, String side, String end, String cross) {
            TextureMapping textures = new TextureMapping().put(TextureSlot.SIDE, prov.modLoc("block/" + side)).put(TextureSlot.BOTTOM, prov.modLoc("block/" + end)).put(TextureSlot.TOP, prov.modLoc("block/" + end)).put(TextureSlot.CROSS, prov.modLoc("block/" + cross));
            return template.createWithSuffix((Block)ctx.get(), suffix, textures, prov.modelOutput);
        }

        public static void generateDoublePlant(DataGenContext<Block, ? extends DoublePlantBlock> ctx, RegistrateBlockModelGenerator prov) {
            MultiVariant topVariant = BlockModelGenerators.plainVariant((ResourceLocation)prov.createSuffixedVariant((Block)ctx.get(), "_top", ModelTemplates.CROSS, TextureMapping::cross));
            MultiVariant bottomVariant = BlockModelGenerators.plainVariant((ResourceLocation)prov.createSuffixedVariant((Block)ctx.get(), "_bottom", ModelTemplates.CROSS, TextureMapping::cross));
            prov.createDoubleBlock((Block)ctx.get(), topVariant, bottomVariant);
        }

        public static void generateFlatBlockItem(DataGenContext<Item, ? extends BlockItem> ctx, RegistrateItemModelGenerator prov) {
            prov.generateFlatBlockItem((BlockItem)ctx.get());
        }

        public static ResourceLocation cubeTop(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockModelGenerator prov, String suffix) {
            return ModelTemplates.CUBE_TOP.createWithSuffix((Block)ctx.get(), suffix, new TextureMapping().put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)((Block)ctx.get()))).put(TextureSlot.TOP, TextureMapping.getBlockTexture((Block)((Block)ctx.get()), (String)suffix)), prov.modelOutput);
        }

        public static List<Weighted<Variant>> allYRotations(Variant variant, int weight) {
            return ALL_Y_ROTATIONS.stream().map(rotation -> new Weighted((Object)variant.with(rotation), weight)).toList();
        }

        public static List<Weighted<Variant>> allRotations(Variant variant, int weight) {
            return ALL_ROTATIONS.stream().map(rotation -> new Weighted((Object)variant.with(rotation), weight)).toList();
        }

        public static void generateLadder(DataGenContext<Block, LadderBlock> ctx, RegistrateBlockModelGenerator prov) {
            ResourceLocation model = LADDER_TEMPLATE.create((Block)ctx.get(), TextureMapping.defaultTexture((Block)((Block)ctx.get())), prov.modelOutput);
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get()), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)model)).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
        }

        private static void generateChestItem(DataGenContext<Item, BlockItem> ctx, RegistrateItemModelGenerator prov, ResourceLocation texture, ResourceLocation particle) {
            ResourceLocation baseModel = ModelTemplates.CHEST_INVENTORY.create((Item)ctx.get(), TextureMapping.particle((ResourceLocation)particle), prov.modelOutput);
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.specialModel((ResourceLocation)baseModel, (SpecialModelRenderer.Unbaked)new ChestSpecialRenderer.Unbaked(texture)));
        }

        public static void generateAllRotationVariantBlock(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockModelGenerator prov) {
            Variant variant = BlockModelGenerators.plainModel((ResourceLocation)TexturedModel.CUBE.create((Block)ctx.get(), prov.modelOutput));
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get()), (MultiVariant)Models.createAllRotationVariants(variant)));
        }

        public static MultiVariant createAllRotationVariants(Variant variant) {
            return BlockModelGenerators.variants((Variant[])((Variant[])ALL_ROTATIONS.stream().map(arg_0 -> ((Variant)variant).with(arg_0)).toArray(Variant[]::new)));
        }

        private static void generateFlower(DataGenContext<Block, TropicsFlowerBlock> ctx, RegistrateBlockModelGenerator prov) {
            TextureMapping textures = TextureMapping.cross((ResourceLocation)prov.modLoc("block/flower/" + ctx.getName()));
            prov.createCrossBlock((Block)ctx.get(), BlockModelGenerators.PlantType.NOT_TINTED, textures);
        }

        private static void generatePurifiedSand(DataGenContext<Block, BlockTropicraftSand> ctx, RegistrateBlockModelGenerator prov) {
            Variant normal = BlockModelGenerators.plainModel((ResourceLocation)TexturedModel.CUBE.create((Block)ctx.get(), prov.modelOutput));
            Variant calcified = BlockModelGenerators.plainModel((ResourceLocation)Models.cubeTop(ctx, prov, "_calcified"));
            Variant dune1 = BlockModelGenerators.plainModel((ResourceLocation)Models.cubeTop(ctx, prov, "_dune1"));
            Variant dune2 = BlockModelGenerators.plainModel((ResourceLocation)Models.cubeTop(ctx, prov, "_dune2"));
            Variant starfish = BlockModelGenerators.plainModel((ResourceLocation)Models.cubeTop(ctx, prov, "_starfish"));
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockTropicraftSand.UNDERWATER, (MultiVariant)new MultiVariant(WeightedList.builder().addAll(Models.allRotations(normal, 50)).addAll(Models.allYRotations(dune1, 10)).addAll(Models.allYRotations(dune2, 10)).addAll(Models.allYRotations(starfish, 1)).build()), (MultiVariant)new MultiVariant(WeightedList.builder().addAll(Models.allRotations(normal, 50)).addAll(Models.allYRotations(calcified, 5)).build()))));
        }

        private static void generateMud(DataGenContext<Block, MudBlock> ctx, RegistrateBlockModelGenerator prov) {
            Variant normal = BlockModelGenerators.plainModel((ResourceLocation)TexturedModel.CUBE.create((Block)ctx.get(), prov.modelOutput));
            Variant withStones = BlockModelGenerators.plainModel((ResourceLocation)ModelTemplates.CUBE_ALL.createWithSuffix((Block)ctx.get(), "_with_stones", TextureMapping.cube((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)ctx.get()), (String)"_with_stones")), prov.modelOutput));
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get()), (MultiVariant)new MultiVariant(WeightedList.builder().addAll(Models.allYRotations(normal, 5)).addAll(Models.allYRotations(withStones, 1)).build())));
        }

        private static void generateThatchRoof(DataGenContext<Block, StairBlock> ctx, RegistrateBlockModelGenerator prov) {
            ResourceLocation straightModel = Models.fuzzyStairs(ctx, prov, "", FUZZY_STAIRS_TEMPLATE, "thatch_side", "thatch_end", "thatch_grass");
            ResourceLocation innerModel = prov.modLoc("block/thatch_stairs_inner");
            ResourceLocation outerModel = Models.fuzzyStairs(ctx, prov, "_outer", FUZZY_STAIRS_OUTER_TEMPLATE, "thatch_side", "thatch_end", "thatch_grass");
            prov.blockStateOutput.accept(BlockModelGenerators.createStairs((Block)((Block)ctx.get()), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)innerModel), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)straightModel), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)outerModel)));
        }

        private static void generateThatchStairs(DataGenContext<Block, StairBlock> ctx, RegistrateBlockModelGenerator prov) {
            ResourceLocation side = prov.modLoc("block/thatch_side");
            ResourceLocation end = prov.modLoc("block/thatch_end");
            prov.generateStairsBlock((StairBlock)ctx.get(), side, end, end);
        }

        private static void generateBambooSlab(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockModelGenerator prov) {
            ResourceLocation side = prov.modLoc("block/bamboo_side");
            ResourceLocation end = prov.modLoc("block/bamboo_end");
            prov.generateSlabBlock((SlabBlock)ctx.get(), BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)BAMBOO_BUNDLE.get()))), side, end, end);
        }

        private static void generateThatchSlab(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockModelGenerator prov) {
            ResourceLocation side = prov.modLoc("block/thatch_side");
            ResourceLocation end = prov.modLoc("block/thatch_end");
            prov.generateSlabBlock((SlabBlock)ctx.get(), BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)THATCH_BUNDLE.get()))), side, end, end);
        }

        private static void generatePassionfruitVine(DataGenContext<Block, FruitingVineBlock> ctx, RegistrateBlockModelGenerator prov) {
            Map multifaceProperties = BlockModelGenerators.selectMultifaceProperties((StateHolder)((FruitingVineBlock)((Object)ctx.get())).defaultBlockState(), MultifaceBlock::getFaceProperty);
            MultiPartGenerator builder = MultiPartGenerator.multiPart((Block)((Block)ctx.get()));
            Iterator iterator = FruitingVineBlock.AGE.getPossibleValues().iterator();
            while (iterator.hasNext()) {
                int age = (Integer)iterator.next();
                ResourceLocation texture = prov.modLoc("block/" + ctx.getName() + "_" + age);
                TextureMapping textures = new TextureMapping().put(VINE_SLOT, texture).put(TextureSlot.PARTICLE, texture);
                MultiVariant model = BlockModelGenerators.plainVariant((ResourceLocation)VINE_TEMPLATE.createWithSuffix((Block)ctx.get(), "_" + age, textures, prov.modelOutput));
                for (Map.Entry entry : multifaceProperties.entrySet()) {
                    Property faceProperty = (Property)entry.getKey();
                    VariantMutator faceMutator = (VariantMutator)entry.getValue();
                    ConditionBuilder condition = BlockModelGenerators.condition().term((Property)FruitingVineBlock.AGE, (Comparable)Integer.valueOf(age)).term(faceProperty, (Comparable)Boolean.valueOf(true));
                    builder.with(condition, model.with(faceMutator));
                }
            }
            prov.blockStateOutput.accept(builder);
        }

        private static void generateJocoteBranch(DataGenContext<Block, FruitingBranchBlock> ctx, RegistrateBlockModelGenerator prov) {
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get())).with(PropertyDispatch.initial((Property)FruitingBranchBlock.AGE).generate(age -> BlockModelGenerators.plainVariant((ResourceLocation)FRUITING_BRANCH.createWithSuffix((Block)ctx.get(), "_age" + age, new TextureMapping().put(HORIZONTAL_SLOT, prov.modLoc("block/jocote_branch_horizontal_" + age)).put(VERTICAL_SLOT, prov.modLoc("block/jocote_branch_vertical")), prov.modelOutput)))).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING));
        }

        private static void generateMahoganyNut(DataGenContext<Block, MahoganyNutBlock> ctx, RegistrateBlockModelGenerator prov) {
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get())).with((PropertyDispatch)PropertyDispatch.initial((Property)BlockStateProperties.AGE_2).select((Comparable)Integer.valueOf(0), (Object)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)ctx.get()), (String)"_0"))).select((Comparable)Integer.valueOf(1), (Object)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)ctx.get()), (String)"_1"))).select((Comparable)Integer.valueOf(2), (Object)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)ctx.get()), (String)"_2")))));
        }

        private static void generateReeds(DataGenContext<Block, ReedsBlock> ctx, RegistrateBlockModelGenerator prov) {
            Function models = Util.memoize(texture -> {
                ResourceLocation location = prov.modLoc("block/" + texture);
                return BlockModelGenerators.plainModel((ResourceLocation)ModelTemplates.CROP.create(location, TextureMapping.singleSlot((TextureSlot)TextureSlot.CROP, (ResourceLocation)location), prov.modelOutput));
            });
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get())).with(PropertyDispatch.initial(ReedsBlock.TYPE).generate(type -> BlockModelGenerators.variants((Variant[])((Variant[])Arrays.stream(type.getTextures()).map(models).toArray(Variant[]::new))))));
        }

        private static void generatePapaya(DataGenContext<Block, PapayaBlock> ctx, RegistrateBlockModelGenerator prov) {
            TextureSlot cocoaSlot = TextureSlot.create((String)"cocoa");
            TextureMapping texturesStage0 = TextureMapping.singleSlot((TextureSlot)cocoaSlot, (ResourceLocation)prov.modLoc("block/papaya_stage0"));
            MultiVariant stage0 = BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.create((String)"cocoa_stage2", (TextureSlot[])new TextureSlot[]{cocoaSlot}).createWithSuffix((Block)ctx.get(), "_stage0", texturesStage0, prov.modelOutput));
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get())).with((PropertyDispatch)PropertyDispatch.initial((Property)BlockStateProperties.AGE_1).select((Comparable)Integer.valueOf(0), (Object)stage0).select((Comparable)Integer.valueOf(1), (Object)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)ctx.get()), (String)"_stage1")))).with(BlockModelGenerators.ROTATION_HORIZONTAL_FACING_ALT));
        }

        private static void generateVolcanoBlock(DataGenContext<Block, VolcanoBlock> ctx, RegistrateBlockModelGenerator prov) {
            MultiVariant variant = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)Blocks.BEDROCK));
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get()), (MultiVariant)variant));
        }

        private static void generateTikiTorch(DataGenContext<Block, TikiTorchBlock> ctx, RegistrateBlockModelGenerator prov) {
            MultiVariant tikiLower = BlockModelGenerators.plainVariant((ResourceLocation)TALL_TORCH_TEMPLATE.createWithSuffix((Block)ctx.get(), "_lower", TextureMapping.torch((ResourceLocation)prov.modLoc("block/tiki_torch_lower")), prov.modelOutput));
            MultiVariant tikiUpper = BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.TORCH.createWithSuffix((Block)ctx.get(), "_upper", TextureMapping.torch((ResourceLocation)prov.modLoc("block/tiki_torch_upper")), prov.modelOutput));
            Block block = (Block)ctx.get();
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)PropertyDispatch.initial(TikiTorchBlock.SECTION).select((Comparable)((Object)TikiTorchBlock.TorchSection.LOWER), (Object)tikiLower).select((Comparable)((Object)TikiTorchBlock.TorchSection.MIDDLE), (Object)tikiLower).select((Comparable)((Object)TikiTorchBlock.TorchSection.UPPER), (Object)tikiUpper)));
        }

        private static void generateFlowerPot(DataGenContext<Block, ? extends FlowerPotBlock> ctx, RegistrateBlockModelGenerator prov, Supplier<? extends Block> empty, ResourceLocation particle) {
            Block flower = ((FlowerPotBlock)ctx.get()).getPotted();
            boolean isVanilla = flower.builtInRegistryHolder().key().location().getNamespace().equals("minecraft");
            String flowerName = TropicraftBlocks.name((ItemLike)flower);
            TextureSlot flowerpotSlot = TextureSlot.create((String)"flowerpot");
            ModelTemplate template = flower == Blocks.AIR ? ModelTemplates.create((String)"flower_pot", (TextureSlot[])new TextureSlot[]{flowerpotSlot, TextureSlot.PARTICLE}) : (!isVanilla ? ModelTemplates.create((String)"flower_pot_cross", (TextureSlot[])new TextureSlot[]{flowerpotSlot, TextureSlot.PLANT, TextureSlot.PARTICLE}) : ModelTemplates.create((String)("potted_" + flowerName), (TextureSlot[])new TextureSlot[]{flowerpotSlot, TextureSlot.PARTICLE}));
            TextureMapping textures = new TextureMapping().put(flowerpotSlot, prov.blockTexture(empty.get())).put(TextureSlot.PARTICLE, prov.modLoc("block/bamboo_side"));
            if (!isVanilla) {
                if (flower instanceof TropicsFlowerBlock) {
                    textures.put(TextureSlot.PLANT, prov.modLoc("block/flower/" + flowerName));
                } else if (flower instanceof TallFlowerBlock) {
                    textures.put(TextureSlot.PLANT, prov.modLoc("block/" + flowerName + "_top"));
                } else {
                    textures.put(TextureSlot.PLANT, prov.blockTexture(flower));
                }
            }
            prov.generateWithTemplate((Block)ctx.get(), template, textures);
        }

        private static void generateCoffeeBush(DataGenContext<Block, CoffeeBushBlock> ctx, RegistrateBlockModelGenerator prov) {
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get())).with(PropertyDispatch.initial((Property)CoffeeBushBlock.AGE).generate(age -> {
                TextureMapping textures = TextureMapping.singleSlot((TextureSlot)BUSH_SLOT, (ResourceLocation)prov.modLoc("block/" + ctx.getName() + "_stage" + age));
                return BlockModelGenerators.plainVariant((ResourceLocation)COFFEE_BUSH.createWithSuffix((Block)ctx.get(), "_stage_" + age, textures, prov.modelOutput));
            })));
        }

        private static void generateLargeGoldenLeatherFern(DataGenContext<Block, HugePlantBlock> ctx, RegistrateBlockModelGenerator prov) {
            TextureMapping textures = new TextureMapping().put(TextureSlot.CROSS, prov.modLoc("block/large_golden_leather_fern")).put(TextureSlot.PARTICLE, TextureMapping.getBlockTexture((Block)((Block)GOLDEN_LEATHER_FERN.get())));
            MultiVariant model = BlockModelGenerators.plainVariant((ResourceLocation)HUGE_CROSS.create((Block)ctx.get(), textures, prov.modelOutput));
            prov.blockStateOutput.accept(MultiPartGenerator.multiPart((Block)((Block)ctx.get())).with(BlockModelGenerators.condition().term(HugePlantBlock.TYPE, (Comparable)((Object)HugePlantBlock.Type.CENTER)), model));
        }

        private static void generateFloweringLilyPad(DataGenContext<Block, WaterlilyBlock> ctx, RegistrateBlockModelGenerator prov) {
            ModelTemplate template = ModelTemplates.create((String)Tropicraft.location("water_lily_with_flower").toString(), (TextureSlot[])new TextureSlot[]{TextureSlot.TEXTURE, TextureSlot.PLANT});
            TextureMapping textures = new TextureMapping().put(TextureSlot.TEXTURE, TextureMapping.getBlockTexture((Block)Blocks.LILY_PAD)).put(TextureSlot.PLANT, TextureMapping.getBlockTexture((Block)((Block)ctx.get())));
            MultiVariant variant = BlockModelGenerators.createRotatedVariants((Variant)BlockModelGenerators.plainModel((ResourceLocation)template.create((Block)ctx.get(), textures, prov.modelOutput)));
            prov.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)((Block)ctx.get()), (MultiVariant)variant));
        }

        private static void generateDuckweed(DataGenContext<Block, DuckweedBlock> ctx, RegistrateBlockModelGenerator prov) {
            ResourceLocation texture = prov.modLoc("block/duckweed");
            TextureMapping textures = new TextureMapping().put(TextureSlot.WOOL, texture).put(TextureSlot.PARTICLE, texture);
            prov.generateWithTemplate((Block)ctx.get(), ModelTemplates.CARPET, textures);
        }

        private static void generateSeagrass(DataGenContext<Block, CustomSeagrassBlock> ctx, RegistrateBlockModelGenerator prov) {
            prov.createTrivialBlock((Block)ctx.get(), TexturedModel.SEAGRASS);
        }

        private static void generateTallSeagrass(DataGenContext<Block, CustomTallSeagrassBlock> ctx, RegistrateBlockModelGenerator prov) {
            prov.createDoubleBlock((Block)ctx.get(), BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.SEAGRASS.createWithSuffix((Block)ctx.get(), "_top", TextureMapping.defaultTexture((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)ctx.get()), (String)"_top")), prov.modelOutput)), BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.SEAGRASS.createWithSuffix((Block)ctx.get(), "_bottom", TextureMapping.defaultTexture((ResourceLocation)TextureMapping.getBlockTexture((Block)((Block)ctx.get()), (String)"_bottom")), prov.modelOutput)));
        }

        private static void generateSeagrassBlock(String name, DataGenContext<Block, Block> ctx, RegistrateBlockModelGenerator prov) {
            prov.generateWithTemplate((Block)ctx.get(), ModelTemplates.CUBE_ALL, TextureMapping.cube((ResourceLocation)prov.modLoc("block/matted_" + name + "_top")));
        }

        private static void generateMattedSeagrassBlock(DataGenContext<Block, Block> ctx, RegistrateBlockModelGenerator prov) {
            ResourceLocation bottomTexture = TextureMapping.getBlockTexture((Block)((Block)PURIFIED_SAND.get()));
            prov.createTrivialBlock((Block)ctx.get(), TexturedModel.CUBE_TOP_BOTTOM.updateTexture(textures -> textures.put(TextureSlot.BOTTOM, bottomTexture)));
        }

        private static void generateJigarbovTorch(DataGenContext<Block, ? extends Block> ctx, RegistrateBlockModelGenerator prov, JigarbovTorchType type) {
            ResourceLocation etchTexture = prov.modLoc("block/jigarbov/" + type.getName());
            TextureMapping litTextures = new TextureMapping().put(TextureSlot.TORCH, prov.mcLoc("block/redstone_torch")).put(JIGARBOV_SLOT, etchTexture);
            MultiVariant litVariant = BlockModelGenerators.plainVariant((ResourceLocation)JIGARBOV_TORCH.create((Block)ctx.get(), litTextures, prov.modelOutput));
            TextureMapping unlitTextures = new TextureMapping().put(TextureSlot.TORCH, prov.mcLoc("block/redstone_torch_off")).put(JIGARBOV_SLOT, etchTexture);
            MultiVariant unlitVariant = BlockModelGenerators.plainVariant((ResourceLocation)JIGARBOV_TORCH_UNLIT.createWithSuffix((Block)ctx.get(), "_off", unlitTextures, prov.modelOutput));
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (MultiVariant)litVariant, (MultiVariant)unlitVariant)).with(BlockModelGenerators.ROTATION_TORCH));
        }

        private static void generateSlabBlock(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockModelGenerator prov, BlockEntry<? extends Block> block) {
            prov.generateSlabBlock((SlabBlock)ctx.get(), BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)((Block)block.get()))), prov.blockTexture((Block)block.get()));
        }

        private static void generateSapling(DataGenContext<Block, SaplingBlock> ctx, RegistrateBlockModelGenerator prov) {
            prov.createCrossBlock((Block)ctx.get(), BlockModelGenerators.PlantType.NOT_TINTED);
        }

        private static void generateMangroveRoots(DataGenContext<Block, MangroveRootsBlock> ctx, RegistrateBlockModelGenerator prov, String name) {
            ResourceLocation roots = prov.modLoc("block/" + name);
            TextureSlot rootsSlot = TextureSlot.create((String)"roots");
            TextureSlot appendagesSlot = TextureSlot.create((String)"appendages");
            ModelTemplate stemTemplate = ModelTemplates.create((String)Tropicraft.location("mangrove_roots/stem").toString(), (String)"_stem", (TextureSlot[])new TextureSlot[]{rootsSlot});
            ModelTemplate stemShortTemplate = ModelTemplates.create((String)Tropicraft.location("mangrove_roots/stem_short").toString(), (String)"_stem_short", (TextureSlot[])new TextureSlot[]{rootsSlot});
            ModelTemplate connectionLowTemplate = ModelTemplates.create((String)Tropicraft.location("mangrove_roots/connection_low").toString(), (String)"_connection_low", (TextureSlot[])new TextureSlot[]{rootsSlot});
            ModelTemplate connectionHighTemplate = ModelTemplates.create((String)Tropicraft.location("mangrove_roots/connection_high").toString(), (String)"_connection_high", (TextureSlot[])new TextureSlot[]{rootsSlot});
            ModelTemplate appendagesTemplate = ModelTemplates.create((String)Tropicraft.location("mangrove_roots/appendages").toString(), (TextureSlot[])new TextureSlot[]{appendagesSlot});
            TextureMapping rootsTextures = TextureMapping.singleSlot((TextureSlot)rootsSlot, (ResourceLocation)roots);
            MultiVariant stem = BlockModelGenerators.plainVariant((ResourceLocation)stemTemplate.create((Block)ctx.get(), rootsTextures, prov.modelOutput));
            MultiVariant stemShort = BlockModelGenerators.plainVariant((ResourceLocation)stemShortTemplate.create((Block)ctx.get(), rootsTextures, prov.modelOutput));
            MultiVariant connectionLow = BlockModelGenerators.plainVariant((ResourceLocation)connectionLowTemplate.create((Block)ctx.get(), rootsTextures, prov.modelOutput));
            MultiVariant connectionHigh = BlockModelGenerators.plainVariant((ResourceLocation)connectionHighTemplate.create((Block)ctx.get(), rootsTextures, prov.modelOutput));
            MultiVariant appendagesHigh = BlockModelGenerators.plainVariant((ResourceLocation)appendagesTemplate.createWithSuffix((Block)ctx.get(), "_appendages_high", TextureMapping.singleSlot((TextureSlot)appendagesSlot, (ResourceLocation)prov.modLoc("block/" + name + "_appendages_high")), prov.modelOutput));
            MultiVariant appendagesHighShort = BlockModelGenerators.plainVariant((ResourceLocation)appendagesTemplate.createWithSuffix((Block)ctx.get(), "_appendages_high_short", TextureMapping.singleSlot((TextureSlot)appendagesSlot, (ResourceLocation)prov.modLoc("block/" + name + "_appendages_high_short")), prov.modelOutput));
            MultiVariant appendagesGrounded = BlockModelGenerators.plainVariant((ResourceLocation)appendagesTemplate.createWithSuffix((Block)ctx.get(), "_appendages_ground", TextureMapping.singleSlot((TextureSlot)appendagesSlot, (ResourceLocation)prov.modLoc("block/" + name + "_appendages_ground")), prov.modelOutput));
            MultiVariant appendagesGroundedShort = BlockModelGenerators.plainVariant((ResourceLocation)appendagesTemplate.createWithSuffix((Block)ctx.get(), "_appendages_ground_short", TextureMapping.singleSlot((TextureSlot)appendagesSlot, (ResourceLocation)prov.modLoc("block/" + name + "_appendages_ground_short")), prov.modelOutput));
            MultiPartGenerator builder = MultiPartGenerator.multiPart((Block)((Block)ctx.get()));
            builder.with(BlockModelGenerators.condition().term((Property)MangroveRootsBlock.TALL, (Comparable)Boolean.valueOf(true)), stem);
            builder.with(BlockModelGenerators.condition().term((Property)MangroveRootsBlock.TALL, (Comparable)Boolean.valueOf(false)), stemShort);
            builder.with(BlockModelGenerators.condition().term((Property)MangroveRootsBlock.TALL, (Comparable)Boolean.valueOf(true)).term((Property)MangroveRootsBlock.GROUNDED, (Comparable)Boolean.valueOf(true)), appendagesGrounded);
            builder.with(BlockModelGenerators.condition().term((Property)MangroveRootsBlock.TALL, (Comparable)Boolean.valueOf(false)).term((Property)MangroveRootsBlock.GROUNDED, (Comparable)Boolean.valueOf(true)), appendagesGroundedShort);
            builder.with(BlockModelGenerators.condition().term((Property)MangroveRootsBlock.TALL, (Comparable)Boolean.valueOf(true)).term((Property)MangroveRootsBlock.GROUNDED, (Comparable)Boolean.valueOf(false)), appendagesHigh);
            builder.with(BlockModelGenerators.condition().term((Property)MangroveRootsBlock.TALL, (Comparable)Boolean.valueOf(false)).term((Property)MangroveRootsBlock.GROUNDED, (Comparable)Boolean.valueOf(false)), appendagesHighShort);
            for (int i = 0; i < 4; ++i) {
                EnumProperty<MangroveRootsBlock.Connection> connection = MangroveRootsBlock.CONNECTIONS[i];
                VariantMutator rotation = switch (i) {
                    case 0 -> BlockModelGenerators.Y_ROT_270;
                    case 1 -> BlockModelGenerators.NOP;
                    case 2 -> BlockModelGenerators.Y_ROT_90;
                    default -> BlockModelGenerators.Y_ROT_180;
                };
                builder.with(BlockModelGenerators.condition().term(connection, (Comparable)((Object)MangroveRootsBlock.Connection.HIGH)), connectionHigh.with(rotation.then(BlockModelGenerators.UV_LOCK)));
                builder.with(BlockModelGenerators.condition().term(connection, (Comparable)((Object)MangroveRootsBlock.Connection.LOW)), connectionLow.with(rotation.then(BlockModelGenerators.UV_LOCK)));
            }
            prov.blockStateOutput.accept(builder);
        }

        private static void generatePropagule(DataGenContext<Block, PropaguleBlock> ctx, RegistrateBlockModelGenerator prov) {
            prov.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)((Block)ctx.get())).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)PropaguleBlock.PLANTED, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.CROSS.createWithSuffix((Block)ctx.get(), "_planted", TextureMapping.cross((ResourceLocation)prov.modLoc("block/" + ctx.getName() + "_planted")), prov.modelOutput)), (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.CROSS.createWithSuffix((Block)ctx.get(), "_hanging", TextureMapping.cross((Block)((Block)ctx.get())), prov.modelOutput)))));
        }

        private static void generateBoardwalk(DataGenContext<Block, BoardwalkBlock> ctx, RegistrateBlockModelGenerator prov, Either<Supplier<Block>, ResourceLocation> texture) {
            Direction.Axis[] horizontals;
            TextureMapping textures = TextureMapping.singleSlot((TextureSlot)PLANKS_SLOT, (ResourceLocation)((ResourceLocation)texture.map(b -> ModelLocationUtils.getModelLocation((Block)((Block)b.get())), Function.identity())));
            ModelTemplate shortTemplate = ModelTemplates.create((String)Tropicraft.location("boardwalk/short").toString(), (String)"_short", (TextureSlot[])new TextureSlot[]{PLANKS_SLOT});
            ModelTemplate shortPostTemplate = ModelTemplates.create((String)Tropicraft.location("boardwalk/short_post").toString(), (String)"_short_post", (TextureSlot[])new TextureSlot[]{PLANKS_SLOT});
            ModelTemplate tallTemplate = ModelTemplates.create((String)Tropicraft.location("boardwalk/tall").toString(), (String)"_tall", (TextureSlot[])new TextureSlot[]{PLANKS_SLOT});
            ModelTemplate tallPostTemplate = ModelTemplates.create((String)Tropicraft.location("boardwalk/tall_post").toString(), (String)"_tall_post", (TextureSlot[])new TextureSlot[]{PLANKS_SLOT});
            ModelTemplate tallConnectionTemplate = ModelTemplates.create((String)Tropicraft.location("boardwalk/tall_connection").toString(), (String)"_tall_connection", (TextureSlot[])new TextureSlot[]{PLANKS_SLOT});
            MultiVariant shortModel = BlockModelGenerators.plainVariant((ResourceLocation)shortTemplate.create((Block)ctx.get(), textures, prov.modelOutput));
            MultiVariant shortPostModel = BlockModelGenerators.plainVariant((ResourceLocation)shortPostTemplate.create((Block)ctx.get(), textures, prov.modelOutput));
            MultiVariant tallModel = BlockModelGenerators.plainVariant((ResourceLocation)tallTemplate.create((Block)ctx.get(), textures, prov.modelOutput));
            MultiVariant tallPostModel = BlockModelGenerators.plainVariant((ResourceLocation)tallPostTemplate.create((Block)ctx.get(), textures, prov.modelOutput));
            MultiVariant tallConnectionModel = BlockModelGenerators.plainVariant((ResourceLocation)tallConnectionTemplate.create((Block)ctx.get(), textures, prov.modelOutput));
            MultiPartGenerator builder = MultiPartGenerator.multiPart((Block)((Block)ctx.get()));
            for (Direction.Axis axis : horizontals = new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z}) {
                VariantMutator rotation = axis == Direction.Axis.X ? BlockModelGenerators.Y_ROT_270 : BlockModelGenerators.NOP;
                VariantMutator reverseRotation = axis == Direction.Axis.X ? BlockModelGenerators.Y_ROT_90 : BlockModelGenerators.Y_ROT_180;
                builder.with(BlockModelGenerators.condition().term(BoardwalkBlock.TYPE, (Comparable)((Object)BoardwalkBlock.Type.SHORT), (Comparable[])new BoardwalkBlock.Type[]{BoardwalkBlock.Type.SHORT_POST}).term(BoardwalkBlock.AXIS, (Comparable)axis), shortModel.with(rotation).with(BlockModelGenerators.UV_LOCK));
                builder.with(BlockModelGenerators.condition().term(BoardwalkBlock.TYPE, (Comparable)((Object)BoardwalkBlock.Type.TALL), (Comparable[])new BoardwalkBlock.Type[]{BoardwalkBlock.Type.TALL_POST, BoardwalkBlock.Type.TALL_POST_FRONT, BoardwalkBlock.Type.TALL_POST_BACK, BoardwalkBlock.Type.TALL_POST_FRONT_BACK}).term(BoardwalkBlock.AXIS, (Comparable)axis), tallModel.with(rotation).with(BlockModelGenerators.UV_LOCK));
                builder.with(BlockModelGenerators.condition().term(BoardwalkBlock.TYPE, (Comparable)((Object)BoardwalkBlock.Type.TALL_POST_BACK), (Comparable[])new BoardwalkBlock.Type[]{BoardwalkBlock.Type.TALL_POST_FRONT_BACK}).term(BoardwalkBlock.AXIS, (Comparable)axis), tallConnectionModel.with(rotation).with(BlockModelGenerators.UV_LOCK));
                builder.with(BlockModelGenerators.condition().term(BoardwalkBlock.TYPE, (Comparable)((Object)BoardwalkBlock.Type.TALL_POST_FRONT), (Comparable[])new BoardwalkBlock.Type[]{BoardwalkBlock.Type.TALL_POST_FRONT_BACK}).term(BoardwalkBlock.AXIS, (Comparable)axis), tallConnectionModel.with(reverseRotation).with(BlockModelGenerators.UV_LOCK));
            }
            builder.with(BlockModelGenerators.condition().term(BoardwalkBlock.TYPE, (Comparable)((Object)BoardwalkBlock.Type.SHORT_POST)), shortPostModel);
            builder.with(BlockModelGenerators.condition().term(BoardwalkBlock.TYPE, (Comparable)((Object)BoardwalkBlock.Type.TALL_POST), (Comparable[])new BoardwalkBlock.Type[]{BoardwalkBlock.Type.TALL_POST_FRONT, BoardwalkBlock.Type.TALL_POST_BACK, BoardwalkBlock.Type.TALL_POST_FRONT_BACK}), tallPostModel);
            prov.blockStateOutput.accept(builder);
        }

        private static void generateDrinkMixerItem(DataGenContext<Item, BlockItem> ctx, RegistrateItemModelGenerator prov) {
            ResourceLocation baseModel = TALL_MACHINE.create((Item)ctx.get(), TextureMapping.particle((Block)((Block)CHUNK.get())), prov.modelOutput);
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.specialModel((ResourceLocation)baseModel, (SpecialModelRenderer.Unbaked)new DrinkMixerSpecialRenderer.Unbaked()));
        }

        private static void generateAirCompressorItem(DataGenContext<Item, BlockItem> ctx, RegistrateItemModelGenerator prov) {
            ResourceLocation baseModel = TALL_MACHINE.create((Item)ctx.get(), TextureMapping.particle((Block)((Block)CHUNK.get())), prov.modelOutput);
            prov.itemModelOutput.accept((Item)ctx.get(), ItemModelUtils.specialModel((ResourceLocation)baseModel, (SpecialModelRenderer.Unbaked)new AirCompressorSpecialRenderer.Unbaked()));
        }
    }
}

