/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class TropicraftLeavesBlock
extends LeavesBlock {
    public static final List<BlockPos> AROUND_OFFSETS = BlockPos.betweenClosedStream((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1).map(BlockPos::immutable).filter(pos -> !pos.equals((Object)BlockPos.ZERO)).toList();
    public static final List<BlockPos> INDIRECT_NEIGHBOR_OFFSETS = AROUND_OFFSETS.stream().filter(pos -> pos.distManhattan((Vec3i)BlockPos.ZERO) > 1).toList();
    public static final MapCodec<TropicraftLeavesBlock> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)ExtraCodecs.floatRange((float)0.0f, (float)1.0f).fieldOf("leaf_particle_chance").forGetter(b -> Float.valueOf(b.leafParticleChance)), (App)ParticleTypes.CODEC.fieldOf("leaf_particle").forGetter(b -> b.leafParticle), (App)TropicraftLeavesBlock.propertiesCodec()).apply((Applicative)i, TropicraftLeavesBlock::new));
    private final ParticleOptions leafParticle;

    public TropicraftLeavesBlock(float leafParticleChance, ParticleOptions leafParticle, BlockBehaviour.Properties properties) {
        super(leafParticleChance, properties);
        this.leafParticle = leafParticle;
    }

    public MapCodec<TropicraftLeavesBlock> codec() {
        return CODEC;
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlock(pos, TropicraftLeavesBlock.updateDistance(state, (LevelAccessor)level, pos), 3);
    }

    protected void updateIndirectNeighbourShapes(BlockState state, LevelAccessor level, BlockPos pos, int flags, int recursionLeft) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Vec3i vec3i : INDIRECT_NEIGHBOR_OFFSETS) {
            mutablePos.setWithOffset((Vec3i)pos, vec3i);
            if (!level.getBlockState((BlockPos)mutablePos).is((Block)this)) continue;
            level.neighborShapeChanged(Direction.DOWN, pos, (BlockPos)mutablePos, state, flags, recursionLeft);
        }
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        int newDistance;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        if ((newDistance = TropicraftLeavesBlock.getDistanceAt(neighborState) + 1) != 1 || (Integer)state.getValue((Property)DISTANCE) != newDistance) {
            scheduledTickAccess.scheduleTick(pos, (Block)this, 1);
        }
        return state;
    }

    private static BlockState updateDistance(BlockState state, LevelAccessor level, BlockPos pos) {
        int minDistance = 7;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Vec3i vec3i : AROUND_OFFSETS) {
            mutablePos.setWithOffset((Vec3i)pos, vec3i);
            if ((minDistance = Math.min(minDistance, TropicraftLeavesBlock.getDistanceAt(level.getBlockState((BlockPos)mutablePos)) + 1)) != 1) continue;
            break;
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(minDistance));
    }

    private static int getDistanceAt(BlockState neighbor) {
        return TropicraftLeavesBlock.getOptionalDistanceAt((BlockState)neighbor).orElse(7);
    }

    protected void spawnFallingLeavesParticle(Level level, BlockPos pos, RandomSource random) {
        ParticleUtils.spawnParticleBelow((Level)level, (BlockPos)pos, (RandomSource)random, (ParticleOptions)this.leafParticle);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        return TropicraftLeavesBlock.updateDistance(blockState, (LevelAccessor)context.getLevel(), context.getClickedPos());
    }
}

