/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.tropicraft.core.common.block.BlockTropicraftSand;

public class VolcanicSandBlock
extends BlockTropicraftSand {
    public static final MapCodec<VolcanicSandBlock> CODEC = VolcanicSandBlock.simpleCodec(VolcanicSandBlock::new);
    public static final BooleanProperty HOT = BooleanProperty.create((String)"hot");

    public VolcanicSandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HOT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<VolcanicSandBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HOT});
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (((Boolean)state.getValue((Property)HOT)).booleanValue() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                ItemStack stack = living.getItemBySlot(EquipmentSlot.FEET);
                if (stack.isEmpty()) {
                    living.hurtServer(serverLevel, entity.damageSources().lava(), 0.5f);
                }
            } else {
                entity.hurtServer(serverLevel, entity.damageSources().lava(), 0.5f);
            }
        }
    }
}

