/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.huge_plant;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;

@EventBusSubscriber(modid="tropicraft", value={Dist.CLIENT})
public final class HugePlantBlockHighlight {
    @SubscribeEvent
    public static void onHighlightBlock(RenderHighlightEvent.Block event) {
        ClientLevel world = Minecraft.getInstance().level;
        if (world == null) {
            return;
        }
        BlockPos pos = event.getTarget().getBlockPos();
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() instanceof HugePlantBlock) {
            HugePlantBlockHighlight.renderHugePlantHighlight(event, world, pos, state);
        }
    }

    private static void renderHugePlantHighlight(RenderHighlightEvent.Block event, ClientLevel world, BlockPos pos, BlockState state) {
        HugePlantBlock.Shape shape = HugePlantBlock.Shape.matchIncomplete(state.getBlock(), (BlockGetter)world, pos);
        if (shape == null) {
            return;
        }
        VertexConsumer builder = event.getMultiBufferSource().getBuffer(RenderType.lines());
        Vec3 view = event.getCamera().getPosition();
        AABB aabb = shape.asAabb().move(-view.x, -view.y, -view.z);
        ShapeRenderer.renderLineBox((PoseStack)event.getPoseStack(), (VertexConsumer)builder, (AABB)aabb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        event.setCanceled(true);
    }
}

