/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.jigarbov;

import com.tterrag.registrate.util.entry.BlockEntry;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.jigarbov.JigarbovTorchType;

@EventBusSubscriber(modid="tropicraft")
public final class JigarbovTorchPlacement {
    @SubscribeEvent
    public static void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        BlockEntry<? extends RedstoneWallTorchBlock> jigarbovTorchBlock;
        BlockState placedState = event.getPlacedBlock();
        Block placedBlock = placedState.getBlock();
        if (placedBlock == Blocks.REDSTONE_WALL_TORCH && (jigarbovTorchBlock = JigarbovTorchPlacement.getJigarbovTorchFor(event.getPlacedAgainst().getBlock())) != null) {
            BlockState jigarbovTorch = ((RedstoneWallTorchBlock)jigarbovTorchBlock.get()).defaultBlockState();
            jigarbovTorch = JigarbovTorchPlacement.copyPropertiesTo(jigarbovTorch, placedState);
            event.getLevel().setBlock(event.getPos(), jigarbovTorch, 3);
        }
    }

    @Nullable
    private static BlockEntry<? extends RedstoneWallTorchBlock> getJigarbovTorchFor(Block placedAgainst) {
        JigarbovTorchType type = JigarbovTorchType.byBlock(placedAgainst);
        return type != null ? TropicraftBlocks.JIGARBOV_WALL_TORCHES.get((Object)type) : null;
    }

    private static BlockState copyPropertiesTo(BlockState to, BlockState from) {
        for (Property property : from.getProperties()) {
            to = JigarbovTorchPlacement.copyPropertyTo(to, from, property);
        }
        return to;
    }

    private static <T extends Comparable<T>> BlockState copyPropertyTo(BlockState to, BlockState from, Property<T> property) {
        if (to.hasProperty(property)) {
            return (BlockState)to.setValue(property, from.getValue(property));
        }
        return to;
    }
}

