/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.jigarbov;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.tropicraft.core.common.block.TropicraftBlocks;

public enum JigarbovTorchType implements StringRepresentable
{
    ACACIA("acacia", () -> Blocks.ACACIA_LOG),
    BIRCH("birch", () -> Blocks.BIRCH_LOG),
    DARK_OAK("dark_oak", () -> Blocks.DARK_OAK_LOG),
    JUNGLE("jungle", () -> Blocks.JUNGLE_LOG),
    OAK("oak", () -> Blocks.OAK_LOG),
    SPRUCE("spruce", () -> Blocks.SPRUCE_LOG),
    BLACK_MANGROVE("black_mangrove", (Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_LOG),
    LIGHT_MANGROVE("light_mangrove", (Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_LOG),
    RED_MANGROVE("red_mangrove", (Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_LOG);

    private static final JigarbovTorchType[] VALUES;
    private final String name;
    private final Supplier<? extends Block> log;

    private JigarbovTorchType(String name, Supplier<? extends Block> log) {
        this.name = name;
        this.log = log;
    }

    @Nullable
    public static JigarbovTorchType byBlock(Block block) {
        if (block.defaultBlockState().is(BlockTags.LOGS)) {
            for (JigarbovTorchType type : VALUES) {
                if (!type.matchesLog(block)) continue;
                return type;
            }
            return OAK;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean matchesLog(Block block) {
        return this.log.get() == block;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        VALUES = JigarbovTorchType.values();
    }
}

