/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.network.PacketDistributor;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.tileentity.IMachineBlock;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.network.message.ClientboundAirCompressorInventoryPacket;

public class AirCompressorBlockEntity
extends BlockEntity
implements IMachineBlock {
    private boolean compressing;
    private int ticks;
    private static final int fillRate = 5;
    private ItemStack stack = ItemStack.EMPTY;
    @Nullable
    private ScubaArmorItem tank;

    public AirCompressorBlockEntity(BlockEntityType<AirCompressorBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.compressing = input.getBooleanOr("Compressing", false);
        this.setTank(input.read("Tank", ItemStack.CODEC).orElse(ItemStack.EMPTY));
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putBoolean("Compressing", this.compressing);
        if (!this.stack.isEmpty()) {
            output.store("Tank", ItemStack.CODEC, (Object)this.stack);
        }
    }

    public void setTank(ItemStack tankItemStack) {
        this.stack = tankItemStack;
        this.tank = !(this.stack.getItem() instanceof ScubaArmorItem) ? null : (ScubaArmorItem)this.stack.getItem();
    }

    public ItemStack getTankStack() {
        return this.stack;
    }

    @Nullable
    public ScubaArmorItem getTank() {
        return this.tank;
    }

    public static void compressTick(Level level, BlockPos pos, BlockState state, AirCompressorBlockEntity te) {
        te.tick();
    }

    private void tick() {
        if (this.tank == null) {
            return;
        }
        int airContained = this.tank.getRemainingAir(this.getTankStack());
        int maxAir = this.tank.getMaxAir(this.getTankStack());
        if (this.compressing) {
            int overflow = this.tank.addAir(5, this.getTankStack());
            ++this.ticks;
            if (overflow > 0) {
                this.finishCompressing();
            }
        }
    }

    public boolean addTank(ItemStack stack) {
        if (this.tank == null && stack.getItem() instanceof ScubaArmorItem && ((ScubaArmorItem)stack.getItem()).providesAir()) {
            this.setTank(stack);
            this.compressing = true;
            this.syncInventory();
            return true;
        }
        return false;
    }

    public void ejectTank() {
        if (!this.stack.isEmpty() && !this.level.isClientSide) {
            ItemEntity tankItem = new ItemEntity(this.level, (double)this.getBlockPos().getX(), (double)this.getBlockPos().getY(), (double)this.getBlockPos().getZ(), this.stack);
            this.level.addFreshEntity((Entity)tankItem);
        }
        this.setTank(ItemStack.EMPTY);
        this.syncInventory();
        this.ticks = 0;
        this.compressing = false;
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.ejectTank();
    }

    public boolean isDoneCompressing() {
        return this.ticks == 0 && !this.compressing && this.tank != null;
    }

    public float getTickRatio(float partialTicks) {
        if (this.tank != null) {
            return ((float)this.ticks + partialTicks) / (float)(this.tank.getMaxAir(this.getTankStack()) * 5);
        }
        return 0.0f;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void startCompressing() {
        this.compressing = true;
        this.syncInventory();
    }

    public void finishCompressing() {
        this.compressing = false;
        this.ticks = 0;
        this.syncInventory();
    }

    public float getBreatheProgress(float partialTicks) {
        if (this.isDoneCompressing()) {
            return 0.0f;
        }
        return (float)(((double)(((float)this.ticks + partialTicks) / 20.0f) * Math.PI + Math.PI) % (Math.PI * 2));
    }

    @Override
    public boolean isActive() {
        return !this.getTankStack().isEmpty();
    }

    @Override
    public float getProgress(float partialTicks) {
        return this.getTickRatio(partialTicks);
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.getValue(AirCompressorBlock.FACING);
    }

    public void onDataPacket(Connection net, ValueInput input) {
        this.loadAdditional(input);
    }

    protected void syncInventory() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)serverLevel, (ChunkPos)new ChunkPos(this.getBlockPos()), (CustomPacketPayload)new ClientboundAirCompressorInventoryPacket(this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }
}

