/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class BambooChestBlockEntity
extends ChestBlockEntity {
    private boolean unbreakable = false;

    public BambooChestBlockEntity(BlockEntityType<BambooChestBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public Component getName() {
        return Component.translatable((String)"tropicraft.container.bambooChest");
    }

    protected Component getDefaultName() {
        return this.getName();
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.unbreakable = input.getBooleanOr("unbreakable", false);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        output.putBoolean("unbreakable", this.unbreakable);
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setIsUnbreakable(boolean flag) {
        this.unbreakable = flag;
    }
}

